/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.adaptor.MSAnnotationExportFileAdapter;
import org.grits.toolbox.entry.ms.annotation.dialog.FilterDialog;

public class MSAnnotationExportDialog
extends ModalDialog {
    protected String[] downloadOptions = new String[]{"Export GRITS Archive file", "Export Excel file", "Export into Byonic database", "Export into a new GELATO database"};
    private Button OKbutton;
    private Entry msAnnotationEntry;
    protected List downloadlist;
    private String sSelected;
    private MSAnnotationExportFileAdapter msAnnotationExportFileAdapter;
    private MSAnnotationTableDataObject tableDataObject = null;
    private int iMasterParentScan = -1;
    private int m_lastVisibleColInx = -1;
    protected Text txtOutput;
    FilterDialog filtering;
    private Button btnFilteringSettings;
    protected SelectionListener downloadlistListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (MSAnnotationExportDialog.this.downloadlist.getSelectionIndex() != -1) {
                MSAnnotationExportDialog.this.OKbutton.setEnabled(true);
                MSAnnotationExportDialog.this.sSelected = MSAnnotationExportDialog.this.downloadlist.getItem(MSAnnotationExportDialog.this.downloadlist.getSelectionIndex()).toString();
                if (MSAnnotationExportDialog.this.sSelected.equals(MSAnnotationExportDialog.this.downloadOptions[0])) {
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setFileExtension(MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.getArchiveExtension());
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setExportType(ExportTypes.Archive);
                    if (MSAnnotationExportDialog.this.btnFilteringSettings != null) {
                        MSAnnotationExportDialog.this.btnFilteringSettings.setEnabled(false);
                    }
                } else if (MSAnnotationExportDialog.this.sSelected.equals(MSAnnotationExportDialog.this.downloadOptions[1])) {
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setFileExtension(".xls");
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setExportType(ExportTypes.Excel);
                    if (MSAnnotationExportDialog.this.btnFilteringSettings != null) {
                        MSAnnotationExportDialog.this.btnFilteringSettings.setEnabled(true);
                    }
                } else if (MSAnnotationExportDialog.this.sSelected.equals(MSAnnotationExportDialog.this.downloadOptions[2])) {
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setFileExtension(".txt");
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setExportType(ExportTypes.Byonic);
                    if (MSAnnotationExportDialog.this.btnFilteringSettings != null) {
                        MSAnnotationExportDialog.this.btnFilteringSettings.setEnabled(false);
                    }
                } else if (MSAnnotationExportDialog.this.sSelected.equals(MSAnnotationExportDialog.this.downloadOptions[3])) {
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setFileExtension(".xml");
                    MSAnnotationExportDialog.this.msAnnotationExportFileAdapter.setExportType(ExportTypes.Database);
                    if (MSAnnotationExportDialog.this.btnFilteringSettings != null) {
                        MSAnnotationExportDialog.this.btnFilteringSettings.setEnabled(false);
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public MSAnnotationExportDialog(Shell parentShell, MSAnnotationExportFileAdapter msAnnotationExportFileAdapter) {
        super(parentShell);
        this.msAnnotationExportFileAdapter = msAnnotationExportFileAdapter;
    }

    public void create() {
        super.create();
        this.setTitle("Export");
        this.setMessage("Export an archive or excel file");
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        this.txtOutput = new Text(parent, 2122);
        this.txtOutput.setText("Please select export type and specify filter parameters.\nFilter parameters apply only to " + (Object)((Object)ExportTypes.Excel) + "Export\n");
        this.txtOutput.setFont(this.boldFont);
        this.txtOutput.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridDataTxtOutput = new GridData(768);
        gridDataTxtOutput.horizontalSpan = 4;
        gridDataTxtOutput.verticalSpan = 2;
        this.txtOutput.setLayoutData((Object)gridDataTxtOutput);
        this.createList(parent);
        this.createFilters(parent);
        this.createButtonCancel(parent);
        this.createButtonOK(parent);
        return parent;
    }

    protected void createList(Composite parent2) {
        this.downloadlist = new List(parent2, 4);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        this.downloadlist.setLayoutData((Object)gridData);
        this.setDownloadOptions(this.downloadlist);
        this.downloadlist.addSelectionListener(this.downloadlistListener);
    }

    protected void setDownloadOptions(List downloadlist) {
        downloadlist.add(this.downloadOptions[0]);
        downloadlist.add(this.downloadOptions[1]);
        downloadlist.add(this.downloadOptions[2]);
        downloadlist.add(this.downloadOptions[3]);
    }

    protected void createFilters(Composite parent) {
        this.btnFilteringSettings = new Button(parent, 0);
        this.btnFilteringSettings.setEnabled(false);
        this.filtering = this.getNewFilterDialog();
        this.btnFilteringSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MSAnnotationExportDialog.this.filtering != null) {
                    MSAnnotationExportDialog.this.filtering.open();
                }
            }
        });
        this.btnFilteringSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.btnFilteringSettings.setText("Filtering Settings");
    }

    protected FilterDialog getNewFilterDialog() {
        return new FilterDialog(this.getParentShell());
    }

    protected Button createButtonOK(Composite parent2) {
        GridData okData = new GridData(0x1000008);
        okData.horizontalSpan = 2;
        okData.widthHint = 100;
        this.OKbutton = new Button(parent2, 8);
        this.OKbutton.setText("Export");
        this.msAnnotationExportFileAdapter.setShell(parent2.getShell());
        this.msAnnotationExportFileAdapter.setMSAnnotationEntry(this.msAnnotationEntry);
        this.msAnnotationExportFileAdapter.setTableDataObject(this.tableDataObject);
        this.msAnnotationExportFileAdapter.setMasterParentScan(this.getMasterParentScan());
        this.msAnnotationExportFileAdapter.setLastVisibleColInx(this.m_lastVisibleColInx);
        this.msAnnotationExportFileAdapter.setFileExtension("");
        this.OKbutton.addSelectionListener((SelectionListener)this.msAnnotationExportFileAdapter);
        this.OKbutton.setLayoutData((Object)okData);
        this.OKbutton.setEnabled(false);
        if (this.filtering != null) {
            this.filtering.setExportFileAdapter(this.msAnnotationExportFileAdapter);
        }
        return this.OKbutton;
    }

    protected boolean isValidInput() {
        return true;
    }

    protected Entry createEntry() {
        return this.msAnnotationEntry;
    }

    public void setMSAnnotationEntry(Entry msAnnotationEntry) {
        this.msAnnotationEntry = msAnnotationEntry;
    }

    public void setTableDataObject(MSAnnotationTableDataObject tableDataObject) {
        this.tableDataObject = tableDataObject;
    }

    public MSAnnotationTableDataObject getTableDataObject() {
        return this.tableDataObject;
    }

    public int getMasterParentScan() {
        return this.iMasterParentScan;
    }

    public void setMasterParentScan(int iMasterParentScan) {
        this.iMasterParentScan = iMasterParentScan;
    }

    public int getLastVisibleColInx() {
        return this.m_lastVisibleColInx;
    }

    public void setLastVisibleColInx(int m_lastVisibleColInx) {
        this.m_lastVisibleColInx = m_lastVisibleColInx;
    }

    public static enum ExportTypes {
        Excel,
        TSV,
        Archive,
        Byonic,
        Database;

    }
}

