/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.adaptor;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.CopyUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.adaptor.DatabaseDialog;
import org.grits.toolbox.entry.ms.annotation.dialog.MSAnnotationExportDialog;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportByonicProcess;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportDatabaseProcess;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportProcess;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.ProgressThread;

public class MSAnnotationExportFileAdapter
extends SelectionAdapter {
    private static final Logger logger = Logger.getLogger(MSAnnotationExportFileAdapter.class);
    protected Shell shell = null;
    protected String fileExtension = null;
    protected Entry msAnnotationEntry = null;
    protected String sOutputFile = null;
    protected MSAnnotationExportDialog.ExportTypes exportType;
    protected MSAnnotationTableDataObject tableDataObject = null;
    protected int iMasterParentScan = -1;
    protected int m_lastVisibleColInx = -1;
    protected String filterColumn;
    protected int numTopHits;
    protected double thresholdValue;

    protected MSAnnotationProperty getProperty() {
        MSAnnotationEntityProperty entityProp = (MSAnnotationEntityProperty)this.msAnnotationEntry.getProperty();
        MSAnnotationProperty property = (MSAnnotationProperty)entityProp.getParentProperty();
        return property;
    }

    protected String getValidFileName(String _sFileName) {
        String sNewString = _sFileName.replaceAll("\\:", "");
        sNewString = sNewString.replaceAll("\\[", "(");
        sNewString = sNewString.replaceAll("\\]", ")");
        sNewString = sNewString.replaceAll("\\>", "-");
        return sNewString;
    }

    protected String getId() {
        MSAnnotationProperty property = this.getProperty();
        String id = property.getMSAnnotationMetaData().getAnnotationId();
        return id;
    }

    public String getArchiveFolder() {
        MSAnnotationProperty property = this.getProperty();
        String folder = property.getArchiveFolder();
        return folder;
    }

    public String getArchiveExtension() {
        MSAnnotationProperty property = this.getProperty();
        String folder = property.getArchiveExtension();
        return folder;
    }

    protected String getFullyQualifiedArchivePath() {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)this.msAnnotationEntry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String id = this.getId();
        String from = String.valueOf(workspaceLocation) + projectName + File.separator + this.getArchiveFolder() + File.separator + id + this.fileExtension;
        return from;
    }

    public void widgetSelected(SelectionEvent event) {
        FileDialog dlg = new FileDialog(this.shell, 8192);
        String sFileName = this.getValidFileName(String.valueOf(this.msAnnotationEntry.getDisplayName()) + this.fileExtension);
        dlg.setFileName(sFileName);
        dlg.setFilterExtensions(new String[]{"*" + this.fileExtension});
        dlg.setText("File Explorer");
        boolean bDone = false;
        while (!bDone) {
            this.sOutputFile = dlg.open();
            try {
                if (this.sOutputFile != null) {
                    int iRes = 32;
                    File f = new File(this.sOutputFile);
                    if (f.exists()) {
                        String sEMsg = this.exportType == MSAnnotationExportDialog.ExportTypes.Archive ? "The selected export project path exists." : "The selected export file exists.";
                        iRes = ErrorUtils.createMultiConfirmationMessageBoxReturn((Shell)Display.getCurrent().getActiveShell(), (String)sEMsg, (String)"Overwrite?", (boolean)false);
                    }
                    if (iRes == 32) {
                        if (this.exportType == MSAnnotationExportDialog.ExportTypes.Archive) {
                            String sPath = this.getFullyQualifiedArchivePath();
                            CopyUtils.copyFilesFromTo((String)sPath, (String)this.sOutputFile);
                        } else if (this.exportType == MSAnnotationExportDialog.ExportTypes.Excel) {
                            this.exportExcel();
                        } else if (this.exportType == MSAnnotationExportDialog.ExportTypes.Byonic) {
                            this.exportByonic();
                        } else if (this.exportType == MSAnnotationExportDialog.ExportTypes.Database) {
                            this.exportDatabase();
                        }
                    }
                    if (iRes == 128) continue;
                    bDone = true;
                    this.shell.close();
                    continue;
                }
                bDone = true;
            }
            catch (NullPointerException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to save file", (Exception)e);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to save file", (Exception)e);
            }
            catch (JAXBException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to save file", (Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to save file", (Exception)e);
            }
        }
    }

    private void exportDatabase() {
        DatabaseDialog databaseDialog = new DatabaseDialog(this.shell);
        if (databaseDialog.open() == 0) {
            ProgressDialog t_dialog = new ProgressDialog(this.shell);
            MSAnnotationExportDatabaseProcess t_worker = this.getNewExportDatabaseProcess();
            t_worker.setOutputFile(this.sOutputFile);
            t_worker.setDbName(databaseDialog.getName());
            t_worker.setDescription(databaseDialog.getDescription());
            t_worker.setVersion(databaseDialog.getVersion());
            t_worker.setTableDataObject(this.getTableDataObject());
            t_worker.setMasterParentScan(this.getMasterParentScan());
            t_worker.setLastVisibleColInx(this.getLastVisibleColInx());
            t_dialog.setWorker((ProgressThread)t_worker);
            if (t_dialog.open() != 32) {
                new File(this.sOutputFile).delete();
            }
        }
    }

    protected MSAnnotationExportDatabaseProcess getNewExportDatabaseProcess() {
        return new MSAnnotationExportDatabaseProcess();
    }

    protected void exportByonic() throws IOException, Exception {
        ProgressDialog t_dialog = new ProgressDialog(this.shell);
        MSAnnotationExportByonicProcess t_worker = this.getNewExportByonicProcess();
        t_worker.setOutputFile(this.sOutputFile);
        t_worker.setTableDataObject(this.getTableDataObject());
        t_worker.setMasterParentScan(this.getMasterParentScan());
        t_worker.setLastVisibleColInx(this.getLastVisibleColInx());
        t_dialog.setWorker((ProgressThread)t_worker);
        if (t_dialog.open() != 32) {
            new File(this.sOutputFile).delete();
        }
    }

    protected MSAnnotationExportByonicProcess getNewExportByonicProcess() {
        return new MSAnnotationExportByonicProcess();
    }

    protected MSAnnotationExportProcess getNewExportProcess() {
        return new MSAnnotationExportProcess();
    }

    protected void exportExcel() throws IOException, Exception {
        ProgressDialog t_dialog = new ProgressDialog(this.shell);
        MSAnnotationExportProcess t_worker = this.getNewExportProcess();
        t_worker.setOutputFile(this.sOutputFile);
        t_worker.setTableDataObject(this.getTableDataObject());
        t_worker.setMasterParentScan(this.getMasterParentScan());
        t_worker.setLastVisibleColInx(this.getLastVisibleColInx());
        t_dialog.setWorker((ProgressThread)t_worker);
        if (t_dialog.open() != 32) {
            new File(this.sOutputFile).delete();
        }
    }

    public MSAnnotationTableDataObject getTableDataObject() {
        return this.tableDataObject;
    }

    public void setTableDataObject(MSAnnotationTableDataObject tableDataObject) {
        this.tableDataObject = tableDataObject;
    }

    public int getMasterParentScan() {
        return this.iMasterParentScan;
    }

    public void setMasterParentScan(int iMasterParentScan) {
        this.iMasterParentScan = iMasterParentScan;
    }

    public void setLastVisibleColInx(int m_lastVisibleColInx) {
        this.m_lastVisibleColInx = m_lastVisibleColInx;
    }

    public int getLastVisibleColInx() {
        return this.m_lastVisibleColInx;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setMSAnnotationEntry(Entry msannotationEntry) {
        this.msAnnotationEntry = msannotationEntry;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getDir() {
        return this.sOutputFile;
    }

    public void setExportType(MSAnnotationExportDialog.ExportTypes exportType) {
        this.exportType = exportType;
    }

    public void setFilterColumn(String filterKey) {
        this.filterColumn = filterKey;
    }

    public void setTopHits(int numTopHits) {
        this.numTopHits = numTopHits;
    }

    public void setThresholdValue(double thresholdValue) {
        this.thresholdValue = thresholdValue;
    }
}

