/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.grits.toolbox.core.utilShare.ResourceLocatorUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabase;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.utils.GlycanStructureDatabaseIndex;
import org.grits.toolbox.tools.gsl.database.LipidDatabaseIndex;
import org.grits.toolbox.tools.gsl.database.LipidDatabaseList;

public class DatabaseUtilsForGSL {
    private static final String DATABASE_FOLDER = "/databases";
    private static final String GLYCAN_INDEX_FILE = "GlycanDatabases.index";
    private static final String LIPID_LIST_FILE = "LipidDatabases.index";
    private static String DATABASE_PATH = null;

    public static GlycanStructureDatabaseIndex getGelatoDatabases() throws IOException, JAXBException {
        String t_path = DatabaseUtilsForGSL.getDatabasePath();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanStructureDatabaseIndex.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        GlycanStructureDatabaseIndex t_index = (GlycanStructureDatabaseIndex)jaxbUnmarshaller.unmarshal(new File(String.valueOf(t_path) + File.separator + GLYCAN_INDEX_FILE));
        for (GlycanStructureDatabase t_database : t_index.getDatabase()) {
            t_database.setPath(String.valueOf(t_path) + File.separator + t_database.getFileName());
        }
        return t_index;
    }

    public static LipidDatabaseList getLipidDatabases() throws IOException, JAXBException {
        String t_path = DatabaseUtilsForGSL.getDatabasePath();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LipidDatabaseList.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        LipidDatabaseList t_list = (LipidDatabaseList)jaxbUnmarshaller.unmarshal(new File(String.valueOf(t_path) + File.separator + LIPID_LIST_FILE));
        for (LipidDatabaseIndex t_index : t_list.getIndices()) {
            t_index.setPath(String.valueOf(t_path) + File.separator + t_index.getFileName());
        }
        return t_list;
    }

    public static String getDatabasePath() throws IOException {
        if (DATABASE_PATH == null) {
            DATABASE_PATH = ResourceLocatorUtils.getLegalPathOfResource((Object)new DatabaseUtilsForGSL(), (String)DATABASE_FOLDER);
        }
        return DATABASE_PATH;
    }
}

