/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.map.analysis.MAPConnectionComparatorForMAPGraph;
import org.glycoinfo.WURCSFramework.util.map.analysis.MAPStarComparator;
import org.glycoinfo.WURCSFramework.util.map.analysis.cip.MAPStereochemistryCheckerUsingCIPSystem;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomCyclic;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStar;

public class MAPGraphNormalizer {
    private MAPGraph m_oGraph;
    private MAPGraph m_oResult;
    private boolean m_bHasChangedStarIndices;
    private boolean m_bIsReorderedMAPGraph;
    private boolean m_bHasChangedStereo;

    public MAPGraphNormalizer(MAPGraph a_oGraph) {
        this.m_oGraph = a_oGraph;
        this.m_oResult = null;
        this.m_bHasChangedStarIndices = false;
        this.m_bIsReorderedMAPGraph = false;
    }

    public MAPGraph getNormalizedGraph() {
        return this.m_oResult;
    }

    public boolean hasChangedStarIndices() {
        return this.m_bHasChangedStarIndices;
    }

    public boolean hasReorderedMAPGraph() {
        return this.m_bIsReorderedMAPGraph;
    }

    public boolean hasChangedStereo() {
        return this.m_bHasChangedStereo;
    }

    public void start() {
        MAPGraph t_oNoParentGraph = this.copyGraphWithNoParentConnections(this.m_oGraph);
        MAPStereochemistryCheckerUsingCIPSystem t_oStereoCheck = new MAPStereochemistryCheckerUsingCIPSystem(t_oNoParentGraph);
        t_oStereoCheck.resetStereo();
        LinkedList<MAPStar> t_aStars = this.orderStarIndices(t_oNoParentGraph);
        MAPStar t_oHeadStar = t_aStars.getFirst();
        LinkedList<MAPConnection> t_aOrderedConns = this.orderConnections(t_oHeadStar, t_oNoParentGraph);
        MAPGraph t_oResultGraph = new MAPGraph();
        t_oResultGraph.addAtom(t_oHeadStar);
        for (MAPConnection t_oConn : t_aOrderedConns) {
            MAPAtomAbstract t_oAtom = t_oConn.getAtom();
            MAPConnection t_oParentConn = t_oConn.getReverse();
            t_oAtom.getChildConnections().remove(t_oParentConn);
            if (t_oResultGraph.getAtoms().contains(t_oAtom)) {
                t_oAtom = new MAPAtomCyclic(t_oAtom);
            }
            t_oAtom.setParentConnection(t_oParentConn);
            t_oResultGraph.addAtom(t_oAtom);
        }
        this.m_oResult = t_oResultGraph;
    }

    public MAPGraph copyGraphWithNoParentConnections(MAPGraph a_oGraph) {
        MAPGraph t_oCopyGraph = new MAPGraph();
        HashMap<MAPAtomAbstract, MAPAtomAbstract> t_mapOrigToCopyAtom = new HashMap<MAPAtomAbstract, MAPAtomAbstract>();
        for (MAPAtomAbstract t_oAtom : a_oGraph.getAtoms()) {
            MAPAtomAbstract t_oCopy = t_oAtom.copy();
            if (t_oAtom instanceof MAPAtomCyclic) {
                t_oCopy = (MAPAtomAbstract)t_mapOrigToCopyAtom.get(((MAPAtomCyclic)t_oAtom).getCyclicAtom());
            }
            if (t_oAtom.isAromatic()) {
                t_oCopy.setAromatic();
            }
            t_mapOrigToCopyAtom.put(t_oAtom, t_oCopy);
        }
        HashMap<Object, MAPConnection> t_mapOrigToCopyConn = new HashMap<Object, MAPConnection>();
        for (MAPAtomAbstract t_oAtom : a_oGraph.getAtoms()) {
            MAPStar t_oStar;
            MAPAtomAbstract t_oCopy = (MAPAtomAbstract)t_mapOrigToCopyAtom.get(t_oAtom);
            if (t_oAtom.getParentConnection() != null) {
                MAPConnection t_oConn = t_oAtom.getParentConnection();
                MAPAtomAbstract t_oCopyConnAtom = (MAPAtomAbstract)t_mapOrigToCopyAtom.get(t_oConn.getAtom());
                MAPConnection t_oCopyConn = t_oConn.copy(t_oCopyConnAtom);
                t_oCopy.addChildConnection(t_oCopyConn);
                t_mapOrigToCopyConn.put(t_oConn, t_oCopyConn);
                MAPConnection t_oCopyRev = (MAPConnection)t_mapOrigToCopyConn.get(t_oConn.getReverse());
                t_oCopyConn.setReverse(t_oCopyRev);
                t_oCopyRev.setReverse(t_oCopyConn);
            }
            for (MAPConnection t_oConn : t_oAtom.getChildConnections()) {
                MAPAtomAbstract t_oCopyConnAtom = (MAPAtomAbstract)t_mapOrigToCopyAtom.get(t_oConn.getAtom());
                MAPConnection t_oCopyConn = t_oConn.copy(t_oCopyConnAtom);
                t_oCopy.addChildConnection(t_oCopyConn);
                t_mapOrigToCopyConn.put(t_oConn, t_oCopyConn);
            }
            if (!t_oCopyGraph.getAtoms().contains(t_oCopy)) {
                t_oCopyGraph.addAtom(t_oCopy);
            }
            if (!(t_oCopy instanceof MAPStar) || (t_oStar = (MAPStar)t_oCopy).getConnections().isEmpty()) continue;
            t_oStar.setConnection(t_oStar.getConnections().getFirst());
        }
        return t_oCopyGraph;
    }

    private LinkedList<MAPStar> orderStarIndices(MAPGraph a_oGraph) {
        LinkedList<MAPStar> t_aStars = a_oGraph.getStars();
        MAPStarComparator t_oStarComp = new MAPStarComparator(a_oGraph);
        Collections.sort(t_aStars, t_oStarComp);
        HashMap<MAPStar, Integer> t_mapStarToIndex = new HashMap<MAPStar, Integer>();
        int t_iIndex = 1;
        t_mapStarToIndex.put(t_aStars.getFirst(), t_iIndex);
        int t_nCarbons = t_aStars.size();
        for (int i = 0; i < t_nCarbons - 1; ++i) {
            MAPStar t_oCj;
            MAPStar t_oCi = t_aStars.get(i);
            int t_iComp = t_oStarComp.compare(t_oCi, t_oCj = t_aStars.get(i + 1));
            if (t_iComp != 0) {
                ++t_iIndex;
            }
            t_mapStarToIndex.put(t_oCj, t_iIndex);
        }
        if (t_iIndex == 1) {
            for (MAPStar t_oC : t_aStars) {
                t_mapStarToIndex.put(t_oC, 0);
            }
        }
        for (MAPStar t_oC : t_aStars) {
            if (t_oC.getStarIndex() == ((Integer)t_mapStarToIndex.get(t_oC)).intValue()) continue;
            this.m_bHasChangedStarIndices = true;
        }
        if (this.m_bHasChangedStarIndices) {
            for (MAPStar t_oC : t_aStars) {
                t_oC.setStarIndex((Integer)t_mapStarToIndex.get(t_oC));
            }
        }
        return t_aStars;
    }

    private LinkedList<MAPConnection> orderConnections(MAPAtomAbstract a_oStart, MAPGraph a_oGraph) {
        if (a_oStart.getConnections().isEmpty()) {
            return new LinkedList<MAPConnection>();
        }
        LinkedList<MAPConnection> t_aTraversedConnections = new LinkedList<MAPConnection>();
        LinkedList<MAPAtomAbstract> t_aTraversedAtoms = new LinkedList<MAPAtomAbstract>();
        t_aTraversedAtoms.addLast(a_oStart);
        t_aTraversedConnections.addLast(a_oStart.getConnections().getFirst());
        MAPConnectionComparatorForMAPGraph t_oConnComp = new MAPConnectionComparatorForMAPGraph(a_oGraph);
        LinkedList<MAPConnection> t_aSelectedConnections = new LinkedList<MAPConnection>();
        while (true) {
            MAPConnection t_oTailConn = (MAPConnection)t_aTraversedConnections.getLast();
            for (MAPConnection t_oConn : t_oTailConn.getAtom().getConnections()) {
                if (t_aTraversedConnections.contains(t_oConn) || t_aTraversedConnections.contains(t_oConn.getReverse()) || t_aSelectedConnections.contains(t_oConn) || t_aSelectedConnections.contains(t_oConn.getReverse())) continue;
                t_aSelectedConnections.add(t_oConn);
            }
            if (t_aSelectedConnections.size() == 0) break;
            for (MAPConnection t_oConn : t_aSelectedConnections) {
                int t_iStartAtomNum = t_aTraversedAtoms.indexOf(t_oConn.getReverse().getAtom());
                int t_iEndAtomNum = t_aTraversedAtoms.indexOf(t_oConn.getAtom());
                if (t_iStartAtomNum == -1 || t_iEndAtomNum == -1 || t_iStartAtomNum >= t_iEndAtomNum) continue;
                int t_iRevNum = t_aSelectedConnections.indexOf(t_oConn);
                t_aSelectedConnections.set(t_iRevNum, t_oConn.getReverse());
            }
            t_oConnComp.addTailConnection(t_oTailConn);
            Collections.sort(t_aSelectedConnections, t_oConnComp);
            MAPConnection t_oSelectedConn = (MAPConnection)t_aSelectedConnections.removeFirst();
            t_aTraversedConnections.addLast(t_oSelectedConn);
            t_aTraversedAtoms.addLast(t_oSelectedConn.getAtom());
        }
        return t_aTraversedConnections;
    }
}

