/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.map;

import java.util.HashMap;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtom;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomAbstract;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomCyclic;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPAtomGroup;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPBondType;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPConnection;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPGraph;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStar;
import org.glycoinfo.WURCSFramework.wurcs.map.MAPStereo;

public class MAPGraphImporter {
    public MAPGraph parseMAP(String a_strMAPCode) throws WURCSFormatException {
        MAPGraph t_oGraph = new MAPGraph();
        HashMap<Integer, MAPAtomAbstract> t_mapIDToAtom = new HashMap<Integer, MAPAtomAbstract>();
        boolean t_bInAromatic = false;
        MAPBondType t_enumBondType = null;
        MAPStereo t_enumBondStereo = null;
        MAPAtomAbstract t_oPrevAtom = null;
        int t_nAtom = 0;
        for (int i = 0; i < a_strMAPCode.length(); ++i) {
            int t_iIndexNum;
            char t_cNext;
            char t_cNext2;
            char t_cX = a_strMAPCode.charAt(i);
            if (t_cX == '(') {
                t_bInAromatic = true;
                continue;
            }
            if (t_cX == ')') {
                t_bInAromatic = false;
                continue;
            }
            if (MAPBondType.forSymbol(t_cX) != null) {
                t_enumBondType = MAPBondType.forSymbol(t_cX);
                continue;
            }
            if (t_cX == '^') {
                char t_cNext3 = a_strMAPCode.charAt(++i);
                MAPStereo t_enumStereo = MAPStereo.forSymbol(t_cNext3);
                if (t_bInAromatic) {
                    t_enumBondType = MAPBondType.AROMATIC;
                }
                if (t_enumBondType == MAPBondType.DOUBLE || t_enumBondType == MAPBondType.AROMATIC) {
                    t_enumBondStereo = t_enumStereo;
                    continue;
                }
                ((MAPAtom)t_oPrevAtom).setStereo(t_enumStereo);
                continue;
            }
            String t_strAtom = "" + t_cX;
            if (i + 1 < a_strMAPCode.length() && Character.isLowerCase(t_cNext2 = a_strMAPCode.charAt(i + 1))) {
                t_strAtom = t_strAtom + t_cNext2;
                ++i;
            }
            String t_strPos = "";
            while (i + 1 < a_strMAPCode.length() && Character.isDigit(t_cNext = a_strMAPCode.charAt(i + 1))) {
                t_strPos = t_strPos + t_cNext;
                ++i;
            }
            int n = t_iIndexNum = t_strPos.equals("") ? 0 : Integer.valueOf(t_strPos);
            if (t_cX == '/') {
                t_oPrevAtom = (MAPAtomAbstract)t_mapIDToAtom.get(t_iIndexNum);
                continue;
            }
            MAPAtomAbstract t_oAtom = null;
            ++t_nAtom;
            if (t_cX == '*') {
                MAPStar t_oCarbon = new MAPStar();
                t_oCarbon.setStarIndex(t_iIndexNum);
                t_oAtom = t_oCarbon;
            } else if (t_cX == '$') {
                t_oAtom = new MAPAtomCyclic((MAPAtomAbstract)t_mapIDToAtom.get(t_iIndexNum));
                --t_nAtom;
            } else {
                t_oAtom = t_strAtom.equals("R") ? new MAPAtomGroup(t_iIndexNum) : new MAPAtom(t_strAtom);
            }
            if (t_bInAromatic) {
                t_oAtom.setAromatic();
            }
            if (t_oPrevAtom != null && t_oPrevAtom.isAromatic() && t_oAtom.isAromatic() && t_enumBondStereo == null) {
                t_enumBondStereo = MAPStereo.UNKNOWN;
            }
            if (t_oPrevAtom != null) {
                MAPConnection t_oChildConn = new MAPConnection(t_oAtom);
                MAPConnection t_oParentConn = new MAPConnection(t_oPrevAtom);
                if (t_enumBondType != null) {
                    t_oChildConn.setBondType(t_enumBondType);
                    t_oParentConn.setBondType(t_enumBondType);
                }
                if (t_enumBondStereo != null) {
                    t_oChildConn.setStereo(t_enumBondStereo);
                    t_oParentConn.setStereo(t_enumBondStereo);
                }
                t_oPrevAtom.addChildConnection(t_oChildConn);
                t_oAtom.setParentConnection(t_oParentConn);
                t_oChildConn.setReverse(t_oParentConn);
                t_oParentConn.setReverse(t_oChildConn);
                if (t_oAtom instanceof MAPStar) {
                    ((MAPStar)t_oAtom).setConnection(t_oParentConn);
                }
                if (t_oPrevAtom instanceof MAPStar) {
                    ((MAPStar)t_oPrevAtom).setConnection(t_oChildConn);
                }
            }
            t_oGraph.addAtom(t_oAtom);
            t_oPrevAtom = t_oAtom;
            t_enumBondType = null;
            t_enumBondStereo = null;
            if (t_oAtom instanceof MAPAtomCyclic) continue;
            t_mapIDToAtom.put(t_nAtom, t_oAtom);
        }
        return t_oGraph;
    }
}

