/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.array;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.comparator.GLIPComparator;
import org.glycoinfo.WURCSFramework.util.array.comparator.GLIPsComparator;
import org.glycoinfo.WURCSFramework.util.array.comparator.LINComparator;
import org.glycoinfo.WURCSFramework.util.array.comparator.LIPComparator;
import org.glycoinfo.WURCSFramework.util.array.comparator.LIPsComparator;
import org.glycoinfo.WURCSFramework.util.array.comparator.MODComparator;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.LIP;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;

public class WURCSExporter {
    private LINComparator m_oLINComp = new LINComparator();
    private GLIPComparator m_oGLIPComp = new GLIPComparator();
    private GLIPsComparator m_oGLIPsComp = new GLIPsComparator();
    private MODComparator m_oMODComp = new MODComparator();
    private LIPComparator m_oLIPComp = new LIPComparator();
    private LIPsComparator m_oLIPsComp = new LIPsComparator();

    public String getWURCSString(WURCSArray a_objWURCS) {
        String t_strWURCS = "WURCS=";
        t_strWURCS = t_strWURCS + a_objWURCS.getVersion();
        t_strWURCS = t_strWURCS + "/";
        t_strWURCS = t_strWURCS + a_objWURCS.getUniqueRESCount() + "," + a_objWURCS.getRESCount() + "," + a_objWURCS.getLINCount();
        if (a_objWURCS.isComposition()) {
            t_strWURCS = t_strWURCS + "+";
        }
        t_strWURCS = t_strWURCS + "/";
        for (UniqueRES t_oURES : a_objWURCS.getUniqueRESs()) {
            t_strWURCS = t_strWURCS + "[" + this.getUniqueRESString(t_oURES) + "]";
        }
        t_strWURCS = t_strWURCS + "/";
        String t_strRESs = "";
        LinkedList<Object> t_aRepIDsOld = new LinkedList();
        for (RES t_oRES : a_objWURCS.getRESs()) {
            int i;
            int t_nRepStart = 0;
            Iterator iterator = t_oRES.getRepeatIDs().iterator();
            while (iterator.hasNext()) {
                int t_iRepID = (Integer)iterator.next();
                if (t_aRepIDsOld.contains(t_iRepID)) continue;
                ++t_nRepStart;
            }
            int t_nRepEnd = 0;
            Iterator t_iRepID = t_aRepIDsOld.iterator();
            while (t_iRepID.hasNext()) {
                int t_iRepID2 = (Integer)t_iRepID.next();
                if (t_oRES.getRepeatIDs().contains(t_iRepID2)) continue;
                ++t_nRepEnd;
            }
            for (i = 0; i < t_nRepEnd; ++i) {
                t_strRESs = t_strRESs + ">";
            }
            if (!t_strRESs.equals("")) {
                t_strRESs = t_strRESs + "-";
            }
            for (i = 0; i < t_nRepStart; ++i) {
                t_strRESs = t_strRESs + "<";
            }
            t_strRESs = t_strRESs + t_oRES.getUniqueRESID();
            t_aRepIDsOld = t_oRES.getRepeatIDs();
        }
        if (!t_aRepIDsOld.isEmpty()) {
            for (int i = 0; i < t_aRepIDsOld.size(); ++i) {
                t_strRESs = t_strRESs + ">";
            }
        }
        t_strWURCS = t_strWURCS + t_strRESs;
        t_strWURCS = t_strWURCS + "/";
        String t_strLINs = "";
        LinkedList<LIN> t_aLINs = a_objWURCS.getLINs();
        Collections.sort(t_aLINs, this.m_oLINComp);
        for (LIN t_oLIN : t_aLINs) {
            if (!t_strLINs.equals("")) {
                t_strLINs = t_strLINs + "_";
            }
            t_strLINs = t_strLINs + this.getLINString(t_oLIN);
        }
        t_strWURCS = t_strWURCS + t_strLINs;
        return t_strWURCS;
    }

    public String getUniqueRESString(UniqueRES a_oURES) {
        return this.getMSString(a_oURES);
    }

    public String getMSString(MS a_oMS) {
        String t_strMS = a_oMS.getSkeletonCode();
        if (a_oMS.getAnomericPosition() != 0) {
            String t_strAnomPos = "" + a_oMS.getAnomericPosition();
            if (t_strAnomPos.equals("-1")) {
                t_strAnomPos = "?";
            }
            t_strMS = t_strMS + "-" + t_strAnomPos + a_oMS.getAnomericSymbol();
        }
        if (a_oMS.getSkeletonCode().equals("<Q>") && a_oMS.getAnomericPosition() == 0 && a_oMS.getAnomericSymbol() == 'o') {
            t_strMS = t_strMS + "-0o";
        }
        LinkedList<MOD> t_aMODs = a_oMS.getMODs();
        Collections.sort(t_aMODs, this.m_oMODComp);
        for (MOD t_oMOD : t_aMODs) {
            t_strMS = t_strMS + "_" + this.getMODString(t_oMOD);
        }
        return t_strMS;
    }

    public String getMODString(MOD a_oMOD) {
        String t_strMOD = "";
        LinkedList<LIPs> t_aListOfLIPs = a_oMOD.getListOfLIPs();
        Collections.sort(t_aListOfLIPs, this.m_oLIPsComp);
        for (LIPs t_oLIPs : t_aListOfLIPs) {
            if (!t_strMOD.equals("")) {
                t_strMOD = t_strMOD + "-";
            }
            t_strMOD = t_strMOD + this.getLIPsString(t_oLIPs);
        }
        t_strMOD = t_strMOD + a_oMOD.getMAPCode();
        return t_strMOD;
    }

    public String getLIPsString(LIPs a_oLIPs) {
        String t_strLIPs = "";
        LinkedList<LIP> t_aLIPs = a_oLIPs.getLIPs();
        Collections.sort(t_aLIPs, this.m_oLIPComp);
        for (LIP t_oLIP : t_aLIPs) {
            if (!t_strLIPs.equals("")) {
                t_strLIPs = t_strLIPs + "|";
            }
            t_strLIPs = t_strLIPs + this.getLIPString(t_oLIP);
        }
        return t_strLIPs;
    }

    public String getLINString(LIN a_oLIN) {
        String t_strLIN = "";
        LinkedList<GLIPs> t_aGLIPs = a_oLIN.getListOfGLIPs();
        Collections.sort(t_aGLIPs, this.m_oGLIPsComp);
        for (GLIPs t_oGLIPs : t_aGLIPs) {
            if (!t_strLIN.equals("")) {
                t_strLIN = t_strLIN + "-";
            }
            t_strLIN = t_strLIN + this.getGLIPsString(t_oGLIPs);
        }
        t_strLIN = t_strLIN + a_oLIN.getMAPCode();
        if (a_oLIN.isRepeatingUnit()) {
            t_strLIN = t_strLIN + "~";
            int t_iMinRep = a_oLIN.getMinRepeatCount();
            int t_iMaxRep = a_oLIN.getMaxRepeatCount();
            t_strLIN = t_strLIN + (t_iMinRep == -1 ? "n" : "" + t_iMinRep);
            if (t_iMinRep != t_iMaxRep) {
                t_strLIN = t_strLIN + (t_iMaxRep == -1 ? "-n" : "-" + t_iMaxRep);
            }
        }
        return t_strLIN;
    }

    public String getGLIPsString(GLIPs a_oGLIPs) {
        String t_strGLIPs = "";
        LinkedList<GLIP> t_aGLIPs = a_oGLIPs.getGLIPs();
        Collections.sort(t_aGLIPs, this.m_oGLIPComp);
        for (GLIP t_oGLIP : t_aGLIPs) {
            if (!t_strGLIPs.equals("")) {
                t_strGLIPs = t_strGLIPs + "|";
            }
            t_strGLIPs = t_strGLIPs + this.getGLIPString(t_oGLIP);
        }
        if (a_oGLIPs.getAlternativeType() == null) {
            return t_strGLIPs;
        }
        if (a_oGLIPs.getAlternativeType().equals("{")) {
            t_strGLIPs = "{" + t_strGLIPs;
        }
        if (a_oGLIPs.getAlternativeType().equals("}")) {
            t_strGLIPs = t_strGLIPs + "}";
        }
        return t_strGLIPs;
    }

    public String getGLIPString(GLIP a_oGLIP) {
        String t_strGLIP = a_oGLIP.getRESIndex();
        t_strGLIP = t_strGLIP + this.getLIPString(a_oGLIP.getBackbonePosition(), a_oGLIP.getBackboneDirection(), a_oGLIP.getModificationPosition());
        String t_strBProb = this.getProbabilityString(a_oGLIP.getBackboneProbabilityLower(), a_oGLIP.getBackboneProbabilityUpper());
        String t_strMProb = this.getProbabilityString(a_oGLIP.getModificationProbabilityLower(), a_oGLIP.getModificationProbabilityUpper());
        t_strGLIP = t_strBProb + t_strGLIP + t_strMProb;
        return t_strGLIP;
    }

    public String getLIPString(LIP a_oLIP) {
        String t_strLIP = "";
        t_strLIP = this.getLIPString(a_oLIP.getBackbonePosition(), a_oLIP.getBackboneDirection(), a_oLIP.getModificationPosition());
        String t_strBProb = this.getProbabilityString(a_oLIP.getBackboneProbabilityLower(), a_oLIP.getBackboneProbabilityUpper());
        String t_strMProb = this.getProbabilityString(a_oLIP.getModificationProbabilityLower(), a_oLIP.getModificationProbabilityUpper());
        t_strLIP = t_strBProb + t_strLIP + t_strMProb;
        return t_strLIP;
    }

    private String getLIPString(int a_iSCPos, char a_cDirection, int a_iMAPPos) {
        String t_strLIP = "";
        String t_strSCPos = "" + a_iSCPos;
        if (t_strSCPos.equals("-1")) {
            t_strSCPos = "?";
        }
        t_strLIP = t_strLIP + t_strSCPos;
        if (a_cDirection != ' ') {
            t_strLIP = t_strLIP + a_cDirection;
        }
        if (a_iMAPPos != 0) {
            String t_strMAPPos = "" + a_iMAPPos;
            if (t_strMAPPos.equals("-1")) {
                t_strMAPPos = "?";
            }
            t_strLIP = t_strLIP + t_strMAPPos;
        }
        return t_strLIP;
    }

    private String getProbabilityString(double a_dLower, double a_dUpper) {
        if (a_dLower == 1.0) {
            return "";
        }
        String t_strProb = "";
        String string = t_strProb = a_dLower < 0.0 ? "?" : NumberFormat.getNumberInstance().format(a_dLower).substring(1);
        if (a_dUpper != a_dLower) {
            t_strProb = t_strProb + "-";
            t_strProb = t_strProb + (a_dUpper < 0.0 ? "?" : NumberFormat.getNumberInstance().format(a_dUpper).substring(1));
        }
        return "%" + t_strProb + "%";
    }
}

