/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor.AddNamespaceToDescriptorAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor.AddUnitToDescriptorAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor.DeleteNamespaceFromDescriptorAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor.DeleteUnitFromDescriptorAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor.SetDefaultUnitForDescriptorAction;
import org.grits.toolbox.editor.samplemanager.input.DescriptorWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.general.GeneralizedTablesWithActions;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.RightSideDescriptorTypeSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.DescriptorUnitContentProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.NamespaceContentProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.NamespaceTableLabelProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.UnitListLabelProvider;

public class RightSideDescriptorSection
extends RightSideDescriptorTypeSection {
    private Logger logger = Logger.getLogger(RightSideDescriptorSection.class);
    private Section namespaceListSection = null;
    private TableViewer namespaceTableViewer = null;
    private TableViewer unitTableViewer = null;
    private Section unitListSection = null;
    private AddUnitToDescriptorAction unitTableAddAction = null;
    private SetDefaultUnitForDescriptorAction unitTableSetDefaultAction = null;
    private DeleteUnitFromDescriptorAction unitTableDeleteAction = null;
    private AddNamespaceToDescriptorAction namespaceTableAddAction = null;
    private DeleteNamespaceFromDescriptorAction namespaceTableDeleteAction = null;
    private UnitListLabelProvider unitListLabelProvider = null;

    public RightSideDescriptorSection(AbstractManagementPage page) {
        super(page);
    }

    @Override
    protected void createMoreSpecificPart() {
        this.logger.debug((Object)"- START : Creating remaining part in Descriptor section.");
        try {
            List<String> existingLabels = ((ManagementEditor)this.page.getEditor()).getAllIndividualLabels("http://www.grits-toolbox.org/ontology/sample#descriptor");
            this.labelModifyListener.setExistingLabels(existingLabels);
            Composite namespaceListComposite = this.toolkit.createComposite(this.page.getRightComposite(), 131072);
            TableWrapLayout namespaceCompositeLayout = new TableWrapLayout();
            namespaceCompositeLayout.numColumns = 1;
            namespaceCompositeLayout.makeColumnsEqualWidth = true;
            namespaceListComposite.setLayout((Layout)namespaceCompositeLayout);
            this.createTableForNamespaces(namespaceListComposite);
            GridData compositeLayoutData = new GridData();
            compositeLayoutData.horizontalSpan = 4;
            namespaceListComposite.setLayoutData((Object)compositeLayoutData);
            Composite unitListComposite = this.toolkit.createComposite(this.page.getRightComposite(), 131072);
            TableWrapLayout unitCompositeLayout = new TableWrapLayout();
            unitCompositeLayout.numColumns = 1;
            unitCompositeLayout.makeColumnsEqualWidth = true;
            unitListComposite.setLayout((Layout)unitCompositeLayout);
            this.createTableForUnits(unitListComposite);
            GridData unitCompositeLayoutData = new GridData();
            unitCompositeLayoutData.horizontalSpan = 4;
            unitListComposite.setLayoutData((Object)unitCompositeLayoutData);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating remaining part in Descriptor section.");
    }

    private void createTableForUnits(Composite unitListComposite) {
        this.unitListSection = this.toolkit.createSection(unitListComposite, 256);
        this.unitListSection.setText("Measurement Units");
        this.unitListSection.setLayout((Layout)new TableWrapLayout());
        TableWrapData section1LayoutData = new TableWrapData();
        section1LayoutData.colspan = 1;
        section1LayoutData.grabVertical = true;
        TableWrapData sectionData = new TableWrapData();
        sectionData.colspan = 1;
        this.unitListSection.setLayoutData((Object)sectionData);
        GeneralizedTablesWithActions unitTableWithActions = new GeneralizedTablesWithActions(this.page, this.unitListSection);
        this.unitTableViewer = unitTableWithActions.createTableViewer(721, 120);
        this.unitTableViewer.setContentProvider((IContentProvider)new DescriptorUnitContentProvider());
        this.unitListLabelProvider = new UnitListLabelProvider();
        this.unitTableViewer.setLabelProvider((IBaseLabelProvider)this.unitListLabelProvider);
        TableColumn nameColumn = new TableColumn(this.unitTableViewer.getTable(), 16384);
        TableColumn uriColumn = new TableColumn(this.unitTableViewer.getTable(), 16384);
        nameColumn.setText("Name");
        int nameColumnWidth = 220;
        nameColumn.setWidth(nameColumnWidth);
        uriColumn.setText("URI");
        uriColumn.setWidth(721 - nameColumnWidth);
        this.unitTableViewer.getTable().setHeaderVisible(true);
        this.unitTableAddAction = new AddUnitToDescriptorAction(this.page, this.unitTableViewer);
        this.unitTableDeleteAction = new DeleteUnitFromDescriptorAction(this.page, this.unitTableViewer);
        this.unitTableSetDefaultAction = new SetDefaultUnitForDescriptorAction(this.page, this.unitTableViewer);
        ToolBarManager toolBarManager = unitTableWithActions.getToolBarManager();
        toolBarManager.add((IAction)this.unitTableAddAction);
        toolBarManager.add((IAction)this.unitTableSetDefaultAction);
        toolBarManager.add((IAction)this.unitTableDeleteAction);
        toolBarManager.update(true);
    }

    private void createTableForNamespaces(Composite namespaceListComposite) {
        this.namespaceListSection = this.toolkit.createSection(namespaceListComposite, 256);
        this.namespaceListSection.setText("Namespaces");
        this.namespaceListSection.setLayout((Layout)new TableWrapLayout());
        TableWrapData section1LayoutData = new TableWrapData();
        section1LayoutData.colspan = 1;
        section1LayoutData.grabVertical = true;
        TableWrapData sectionData = new TableWrapData();
        sectionData.colspan = 1;
        this.namespaceListSection.setLayoutData((Object)sectionData);
        GeneralizedTablesWithActions namespaceTableWithActions = new GeneralizedTablesWithActions(this.page, this.namespaceListSection);
        this.namespaceTableViewer = namespaceTableWithActions.createTableViewer(721, 80);
        this.namespaceTableViewer.setContentProvider((IContentProvider)new NamespaceContentProvider());
        this.namespaceTableViewer.setLabelProvider((IBaseLabelProvider)new NamespaceTableLabelProvider());
        TableColumn nameColumn = new TableColumn(this.namespaceTableViewer.getTable(), 16384);
        TableColumn uriColumn = new TableColumn(this.namespaceTableViewer.getTable(), 16384);
        nameColumn.setText("Name");
        int nameColumnWidth = 180;
        nameColumn.setWidth(nameColumnWidth);
        uriColumn.setText("URI");
        uriColumn.setWidth(721 - nameColumnWidth);
        this.namespaceTableViewer.getTable().setHeaderVisible(true);
        this.namespaceTableAddAction = new AddNamespaceToDescriptorAction(this.page, this.namespaceTableViewer);
        this.namespaceTableDeleteAction = new DeleteNamespaceFromDescriptorAction(this.page, this.namespaceTableViewer);
        ToolBarManager toolBarManager = namespaceTableWithActions.getToolBarManager();
        toolBarManager.add((IAction)this.namespaceTableAddAction);
        toolBarManager.add((IAction)this.namespaceTableDeleteAction);
        toolBarManager.update(true);
    }

    @Override
    protected void resetMoreSpecificPart() {
        this.logger.debug((Object)"- START : Resetting remaining part in Descriptor section for the selection.");
        try {
            DescriptorWithFeatures descriptorWithFeatures = (DescriptorWithFeatures)this.selectedObject;
            List<String> existingLabels = ((ManagementEditor)this.page.getEditor()).getAllIndividualLabels("http://www.grits-toolbox.org/ontology/sample#descriptor");
            this.labelModifyListener.setExistingLabels(existingLabels);
            this.namespaceTableViewer.setInput((Object)descriptorWithFeatures.getDescriptor());
            this.namespaceTableAddAction.setEnabled(this.editable);
            this.namespaceTableDeleteAction.setEnabled(this.editable);
            if (descriptorWithFeatures.getDescriptor().getDefaultMeasurementUnit() != null) {
                this.unitListLabelProvider.setDefaultUnitURI(descriptorWithFeatures.getDescriptor().getDefaultMeasurementUnit());
            }
            this.unitTableViewer.setInput((Object)descriptorWithFeatures.getDescriptor());
            this.unitTableAddAction.setEnabled(this.editable);
            this.unitTableSetDefaultAction.setEnabled(this.editable);
            this.unitTableDeleteAction.setEnabled(this.editable);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resetting remaining part in Descriptor section for the selection.");
    }
}

