/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.util.StringUtils;

public class NameParsingException
extends ResourcesDbException {
    private String nameStr;
    private int position = -1;
    private static final long serialVersionUID = 1L;

    public NameParsingException(String message) {
        super(message);
    }

    public NameParsingException(String message, String name, int pos) {
        super(message);
        this.setNameStr(name);
        this.setPosition(pos);
    }

    public NameParsingException(String message, Throwable cause) {
        super(message, cause);
    }

    public NameParsingException(String message, String name, int pos, Throwable cause) {
        super(message, cause);
        this.setNameStr(name);
        this.setPosition(pos);
    }

    public String getNameStr() {
        return this.nameStr;
    }

    public void setNameStr(String name) {
        this.nameStr = name;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public String buildExplanationString() {
        String outStr = "";
        if (this.getPosition() >= 0 && this.getNameStr() != null) {
            outStr = outStr + this.getNameStr() + "\n";
            outStr = outStr + StringUtils.makeBlanks(this.getPosition());
            outStr = outStr + "^";
        }
        return outStr;
    }
}

