/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.canvas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueHistory;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.ResidueDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.utils.ResidueOperationUtils;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.dialog.RepititionPropertyDialog;
import org.grits.toolbox.tools.glycanbuilder.widgets.dialog.ResiduePropertyDialog;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GeneralIconProvider;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GlycanIconProvider;

public class ShortcutToolBar
implements ResidueHistory.Listener,
GlycanIconProvider.IconUpdateListener {
    private GlycanCanvasComposite m_canvas;
    private ResidueHistory m_resHistory;
    private ToolBar m_bar;
    private Map<ResidueType, ToolItem> m_mapResTypeToItem;
    private ToolItem m_itemSeparator1;
    private List<ToolItem> m_lRecentResItems;
    private Map<ResidueType, ToolItem> m_mapRecentResTypeToItem;
    private ToolItem m_itemBracket;
    private ToolItem m_itemRepeat;
    private ToolItem m_itemProperties;
    private ToolItem m_itemOrientation;

    public ShortcutToolBar(Composite parent, GlycanCanvasComposite canvas) {
        this.m_bar = new ToolBar(parent, 8519744);
        this.m_canvas = canvas;
        this.m_resHistory = canvas.getBuilderWorkspace().getResidueHistory();
        this.m_mapResTypeToItem = new HashMap<ResidueType, ToolItem>();
        this.m_lRecentResItems = new ArrayList<ToolItem>();
        this.m_mapRecentResTypeToItem = new HashMap<ResidueType, ToolItem>();
        this.createItems();
        this.addMouseListnerToCanvas();
        canvas.getBuilderWorkspace().getResidueHistory().addHistoryChangedListener((ResidueHistory.Listener)this);
        GlycanIconProvider.addIconUpdateListener(this);
        final ShortcutToolBar toRemove = this;
        this.m_bar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GlycanIconProvider.removeIconUpdateListener(toRemove);
            }
        });
    }

    public ToolItem getChangeOrientationItem() {
        return this.m_itemOrientation;
    }

    private void createItems() {
        ToolItem item;
        for (final ResidueType resType : ResidueDictionary.directResidues()) {
            item = new ToolItem(this.m_bar, 8);
            this.m_mapResTypeToItem.put(resType, item);
            item.setToolTipText(resType.getDescription());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!ResidueOperationUtils.canAddResidueToCanvas(ShortcutToolBar.this.m_canvas, new Residue(resType))) {
                        return;
                    }
                    ShortcutToolBar.this.m_canvas.addResidue(new Residue(resType));
                    ShortcutToolBar.this.m_canvas.updateView();
                }
            });
        }
        this.updateIconImages();
        new ToolItem(this.m_bar, 2);
        item = new ToolItem(this.m_bar, 8);
        item.setImage(GeneralIconProvider.getBracketIcon());
        item.setToolTipText("Add bracket");
        item.setEnabled(false);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel() == null) {
                    return;
                }
                ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel().addBracket();
                ((ToolItem)e.getSource()).setEnabled(false);
                ShortcutToolBar.this.m_canvas.updateView();
            }
        });
        this.m_itemBracket = item;
        item = new ToolItem(this.m_bar, 8);
        item.setImage(GeneralIconProvider.getRepeatIcon());
        item.setToolTipText("Add repeating unit");
        item.setEnabled(false);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel() == null) {
                    return;
                }
                ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel().createRepitition();
                ShortcutToolBar.this.m_canvas.updateView();
            }
        });
        this.m_itemRepeat = item;
        item = new ToolItem(this.m_bar, 8);
        item.setImage(GeneralIconProvider.getResiduePropertiesIcon());
        item.setToolTipText("Residue properties");
        item.setEnabled(false);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel() == null || ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel().getCurrentResidue() == null) {
                    return;
                }
                Residue resCurrent = ShortcutToolBar.this.m_canvas.getCurrentGlycanLabel().getCurrentResidue();
                TitleAreaDialog dlg = resCurrent.isEndRepetition() ? new RepititionPropertyDialog(ShortcutToolBar.this.m_bar.getShell(), resCurrent) : new ResiduePropertyDialog(ShortcutToolBar.this.m_bar.getShell(), resCurrent);
                dlg.open();
                ShortcutToolBar.this.m_canvas.updateView();
            }
        });
        this.m_itemProperties = item;
        item = new ToolItem(this.m_bar, 8);
        item.setImage(GeneralIconProvider.getOrientationIcon(this.m_canvas.getBuilderWorkspace().getGraphicOptions().ORIENTATION));
        item.setToolTipText("Change orientation");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int orien = ((ShortcutToolBar)ShortcutToolBar.this).m_canvas.getBuilderWorkspace().getGraphicOptions().ORIENTATION;
                if (orien == 0) {
                    orien = 1;
                } else if (orien == 1) {
                    orien = 2;
                } else if (orien == 2) {
                    orien = 3;
                } else if (orien == 3) {
                    orien = 0;
                }
                ((ShortcutToolBar)ShortcutToolBar.this).m_canvas.getBuilderWorkspace().getGraphicOptions().ORIENTATION = orien;
                ShortcutToolBar.this.updateOrientationIcon();
                ShortcutToolBar.this.m_canvas.updateView();
            }
        });
        this.m_itemOrientation = item;
    }

    private void addMouseListnerToCanvas() {
        this.m_canvas.addCanvasMouseListner((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ShortcutToolBar.this.updateButtonState();
            }
        });
    }

    public void updateResentResidues() {
        for (ToolItem item : this.m_lRecentResItems) {
            item.dispose();
        }
        this.m_lRecentResItems.clear();
        if (this.m_resHistory.size() == 0) {
            if (this.m_itemSeparator1 != null) {
                this.m_itemSeparator1.dispose();
            }
            this.m_bar.layout();
            return;
        }
        int index = ResidueDictionary.directResidues().size();
        if (this.m_itemSeparator1 == null) {
            this.m_itemSeparator1 = new ToolItem(this.m_bar, 2, index);
        }
        ++index;
        for (String strRes : this.m_resHistory.getRecentResidues()) {
            final ResidueType resType = ResidueDictionary.findResidueType(strRes);
            ToolItem item = new ToolItem(this.m_bar, 8, index++);
            item.setToolTipText(resType.getDescription());
            item.setImage(GlycanIconProvider.getResidueIcon(resType));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!ResidueOperationUtils.canAddResidueToCanvas(ShortcutToolBar.this.m_canvas, new Residue(resType))) {
                        return;
                    }
                    ShortcutToolBar.this.m_canvas.addResidue(new Residue(resType));
                    ShortcutToolBar.this.m_canvas.updateView();
                }
            });
            this.m_lRecentResItems.add(item);
            this.m_mapRecentResTypeToItem.put(resType, item);
        }
        this.m_bar.layout();
    }

    public void updateButtonState() {
        this.m_itemBracket.setEnabled(false);
        this.m_itemProperties.setEnabled(false);
        this.m_itemRepeat.setEnabled(false);
        if (this.m_canvas.getCurrentGlycanLabel() == null) {
            return;
        }
        if (this.m_canvas.getCurrentGlycanLabel().hasSelectedResidues()) {
            this.m_itemRepeat.setEnabled(true);
        }
        if (this.m_canvas.getCurrentGlycanLabel().canAddBracket()) {
            this.m_itemBracket.setEnabled(true);
        }
        if (this.m_canvas.getCurrentGlycanLabel().getCurrentResidue() == null) {
            return;
        }
        this.m_itemProperties.setEnabled(true);
    }

    public void updateOrientationIcon() {
        this.m_itemOrientation.setImage(GeneralIconProvider.getOrientationIcon(this.m_canvas.getBuilderWorkspace().getGraphicOptions().ORIENTATION));
    }

    public void updateIconImages() {
        for (ResidueType resType : ResidueDictionary.directResidues()) {
            ToolItem item = this.m_mapResTypeToItem.get(resType);
            item.setImage(GlycanIconProvider.getResidueIcon(resType));
        }
        if (!this.m_lRecentResItems.isEmpty()) {
            ArrayList<ResidueType> toRemove = new ArrayList<ResidueType>();
            for (ResidueType resType : this.m_mapRecentResTypeToItem.keySet()) {
                ToolItem item = this.m_mapRecentResTypeToItem.get(resType);
                if (item.isDisposed()) {
                    toRemove.add(resType);
                    continue;
                }
                item.setImage(GlycanIconProvider.getResidueIcon(resType));
            }
            for (ResidueType resType : toRemove) {
                this.m_mapRecentResTypeToItem.remove(resType);
            }
        }
        this.m_bar.layout();
    }

    public ToolBar getToolBar() {
        return this.m_bar;
    }

    public void dispose() {
        this.m_bar.dispose();
    }

    public void residueHistoryChanged() {
        this.updateResentResidues();
    }

    @Override
    public void residueIconUpdated() {
        this.updateIconImages();
    }

    @Override
    public void glycanIconUpdated() {
    }
}

