/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.io;

public enum ImageFormat {
    BMP("bmp", "BMP", "BMP format", 0),
    PNG("png", "PNG", "PNG format", 5),
    JPEG("jpg", "JPEG", "JPEG format", 4),
    SVG("svg", "SVG", "SVG format", -1);

    private String m_strID;
    private String m_strName;
    private String m_strDesc;
    private int m_iImageFormatConstantInSWT;

    private ImageFormat(String strID, String strName, String strDesc, int iSWTImageConstant) {
        this.m_strID = strID;
        this.m_strName = strName;
        this.m_strDesc = strDesc;
        this.m_iImageFormatConstantInSWT = iSWTImageConstant;
    }

    public String getIdentifier() {
        return this.m_strID;
    }

    public String getName() {
        return this.m_strName;
    }

    public String getDescription() {
        return this.m_strDesc;
    }

    public String getFilterExtention() {
        return "*." + this.m_strID;
    }

    public String getFilterName() {
        return String.valueOf(this.m_strDesc) + " (" + this.getFilterExtention() + ")";
    }

    public int getSWTImageConstant() {
        return this.m_iImageFormatConstantInSWT;
    }

    public boolean isAvailableInSWT() {
        return this.m_iImageFormatConstantInSWT > 0;
    }

    public static ImageFormat forID(String strID) {
        ImageFormat[] imageFormatArray = ImageFormat.values();
        int n = imageFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            if (format.m_strID.equals(strID)) {
                return format;
            }
            ++n2;
        }
        return null;
    }

    public static String[] getFilterNames() {
        String[] strFormats = new String[ImageFormat.values().length];
        int i = 0;
        ImageFormat[] imageFormatArray = ImageFormat.values();
        int n = imageFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            strFormats[i] = format.getFilterName();
            ++i;
            ++n2;
        }
        return strFormats;
    }

    public static String[] getFilterExtensions() {
        String[] strFormats = new String[ImageFormat.values().length];
        int i = 0;
        ImageFormat[] imageFormatArray = ImageFormat.values();
        int n = imageFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFormat format = imageFormatArray[n2];
            strFormats[i] = format.getFilterExtention();
            ++i;
            ++n2;
        }
        return strFormats;
    }
}

