/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.snippets;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImageConverterAWT_SWT {
    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public static ImageData createSampleImage(Display display) {
        Image image = new Image((Device)display, 100, 100);
        Rectangle bounds = image.getBounds();
        GC gc = new GC((Drawable)image);
        gc.setBackground(display.getSystemColor(9));
        gc.fillRectangle(bounds);
        gc.setBackground(display.getSystemColor(5));
        gc.fillOval(0, 0, bounds.width, bounds.height);
        gc.setForeground(display.getSystemColor(3));
        gc.drawLine(0, 0, bounds.width, bounds.height);
        gc.drawLine(bounds.width, 0, 0, bounds.height);
        gc.dispose();
        ImageData data = image.getImageData();
        image.dispose();
        return data;
    }

    public static void main(String[] args) {
        ImageData data;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("SWT Image");
        if (args.length > 0) {
            String fileName = args[0];
            data = new ImageData(fileName);
        } else {
            data = ImageConverterAWT_SWT.createSampleImage(display);
        }
        Image swtImage = new Image((Device)display, data);
        final BufferedImage awtImage = ImageConverterAWT_SWT.convertToAWT(data);
        Image swtImage2 = new Image((Device)display, ImageConverterAWT_SWT.convertToSWT(awtImage));
        shell.addListener(9, e -> {
            int y = 10;
            if (swtImage != null) {
                e.gc.drawImage(swtImage, 10, y);
                y += image.getBounds().height + 10;
            }
            if (swtImage2 != null) {
                e.gc.drawImage(swtImage2, 10, y);
            }
        });
        Frame frame = new Frame(){

            @Override
            public void paint(Graphics g) {
                Insets insets = this.getInsets();
                if (awtImage != null) {
                    g.drawImage(awtImage, 10 + insets.left, 10 + insets.top, null);
                }
            }
        };
        frame.setTitle("AWT Image");
        shell.setLocation(50, 50);
        Rectangle bounds = swtImage.getBounds();
        shell.setSize(bounds.width + 50, bounds.height * 2 + 100);
        Point size = shell.getSize();
        Point location = shell.getLocation();
        Insets insets = frame.getInsets();
        frame.setLocation(location.x + size.x + 10, location.y);
        frame.setSize(size.x - (insets.left + insets.right), size.y - (insets.top + insets.bottom));
        frame.setVisible(true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (swtImage != null) {
            swtImage.dispose();
        }
        if (swtImage2 != null) {
            swtImage.dispose();
        }
        frame.dispose();
        display.dispose();
    }
}

