/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;

@XmlRootElement
public class ParameterGroup
implements EntityWithPosition {
    Integer id;
    String label;
    String uri;
    List<Parameter> parameters;
    Boolean required;
    String description;
    Integer position;
    List<String> guidelineURIs;

    public ParameterGroup() {
    }

    public ParameterGroup(ParameterGroup group) {
        this.id = group.id;
        this.label = group.label;
        this.uri = group.uri;
        this.required = group.required;
        this.description = group.description;
        this.position = group.position;
        this.guidelineURIs = group.guidelineURIs;
        List<Parameter> groupParams = group.getParameters();
        this.parameters = new ArrayList<Parameter>();
        for (Parameter parameter : groupParams) {
            this.parameters.add(new Parameter(parameter, group.id));
        }
    }

    @XmlAttribute
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlAttribute
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    @XmlAttribute
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    public List<String> getGuidelineURIs() {
        return this.guidelineURIs;
    }

    public void setGuidelineURIs(List<String> guidelineURIs) {
        this.guidelineURIs = guidelineURIs;
    }

    @XmlElement(name="parameter")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @XmlAttribute
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterGroup) {
            if (this.id != null && ((ParameterGroup)obj).getId() != null) {
                return ((ParameterGroup)obj).getLabel().equals(this.label) && ((ParameterGroup)obj).getId().equals(this.id);
            }
            return ((ParameterGroup)obj).getLabel().equals(this.label);
        }
        return false;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public ParameterGroup getACopy() {
        ParameterGroup parameterGroup = new ParameterGroup();
        parameterGroup.setUri(this.uri);
        parameterGroup.setLabel(this.label);
        parameterGroup.setDescription(this.description);
        parameterGroup.setId(this.id);
        parameterGroup.setPosition(this.position);
        parameterGroup.setGuidelineURIs(this.guidelineURIs);
        if (this.parameters != null) {
            ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
            for (Parameter parameter : this.parameters) {
                parameterList.add(parameter.getACopy());
            }
            parameterGroup.setParameters(parameterList);
        }
        parameterGroup.setRequired(this.required);
        return parameterGroup;
    }
}

