/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.editor.experimentdesigner.io.TemplateExistsException;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentTemplateEntry;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ExperimentTemplateFileHandler {
    public static SimpleDateFormat DATEFORMATER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static Integer identifier = 0;
    private static final Logger logger = Logger.getLogger(ExperimentTemplateFileHandler.class);

    public static void createTemplateIndexFile(String folder) throws IOException {
        identifier = 0;
        Element template = new Element("experimentTemplates");
        Document doc = new Document(template);
        doc.setRootElement(template);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(folder) + File.separator + "template.xml");
            xmlOutput.output(doc, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot create the index file for experiment templates.", (Throwable)e);
            throw e;
        }
    }

    public static void addTemplate(ExperimentTemplateEntry template, String folder) throws IOException, TemplateExistsException, DataConversionException {
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(String.valueOf(folder) + File.separator + "template.xml");
        if (xmlFile.exists()) {
            Document doc;
            try {
                doc = builder.build(xmlFile);
            }
            catch (JDOMException e) {
                logger.error((Object)("org.grits.toolbox.editor.experimentdesignerTemplate xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]"), (Throwable)e);
                throw new IOException("Template xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]: " + e.getMessage());
            }
            Element root = doc.getRootElement();
            List children = root.getChildren();
            if (children != null) {
                for (Element child : children) {
                    Attribute nameAttr;
                    Attribute idAttr = child.getAttribute("id");
                    if (idAttr != null) {
                        identifier = Math.max(identifier, idAttr.getIntValue());
                    }
                    if ((nameAttr = child.getAttribute("name")) == null || !nameAttr.getValue().trim().equalsIgnoreCase(template.getName())) continue;
                    logger.info((Object)"org.grits.toolbox.editor.experimentdesigner Cannot save the template since there is one with the same name");
                    throw new TemplateExistsException("Template with given name " + template.getName() + " already exists!");
                }
            }
            identifier = identifier + 1;
            Element t_currentElement = new Element("template");
            t_currentElement.setAttribute("id", identifier.toString());
            t_currentElement.setAttribute("name", template.getName());
            t_currentElement.setAttribute("creationTime", ProjectFileHandler.DATEFORMATER.format(template.getDateCreated()));
            t_currentElement.setAttribute("filename", template.getFilename());
            if (template.getCreator() != null) {
                t_currentElement.setAttribute("creator", template.getCreator());
            }
            root.addContent((Content)t_currentElement);
            if (template.getDescription() != null) {
                Element description = new Element("description");
                description.setText(template.getDescription());
                t_currentElement.addContent((Content)description);
            }
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getPrettyFormat());
            try {
                FileWriter fileWriter = new FileWriter(String.valueOf(folder) + File.separator + "template.xml");
                xmlOutput.output(doc, (Writer)fileWriter);
                fileWriter.close();
            }
            catch (IOException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot update the index file for experiment templates.", (Throwable)e);
                throw e;
            }
        }
        throw new IOException("Template index file does not exists!");
    }

    public static List<ExperimentTemplateEntry> getAllTemplates(String folder) throws IOException {
        File file = new File(folder);
        return ExperimentTemplateFileHandler.getAllTemplates(file, false);
    }

    public static List<ExperimentTemplateEntry> getAllTemplates(File folder, boolean fromJar) throws IOException {
        ArrayList<ExperimentTemplateEntry> entries = new ArrayList<ExperimentTemplateEntry>();
        if (folder == null) {
            return entries;
        }
        File xmlFile = new File(String.valueOf(folder.getAbsolutePath()) + File.separator + "template.xml");
        if (xmlFile.exists()) {
            Document doc;
            SAXBuilder builder = new SAXBuilder();
            try {
                doc = builder.build(xmlFile);
            }
            catch (JDOMException e) {
                logger.error((Object)("org.grits.toolbox.editor.experimentdesignerTemplate xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]"), (Throwable)e);
                throw new IOException("Template xml is not a valid xml file[" + xmlFile.getAbsolutePath() + "]: " + e.getMessage());
            }
            Element root = doc.getRootElement();
            List children = root.getChildren();
            if (children != null) {
                for (Element child : children) {
                    String dateAttr;
                    ExperimentTemplateEntry entry = new ExperimentTemplateEntry();
                    Attribute nameAttr = child.getAttribute("name");
                    entry.setName(nameAttr.getValue());
                    Attribute creatorAttr = child.getAttribute("creator");
                    if (creatorAttr != null) {
                        entry.setCreator(creatorAttr.getValue());
                    }
                    if ((dateAttr = child.getAttributeValue("creationTime")) == null) {
                        entry.setDateCreated(new Date());
                    } else {
                        try {
                            Date t_date = ProjectFileHandler.DATEFORMATER.parse(dateAttr);
                            entry.setDateCreated(t_date);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unable to parse creation date for entry (id=" + child.getAttributeValue("name") + "): " + dateAttr), (Throwable)e);
                            entry.setDateCreated(new Date());
                        }
                    }
                    entry.setFilename(child.getAttributeValue("filename"));
                    entry.setFromJar(fromJar);
                    Element descElement = child.getChild("description");
                    if (descElement != null) {
                        entry.setDescription(descElement.getText());
                    }
                    entries.add(entry);
                }
            }
        }
        return entries;
    }
}

