/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.experimentdesigner.config.ExperimentConfig;
import org.grits.toolbox.editor.experimentdesigner.config.ImageRegistry;
import org.grits.toolbox.editor.experimentdesigner.dialog.SelectExperimentDialog;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.handler.NewExperimentHandler;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentTemplateEntry;
import org.grits.toolbox.editor.experimentdesigner.property.ExperimentProperty;

public class InsertExperimentDesignAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final Logger logger = Logger.getLogger(InsertExperimentDesignAction.class);
    ExperimentGraph experimentDesign;
    GraphEditor editor;

    public InsertExperimentDesignAction(GraphEditor editor) {
        this.editor = editor;
        this.experimentDesign = editor.getModel();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.EXPERIMENTDESIGNICON);
    }

    public String getId() {
        return "InsertDesign";
    }

    public void dispose() {
    }

    public void run() {
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner BEGIN InsertExperimentDesignAction...Inserting an experiment graph into another");
        Shell shell = Display.getCurrent().getActiveShell();
        SelectExperimentDialog dialog = new SelectExperimentDialog(PropertyHandler.getModalDialog((Shell)shell));
        dialog.setBlockOnOpen(true);
        int status = dialog.open();
        File originalFile = null;
        if (status == 0) {
            Entry experimentEntry = dialog.getExperimentSelected();
            ExperimentTemplateEntry templateFile = dialog.getTemplateFile();
            if (experimentEntry != null) {
                File originalExperimentFolder = NewExperimentHandler.getExperimentDirectory(experimentEntry.getParent());
                originalFile = new File(String.valueOf(originalExperimentFolder.getAbsolutePath()) + File.separator + ((ExperimentProperty)experimentEntry.getProperty()).getExperimentFile().getName());
            } else if (templateFile != null) {
                if (templateFile.isFromJar()) {
                    URL url = ExperimentConfig.EXPERIMET_TEMPLATE_RESOURCE_URL;
                    if (url == null) {
                        logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template! no template directory found in jar");
                        ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template. Reason: No Template directory found in jar");
                    }
                    try {
                        URL resourceFileUrl = FileLocator.toFileURL((URL)url);
                        originalFile = new File(String.valueOf(resourceFileUrl.toURI().getRawPath()) + File.separator + templateFile.getFilename());
                    }
                    catch (IOException | URISyntaxException e) {
                        logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template!", (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template", (Exception)e);
                    }
                } else {
                    originalFile = new File(String.valueOf(ExperimentDesignOntologyAPI.getTemplateFolderLocation()) + File.separator + templateFile.getFilename());
                }
            }
        }
        if (originalFile != null) {
            try {
                FileInputStream inputStream = new FileInputStream(originalFile);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                ExperimentGraph graph = (ExperimentGraph)unmarshaller.unmarshal((Reader)reader);
                graph.setConnectionsToNodes();
                this.copyFromGraph(graph);
                this.editor.setGraphModelChanged(true);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design! Design not found", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design. Reason: design not found");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot read existing experiment design!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot read existing experiment design");
            }
            catch (JAXBException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot read existing experiment design!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot read existing experiment design");
            }
        }
        logger.debug((Object)"org.grits.toolbox.editor.experimentdesigner END InsertExperimentDesignAction.");
    }

    private void copyFromGraph(ExperimentGraph graph) {
        if (this.experimentDesign == null || graph == null) {
            return;
        }
        int offset = 0;
        List<GraphNode> existingNodes = this.experimentDesign.getNodes();
        for (GraphNode graphNode : existingNodes) {
            offset = Math.max(graphNode.getLocation().x + graphNode.getSize().width, offset);
        }
        this.removeInputOutputNodes(graph);
        List<GraphNode> nodes = graph.getNodes();
        for (GraphNode graphNode : nodes) {
            graphNode.setLocation(graphNode.getLocation().translate(offset, 0));
            this.experimentDesign.addChild(graphNode);
        }
    }

    private void removeInputOutputNodes(ExperimentGraph graph) {
        ArrayList<GraphNode> nodesToRemove = new ArrayList<GraphNode>();
        for (GraphNode graphNode : graph.getNodes()) {
            if (!(graphNode instanceof InputNode) && !(graphNode instanceof OutputNode)) continue;
            nodesToRemove.add(graphNode);
        }
        for (GraphNode node : nodesToRemove) {
            List<Connection> connections = null;
            if (node instanceof InputNode) {
                connections = node.getSourceConnections();
            } else if (node instanceof OutputNode) {
                connections = node.getTargetConnections();
            }
            boolean wasRemoved = graph.removeChild(node);
            if (!wasRemoved || connections == null) continue;
            for (Connection conn : connections) {
                conn.disconnect();
            }
        }
    }
}

