/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.pubmed.DTOPublication;
import org.grits.toolbox.editor.experimentdesigner.pubmed.DTOPublicationAuthor;
import org.grits.toolbox.editor.experimentdesigner.pubmed.PubmedUtil;
import org.grits.toolbox.editor.experimentdesigner.views.PaperView;

public class AddPaperAction {
    private static Logger logger = Logger.getLogger(PaperView.class);
    ControlDecoration dec;
    Text pubmedId;
    Label errorLabel;
    @Inject
    IEventBroker eventBroker;
    GraphEditor editor;

    @Execute
    public void run(@Named(value="activeShell") @Named(value="activeShell") Shell shell, MApplication application, MPart paperView) {
        if (paperView != null && paperView.getObject() != null) {
            Integer pmid;
            ProtocolNode protocol = ((PaperView)paperView.getObject()).getProtocol();
            if (protocol == null) {
                return;
            }
            this.editor = (GraphEditor)((Object)application.getContext().get(GraphEditor.class));
            TableViewer tableViewer = ((PaperView)paperView.getObject()).getTableViewer();
            PubMedFormDialog formDialog = new PubMedFormDialog(shell);
            formDialog.create();
            formDialog.getShell().setSize(315, 210);
            if (formDialog.open() == 0 && (pmid = formDialog.getPmId()) != null) {
                PubmedUtil util = new PubmedUtil();
                try {
                    DTOPublication publication;
                    List<Paper> papers = protocol.getPapers();
                    if (papers == null) {
                        papers = new ArrayList<Paper>();
                        protocol.setPapers(papers);
                    }
                    if ((publication = util.createFromPubmedId(pmid)) == null) {
                        logger.info((Object)("Paper with pubmed id " + pmid + " does not exist."));
                        MessageDialog.openWarning((Shell)shell, (String)"Does not Exist", (String)("Paper with pubmed id " + pmid + " does not exist."));
                        return;
                    }
                    Paper newPaper = new Paper();
                    newPaper.setPubMedId(pmid);
                    newPaper.setTitle(publication.getTitle());
                    newPaper.setFormatedAuthor(publication.getFormattedAuthor());
                    List<DTOPublicationAuthor> authors = publication.getAuthors();
                    for (DTOPublicationAuthor dtoPublicationAuthor : authors) {
                        newPaper.addAuthor(String.valueOf(dtoPublicationAuthor.getLastName()) + ", " + dtoPublicationAuthor.getFirstName());
                    }
                    StringBuffer bibCitation = new StringBuffer();
                    if (publication.getJournal() != null) {
                        bibCitation.append(String.valueOf(publication.getJournal()) + ".");
                    }
                    if (publication.getVolume() != null) {
                        bibCitation.append(" " + publication.getVolume());
                    }
                    if (publication.getNumber() != null) {
                        bibCitation.append("(" + publication.getNumber() + ")");
                    }
                    if (publication.getStartPage() != null) {
                        bibCitation.append(" " + publication.getStartPage());
                    }
                    if (publication.getEndPage() != null) {
                        bibCitation.append("-" + publication.getEndPage());
                    }
                    if (publication.getYear() != null) {
                        bibCitation.append(" (" + publication.getYear() + ").");
                    }
                    newPaper.setBibliographicCitation(bibCitation.toString());
                    newPaper.setYear(publication.getYear());
                    if (!papers.contains(newPaper)) {
                        papers.add(newPaper);
                        tableViewer.getTable().setRedraw(true);
                        tableViewer.getTable().removeAll();
                        tableViewer.setInput((Object)protocol);
                        this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                        if (this.editor == null) {
                            logger.error((Object)"Cannot get the reference to Graph Editor");
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                            return;
                        }
                        this.editor.refreshProtocolNode(protocol);
                    } else {
                        logger.info((Object)" This paper already exists for the protocol. Duplicate! ");
                        MessageDialog.openInformation((Shell)shell, (String)"Duplicate", (String)"Paper with this pubmed id already exists for the protocol. Ignoring!");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)" Error retrieving information from PubMed Server. ", (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error connecting to Pubmed", (String)("Error retrieving paper information from Pubmed Server. Please check your internet connection: " + e.getMessage()));
                }
            }
        }
    }

    class PubMedFormDialog
    extends FormDialog {
        Integer pmId;
        String pmIdText;

        public PubMedFormDialog(Shell shell) {
            super(shell);
        }

        public Integer getPmId() {
            return this.pmId;
        }

        public String getPmIdText() {
            return this.pmIdText;
        }

        public void setPmIdText(String pmIdText) {
            this.pmIdText = pmIdText;
        }

        protected void createFormContent(IManagedForm mform) {
            ScrolledForm scrolledForm = mform.getForm();
            TableWrapLayout tableWrapLayout = new TableWrapLayout();
            tableWrapLayout.numColumns = 2;
            scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
            scrolledForm.setText("Pubmed Search");
            FormToolkit toolkit = mform.getToolkit();
            Label lblName = toolkit.createLabel(scrolledForm.getBody(), "Pubmed Id:");
            lblName.setLayoutData((Object)new TableWrapData(2, 16, 1, 1));
            AddPaperAction.this.pubmedId = toolkit.createText(scrolledForm.getBody(), "", 0);
            AddPaperAction.this.pubmedId.setLayoutData((Object)new TableWrapData(4, 16, 1, 1));
            AddPaperAction.this.dec = new ControlDecoration((Control)AddPaperAction.this.pubmedId, 16512);
            Image image = JFaceResources.getImage((String)"dialog_message_error_image");
            AddPaperAction.this.dec.setImage(image);
            AddPaperAction.this.dec.setDescriptionText("Pubmed Id should be an integer");
            AddPaperAction.this.dec.hide();
            AddPaperAction.this.errorLabel = toolkit.createLabel(scrolledForm.getBody(), "", 0);
            AddPaperAction.this.errorLabel.setLayoutData((Object)new TableWrapData(256, 64, 3, 2));
            toolkit.paintBordersFor(scrolledForm.getBody());
        }

        protected void okPressed() {
            this.pmIdText = AddPaperAction.this.pubmedId.getText();
            DataBindingContext dataBindingContext = new DataBindingContext();
            Binding binding = dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)AddPaperAction.this.pubmedId), PojoProperties.value(PubMedFormDialog.class, (String)"pmIdText").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new IntegerFieldValidator("Pubmed Id should be an integer", AddPaperAction.this.dec)), null);
            if (((Status)binding.getValidationStatus().getValue()).isOK()) {
                this.pmId = Integer.parseInt(this.pmIdText.trim());
                super.okPressed();
            } else {
                AddPaperAction.this.errorLabel.setForeground(ColorConstants.red);
                AddPaperAction.this.errorLabel.setText("Please provide a valid pubmed id");
            }
        }

        class IntegerFieldValidator
        implements IValidator {
            private final String errorText;
            private final ControlDecoration controlDecoration;

            public IntegerFieldValidator(String errorText, ControlDecoration controlDecoration) {
                this.errorText = errorText;
                this.controlDecoration = controlDecoration;
            }

            public IStatus validate(Object value) {
                if (value instanceof String) {
                    String text = (String)value;
                    if (text.trim().length() == 0) {
                        this.controlDecoration.show();
                        return ValidationStatus.error((String)this.errorText);
                    }
                    try {
                        Integer.parseInt(text.trim());
                    }
                    catch (Exception exception) {
                        this.controlDecoration.show();
                        return ValidationStatus.error((String)this.errorText);
                    }
                }
                this.controlDecoration.hide();
                ((PubMedFormDialog)PubMedFormDialog.this).AddPaperAction.this.errorLabel.setText("");
                return Status.OK_STATUS;
            }
        }
    }
}

