/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io;

import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;

public abstract class SugarImporterText
extends SugarImporter {
    protected char m_cToken = '\u0000';
    protected int m_iPosition = 0;
    protected int m_iLength = 0;
    protected String m_strText = "";

    protected char aheadToken(int a_iPosition) throws SugarImporterException {
        try {
            return this.m_strText.charAt(this.m_iPosition + a_iPosition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SugarImporterException("COMMON012");
        }
    }

    protected void nextToken() throws SugarImporterException {
        ++this.m_iPosition;
        try {
            this.m_cToken = this.m_strText.charAt(this.m_iPosition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SugarImporterException("COMMON000");
        }
    }

    protected int number() throws SugarImporterException {
        int t_iResult = 0;
        char t_iDigit = '\u0000';
        if (this.m_cToken == '0') {
            this.nextToken();
            return t_iResult;
        }
        t_iDigit = this.m_cToken;
        if (t_iDigit < '1' || t_iDigit > '9') {
            throw new SugarImporterException("COMMON004", this.m_iPosition);
        }
        t_iResult = t_iDigit - 48;
        this.nextToken();
        t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            t_iResult = t_iResult * 10 + (t_iDigit - 48);
            this.nextToken();
            t_iDigit = this.m_cToken;
        }
        return t_iResult;
    }

    protected int natural_number() throws SugarImporterException {
        int t_iResult = 0;
        char t_iDigit = '\u0000';
        t_iDigit = this.m_cToken;
        if (t_iDigit < '1' || t_iDigit > '9') {
            throw new SugarImporterException("COMMON004", this.m_iPosition);
        }
        t_iResult = t_iDigit - 48;
        this.nextToken();
        t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            t_iResult = t_iResult * 10 + (t_iDigit - 48);
            this.nextToken();
            t_iDigit = this.m_cToken;
        }
        return t_iResult;
    }

    protected double float_number() throws SugarImporterException {
        double t_dResult = 0.0;
        double t_dDezi = 10.0;
        char t_iDigit = '\u0000';
        if (this.m_cToken == '0') {
            this.nextToken();
        } else {
            t_iDigit = this.m_cToken;
            if (t_iDigit < '1' || t_iDigit > '9') {
                throw new SugarImporterException("COMMON002", this.m_iPosition);
            }
            t_dResult = t_iDigit - 48;
            this.nextToken();
            t_iDigit = this.m_cToken;
            while (t_iDigit > '/' && t_iDigit < ':') {
                t_dResult = t_dResult * 10.0 + (double)(t_iDigit - 48);
                this.nextToken();
                t_iDigit = this.m_cToken;
            }
        }
        if (this.m_cToken == '.') {
            this.nextToken();
            t_iDigit = this.m_cToken;
            if (t_iDigit < '0' || t_iDigit > '9') {
                throw new SugarImporterException("COMMON009", this.m_iPosition);
            }
            t_dResult += (double)(t_iDigit - 48) / t_dDezi;
            this.nextToken();
            t_iDigit = this.m_cToken;
            while (t_iDigit > '/' && t_iDigit < ':') {
                t_dResult += (double)(t_iDigit - 48) / (t_dDezi *= 10.0);
                this.nextToken();
                t_iDigit = this.m_cToken;
            }
        }
        return t_dResult;
    }

    protected void character() throws SugarImporterException {
        if (this.m_cToken >= 'A' && this.m_cToken <= 'Z') {
            this.nextToken();
        } else if (this.m_cToken >= 'a' && this.m_cToken <= 'z') {
            this.nextToken();
        } else {
            throw new SugarImporterException("COMMON003", this.m_iPosition);
        }
    }

    protected void character_l() throws SugarImporterException {
        if (this.m_cToken < 'a' || this.m_cToken > 'z') {
            throw new SugarImporterException("COMMON010", this.m_iPosition);
        }
        this.nextToken();
    }

    protected void character_u() throws SugarImporterException {
        if (this.m_cToken < 'A' || this.m_cToken > 'Z') {
            throw new SugarImporterException("COMMON011", this.m_iPosition);
        }
        this.nextToken();
    }

    protected void string_l() throws SugarImporterException {
        this.character_l();
        while (this.m_cToken >= 'a' && this.m_cToken <= 'z') {
            this.character_l();
        }
    }

    protected void string_u() throws SugarImporterException {
        this.character_u();
        while (this.m_cToken >= 'A' && this.m_cToken <= 'Z') {
            this.character_u();
        }
    }

    protected double float_number_signed() throws SugarImporterException {
        if (this.m_cToken == '+') {
            this.nextToken();
            return this.float_number();
        }
        if (this.m_cToken == '-') {
            this.nextToken();
            return 0.0 - this.float_number();
        }
        return this.float_number();
    }

    protected void string() throws SugarImporterException {
        this.character();
        while (this.m_cToken >= 'A' && this.m_cToken <= 'Z' || this.m_cToken >= 'a' && this.m_cToken <= 'z') {
            this.character();
        }
    }

    @Override
    public Sugar parse(String a_strStream) throws SugarImporterException {
        this.m_objSugar = new Sugar();
        this.m_iPosition = -1;
        this.m_strText = String.valueOf(a_strStream) + '$';
        this.m_iLength = this.m_strText.length();
        this.nextToken();
        this.start();
        return this.m_objSugar;
    }

    protected boolean finished() {
        return this.m_cToken == '$' && this.m_iPosition + 1 == this.m_iLength;
    }

    protected abstract void start() throws SugarImporterException;
}

