/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.dialog.GlycresoftDialog;
import org.grits.toolbox.entry.ms.preference.GlycresoftPreference;

public class GlycresoftHandler {
    private static final Logger logger = Logger.getLogger(GlycresoftHandler.class);
    public static final String PARAMETER = "mzXMLFile_Path";
    public static final String PARAMETER2 = "msPath";
    public static final String COMMAND_ID = "org.grits.toolbox.entry.ms.command.glycresoft";
    private String processedFile;
    String averagineModel = "glycan";

    @Execute
    public String execute(@Named(value="activeShell") @Named(value="activeShell") Shell shell, final @Named(value="mzXMLFile_Path") @Named(value="mzXMLFile_Path") String file, final @Named(value="msPath") @Named(value="msPath") String msPath) {
        GlycresoftPreference preferences;
        block13: {
            preferences = GlycresoftPreference.loadPreferences();
            if (preferences != null && preferences.getLocation() != null) break block13;
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Please set the preferences for Glycresoft first!");
            return null;
        }
        GlycresoftDialog d = new GlycresoftDialog(shell);
        if (d.open() != 0) {
            return null;
        }
        this.averagineModel = d.getAveragineModel();
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Processing " + file + "...", -1);
                        Runtime r = Runtime.getRuntime();
                        String fullPath = String.valueOf(msPath) + File.separator + file;
                        String outputFile = String.valueOf(msPath) + File.separator + file.substring(0, file.lastIndexOf(".")) + "-glycresoft.mzML";
                        String cmdName = System.getProperty("os.name").startsWith("Windows") ? "glycresoft-cli.exe" : "glycresoft-cli";
                        String[] cmd = new String[]{String.valueOf(preferences.getLocation()) + File.separator + cmdName, "mzml", "preprocess", "-a", GlycresoftHandler.this.averagineModel, "-t", "20", "-an", GlycresoftHandler.this.averagineModel, "-tn", "10", "-b", "5", "-p", "4", "-c", "8", "-m", "3", "-mn", "1", fullPath, outputFile};
                        Process p = r.exec(cmd);
                        BufferedReader bfr = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = "";
                        StringBuffer errorString = new StringBuffer();
                        while (bfr.ready()) {
                            line = bfr.readLine();
                            logger.info((Object)line);
                            errorString.append(String.valueOf(line) + "\n");
                        }
                        bfr.close();
                        BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        while (errorReader.ready()) {
                            line = errorReader.readLine();
                            logger.info((Object)line);
                            errorString.append(String.valueOf(line) + "\n");
                        }
                        errorReader.close();
                        int exitValue = p.waitFor();
                        if (exitValue != 0) {
                            logger.error((Object)("glycresoft failed! Exit Value:" + exitValue + " Reason: " + errorString));
                            throw new InvocationTargetException(new Throwable(errorString.toString()));
                        }
                        GlycresoftHandler.this.processedFile = outputFile;
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            progressMonitorDialog.run(true, false, runnable);
            return this.processedFile;
        }
        catch (InvocationTargetException e) {
            String cause = "";
            if (e.getTargetException() instanceof InvocationTargetException) {
                if (((InvocationTargetException)e.getTargetException()).getTargetException() != null) {
                    cause = ((InvocationTargetException)e.getTargetException()).getTargetException().getMessage();
                }
            } else if (e.getTargetException() instanceof Throwable) {
                cause = e.getTargetException().getMessage();
            }
            if (cause != null && cause.equals("glycresoft-cli: not found")) {
                logger.error((Object)"No Glycresoft tool found.");
            } else {
                logger.error((Object)"Failed to execute glycresoft", (Throwable)e);
            }
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Failed to execute Glycresoft. Reason: " + cause));
        }
        catch (InterruptedException e) {
            logger.info((Object)"Glycresoft is interrupted", (Throwable)e);
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)"Preference version is not supported", (Throwable)e);
        }
        return null;
    }
}

