/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptor;

import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractDeleteAction;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.UnitListLabelProvider;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;

public class DeleteUnitFromDescriptorAction
extends AbstractDeleteAction {
    private String descriptorUri = null;

    public DeleteUnitFromDescriptorAction(AbstractManagementPage page, TableViewer tableViewer) {
        super(page, tableViewer);
    }

    @Override
    public void run() {
        this.selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        if (this.selectionIndex != -1) {
            MeasurementUnit selectedUnit = (MeasurementUnit)this.tableViewer.getTable().getItem(this.selectionIndex).getData();
            List units = ((Descriptor)this.tableViewer.getInput()).getValidUnits();
            int index = -1;
            for (MeasurementUnit unit : units) {
                if (!unit.getUri().equals(selectedUnit.getUri())) continue;
                index = units.indexOf(unit);
                break;
            }
            if (index != -1) {
                units.remove(index);
                Descriptor descriptor = (Descriptor)this.tableViewer.getInput();
                this.descriptorUri = descriptor.getUri();
                this.removeTripleFromOntology(this.descriptorUri, "has_unit_of_measurement", selectedUnit.getUri());
                if (descriptor.getDefaultMeasurementUnit().equals(selectedUnit.getUri()) && !units.isEmpty()) {
                    String nextDefaultUnitUri = ((MeasurementUnit)units.iterator().next()).getUri();
                    this.ontologyManagerApi.setDefaultUnitForDescriptor(this.descriptorUri, nextDefaultUnitUri);
                    ((UnitListLabelProvider)this.tableViewer.getLabelProvider()).setDefaultUnitURI(nextDefaultUnitUri);
                    descriptor.setDefaultMeasurementUnit(nextDefaultUnitUri);
                    this.refreshModifed();
                }
            }
        }
    }
}

