/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardExporter
extends ResourcesDbObject {
    private GlycanNamescheme namescheme = null;
    private TrivialnameTemplate usedTrivialnameTemplate = null;

    public StandardExporter(GlycanNamescheme namescheme) {
        this.setNamescheme(namescheme);
        this.setConfig(Config.getGlobalConfig());
    }

    public StandardExporter(GlycanNamescheme namescheme, Config conf) {
        this.setNamescheme(namescheme);
        this.setConfig(conf);
    }

    public StandardExporter(GlycanNamescheme namescheme, Config conf, TemplateContainer container) {
        this.setNamescheme(namescheme);
        this.setConfig(conf);
        this.setTemplateContainer(container);
    }

    public StandardExporter(Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
    }

    public StandardExporter() {
        this(null, null, null);
    }

    public GlycanNamescheme getNamescheme() {
        return this.namescheme;
    }

    public void setNamescheme(GlycanNamescheme scheme) {
        this.namescheme = scheme;
    }

    public TrivialnameTemplate getUsedTrivialnameTemplate() {
        return this.usedTrivialnameTemplate;
    }

    public void setUsedTrivialnameTemplate(TrivialnameTemplate template) {
        this.usedTrivialnameTemplate = template;
    }

    public ArrayList<SubstituentExchangeObject> getSeparateDisplaySubstituents(Monosaccharide ms) throws ResourcesDbException {
        ArrayList<SubstituentExchangeObject> outList = new ArrayList<SubstituentExchangeObject>();
        for (Substitution subst : ms.getSubstitutions()) {
            Substitution trivSubst;
            int position1;
            String separateDisplayName;
            TrivialnameTemplate usedTriv = this.getUsedTrivialnameTemplate();
            if (usedTriv != null && usedTriv.hasSubstitution(subst) || (separateDisplayName = subst.getTemplate().getSeparateDisplay(this.getNamescheme(), subst.getLinkagetype1())) == null) continue;
            if (usedTriv == null || (position1 = subst.getIntValuePosition1()) <= 0 || (trivSubst = usedTriv.getSubstitutionByPosition(position1, subst.getLinkagetype1())) != null) {
                // empty if block
            }
            if (subst.getTemplate().isSplit(this.getNamescheme(), subst.getLinkagetype1(), this.getTemplateContainer().getSubstituentTemplateContainer())) {
                SubstituentExchangeObject splitSubst = new SubstituentExchangeObject(this.getNamescheme(), this.getConfig(), this.getTemplateContainer());
                SubstituentTemplate extTemplate = subst.getTemplate().getSeparateDisplayTemplate(this.getNamescheme(), subst.getLinkagetype1(), this.getTemplateContainer().getSubstituentTemplateContainer());
                splitSubst.setName(separateDisplayName);
                splitSubst.setPosition1(subst.getPosition1());
                splitSubst.setPosition2(subst.getPosition2());
                splitSubst.setLinkagetype1(extTemplate.getDefaultLinkagetype1());
                splitSubst.setLinkagetype2(extTemplate.getDefaultLinkagetype2());
                splitSubst.setSubstituentPosition1(extTemplate.getDefaultLinkingPosition1());
                splitSubst.setOriginalName(subst.getSourceName());
                splitSubst.setOriginalLinkagetype1(subst.getSourceLinkagetype1());
                splitSubst.setOriginalLinkagetype2(subst.getSourceLinkagetype2());
                outList.add(splitSubst);
                continue;
            }
            SubstituentExchangeObject extSubst = new SubstituentExchangeObject(subst, this.getNamescheme());
            extSubst.setName(separateDisplayName);
            outList.add(extSubst);
        }
        return outList;
    }

    public ArrayList<SubstituentExchangeObject> getResidueIncludedSubstituents(Monosaccharide ms) throws ResourcesDbException {
        ArrayList<SubstituentExchangeObject> outList = new ArrayList<SubstituentExchangeObject>();
        for (Substitution subst : ms.getSubstitutions()) {
            Substitution trivSubst;
            int position1;
            TrivialnameTemplate usedTriv;
            String residueIncludedName = subst.getTemplate().getResidueIncludedName(this.getNamescheme(), subst.getLinkagetype1());
            if (residueIncludedName == null || (usedTriv = this.getUsedTrivialnameTemplate()) != null && (position1 = subst.getIntValuePosition1()) > 0 && (trivSubst = usedTriv.getSubstitutionByPosition(position1, subst.getLinkagetype1())) != null && trivSubst.equals(subst)) continue;
            SubstituentExchangeObject inclSubst = new SubstituentExchangeObject(subst, this.getNamescheme());
            inclSubst.setName(residueIncludedName);
            outList.add(inclSubst);
        }
        return outList;
    }
}

