/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.swtchart.IGrid;
import org.swtchart.LineStyle;
import org.swtchart.internal.Util;
import org.swtchart.internal.axis.Axis;

public class Grid
implements IGrid {
    private Axis axis;
    private Color color;
    private boolean isVisible;
    private LineStyle lineStyle;
    private static final int LINE_WIDTH = 1;
    private static final LineStyle DEFAULT_STYLE = LineStyle.DOT;
    private static final int DEFAULT_FOREGROUND = 15;

    public Grid(Axis axis) {
        this.axis = axis;
        this.color = Display.getDefault().getSystemColor(15);
        this.lineStyle = DEFAULT_STYLE;
        this.isVisible = true;
    }

    @Override
    public Color getForeground() {
        if (this.color.isDisposed()) {
            this.color = Display.getDefault().getSystemColor(15);
        }
        return this.color;
    }

    @Override
    public void setForeground(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.color = color == null ? Display.getDefault().getSystemColor(15) : color;
    }

    @Override
    public LineStyle getStyle() {
        return this.lineStyle;
    }

    @Override
    public void setStyle(LineStyle style) {
        this.lineStyle = style == null ? DEFAULT_STYLE : style;
    }

    protected void draw(GC gc, int width, int height) {
        if (!this.isVisible || this.lineStyle.equals((Object)LineStyle.NONE)) {
            return;
        }
        int xWidth = this.axis.isHorizontalAxis() ? width : height;
        Color oldForeground = gc.getForeground();
        gc.setForeground(this.getForeground());
        ArrayList<Integer> tickLabelPosition = this.axis.getTick().getAxisTickLabels().getTickLabelPositions();
        gc.setLineStyle(Util.getIndexDefinedInSWT(this.lineStyle));
        if (this.axis.isValidCategoryAxis()) {
            int step = 0;
            step = tickLabelPosition.size() > 1 ? tickLabelPosition.get(1) - tickLabelPosition.get(0) : xWidth;
            int x = (int)((double)tickLabelPosition.get(0).intValue() - (double)step / 2.0);
            for (int i = 0; i < tickLabelPosition.size() + 1; ++i) {
                if ((x += step) >= xWidth) continue;
                if (this.axis.isHorizontalAxis()) {
                    gc.drawLine(x, 1, x, height - 1);
                    continue;
                }
                gc.drawLine(1, x, width - 1, x);
            }
        } else {
            for (int i = 0; i < tickLabelPosition.size(); ++i) {
                int x = tickLabelPosition.get(i);
                if (x >= xWidth) continue;
                if (this.axis.isHorizontalAxis()) {
                    gc.drawLine(x, 1, x, height - 1);
                    continue;
                }
                gc.drawLine(1, height - 1 - x, width - 1, height - 1 - x);
            }
        }
        gc.setForeground(oldForeground);
    }
}

