/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExporter;
import org.eurocarbdb.resourcesdb.io.StandardExporter;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;
import org.eurocarbdb.resourcesdb.util.StringUtils;
import org.eurocarbdb.resourcesdb.util.Utils;

public class CarbbankExporter
extends StandardExporter
implements MonosaccharideExporter {
    private TrivialnameTemplate trivialTmpl = null;

    public CarbbankExporter(GlycanNamescheme namescheme) throws ResourcesDbException {
        super(namescheme);
    }

    public CarbbankExporter(GlycanNamescheme namescheme, Config conf) throws ResourcesDbException {
        super(namescheme, conf);
    }

    public CarbbankExporter(GlycanNamescheme namescheme, Config conf, TemplateContainer container) throws ResourcesDbException {
        super(namescheme, conf, container);
    }

    public CarbbankExporter(Config conf, TemplateContainer container) throws ResourcesDbException {
        super(GlycanNamescheme.CARBBANK, conf, container);
    }

    public TrivialnameTemplate getTrivialTmpl() {
        return this.trivialTmpl;
    }

    public void setTrivialTmpl(TrivialnameTemplate trivialTmpl) {
        this.trivialTmpl = trivialTmpl;
    }

    @Override
    public String export(Monosaccharide ms) throws ResourcesDbException {
        return this.export(ms, this.getConfig().isForceTrivialNames());
    }

    public String export(Monosaccharide ms, boolean forceTrivial) throws ResourcesDbException {
        int basetypeIndex;
        ArrayList<Object> basetypeList;
        if (this.getNamescheme() == null) {
            throw new MonosaccharideException("No namescheme set in CarbbankExporter.java");
        }
        String msNameStr = "";
        if (ms.getRingtype().equals((Object)Ringtype.OPEN) && !MonosaccharideValidation.impliesOpenChain(ms)) {
            msNameStr = ms.hasCoreModification(CoreModificationTemplate.KETO) && !ms.hasCoreModification(CoreModificationTemplate.KETO, 1) ? msNameStr + "keto-" : msNameStr + "aldehydo-";
        }
        TrivialnameTemplate trivTmpl = null;
        if (this.getConfig().isAllowTrivialNames() && (trivTmpl = this.getTemplateContainer().getTrivialnameTemplateContainer().checkMsForTrivialname(this.getNamescheme(), ms)) != null && trivTmpl.getPrimaryName(this.getNamescheme()) == null && !forceTrivial) {
            trivTmpl = null;
        }
        this.setTrivialTmpl(trivTmpl);
        if (trivTmpl != null) {
            basetypeList = new ArrayList<String>();
            basetypeList.add(Stereocode.getTrivialnameConfigurationFromStereoString(ms.getStereoStr()).getSymbol() + "-" + trivTmpl.getPrimaryName(this.getNamescheme()));
        } else {
            basetypeList = Stereocode.getBasetypelistFromStereocode(ms, this.getTemplateContainer().getBasetypeTemplateContainer());
        }
        for (basetypeIndex = 0; basetypeIndex < basetypeList.size() - 1; ++basetypeIndex) {
            msNameStr = msNameStr + CarbbankExporter.unknownConfigBasetypeXtoQMark((String)basetypeList.get(basetypeIndex)) + "-" + msNameStr;
        }
        String anomerStr = ms.getAnomer().formatCarbbankSymbol();
        if (this.getNamescheme().equals((Object)GlycanNamescheme.CARBBANK) && anomerStr.equals("?-")) {
            anomerStr = "";
        }
        msNameStr = msNameStr + anomerStr;
        if (trivTmpl != null) {
            msNameStr = this.getNamescheme().equals((Object)GlycanNamescheme.CARBBANK) && ((String)basetypeList.get(basetypeIndex)).substring(0, 2).equalsIgnoreCase("X-") ? msNameStr + StringUtils.camelCase(CarbbankExporter.deleteUnknownConfigBasetypeX((String)basetypeList.get(basetypeIndex)), 0, 0) : msNameStr + StringUtils.camelCase(CarbbankExporter.unknownConfigBasetypeXtoQMark((String)basetypeList.get(basetypeIndex)), 0, 2);
        } else {
            BasetypeTemplate msTmpl;
            String tmpBasetypeStr = basetypeList.size() > 0 ? (this.getNamescheme().equals((Object)GlycanNamescheme.CARBBANK) ? CarbbankExporter.deleteUnknownConfigBasetypeX((String)basetypeList.get(basetypeIndex)) : CarbbankExporter.unknownConfigBasetypeXtoQMark((String)basetypeList.get(basetypeIndex))) : this.getTemplateContainer().getBasetypeTemplateContainer().getSuperclassTemplateBySize(ms.getSize()).getBaseName();
            String configStr = "";
            String basetypeStr = tmpBasetypeStr;
            if (tmpBasetypeStr.length() == 5) {
                configStr = tmpBasetypeStr.substring(0, 2);
                basetypeStr = tmpBasetypeStr.substring(2);
            }
            msNameStr = msNameStr + configStr;
            boolean wroteDeoxy = false;
            for (CoreModification coreMod : ms.getCoreModifications()) {
                if (coreMod.getTemplate().equals((Object)CoreModificationTemplate.ACID) || coreMod.getTemplate().equals((Object)CoreModificationTemplate.KETO) || coreMod.getTemplate().equals((Object)CoreModificationTemplate.SP2) || coreMod.getTemplate().equals((Object)CoreModificationTemplate.ALDITOL)) continue;
                String posStr = Utils.formatPositionsString(coreMod.getPosition1(), "/", "?");
                if (coreMod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY)) {
                    if (wroteDeoxy) continue;
                    for (CoreModification deoxyMod : ms.getCoreModifications(CoreModificationTemplate.DEOXY.getName())) {
                        if (deoxyMod.equals(coreMod)) continue;
                        posStr = posStr + "," + Utils.formatPositionsString(deoxyMod.getPosition1(), "/", "?");
                    }
                    wroteDeoxy = true;
                }
                if (!(coreMod.getValence() != 2 || coreMod.getTemplate().equals((Object)CoreModificationTemplate.EN) || coreMod.getTemplate().equals((Object)CoreModificationTemplate.ENX) || coreMod.getTemplate().equals((Object)CoreModificationTemplate.YN))) {
                    posStr = posStr + "," + Utils.formatPositionsString(coreMod.getPosition2(), "/", "?");
                }
                msNameStr = msNameStr + posStr + "-" + coreMod.getName() + "-";
            }
            if (this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(basetypeStr).getSize() == ms.getSize()) {
                basetypeStr = StringUtils.camelCase(basetypeStr);
            } else if (basetypeStr.equals("tro")) {
                basetypeStr = "thr";
            }
            msNameStr = msNameStr + basetypeStr;
            if (basetypeList.size() > 0 && (msTmpl = this.getTemplateContainer().getBasetypeTemplateContainer().getBasetypeTemplateByName(((String)basetypeList.get(basetypeIndex)).substring(2))).getSize() < ms.getSize()) {
                msNameStr = msNameStr + StringUtils.camelCase(this.getTemplateContainer().getBasetypeTemplateContainer().getSuperclassTemplateBySize(ms.getSize()).getBaseName());
            }
            for (CoreModification coreMod : ms.getCoreModifications(CoreModificationTemplate.KETO.getName())) {
                msNameStr = msNameStr + coreMod.getPosition1().get(0) + "ulo";
            }
        }
        msNameStr = msNameStr + ms.getRingtypeSymbol();
        if (ms.isUronic() && trivTmpl == null) {
            msNameStr = msNameStr + "A";
        }
        int substCount = 0;
        for (Substitution subst : ms.getSubstitutions()) {
            Substitution trivSubst;
            int position1;
            String posStr = Utils.formatPositionsString(subst.getPosition1(), "/", "?");
            if (!GlycanNamescheme.GWB.equals((Object)this.getNamescheme()) && posStr.equals("2") && (subst.getTemplate().getName().equalsIgnoreCase(SubstituentTemplate.AMINOTEMPLATENAME) || subst.getTemplate().isExtendedAmine(this.getTemplateContainer().getSubstituentTemplateContainer())) && substCount == 0 && !subst.hasPosition2()) {
                posStr = "";
            }
            if (subst.hasPosition2()) {
                posStr = posStr + "," + Utils.formatPositionsString(subst.getPosition2(), "/", "?");
            }
            String substName = subst.getResidueIncludedName(this.getNamescheme());
            if (trivTmpl != null && (position1 = subst.getIntValuePosition1()) > 0 && (trivSubst = trivTmpl.getSubstitutionByPosition(position1)) != null) {
                if (trivSubst.equals(subst)) continue;
                if (trivSubst.getName().equals(SubstituentTemplate.AMINOTEMPLATENAME)) {
                    String substTmplSepDisp;
                    SubstituentTemplate oLinkedEquivTmpl;
                    String oLinkTmplSepDisp;
                    String oLinkedEquivName;
                    if (subst.getResidueIncludedName(this.getNamescheme()) != null && this.getTemplateContainer().getSubstituentTemplateContainer().forName(this.getNamescheme(), subst.getResidueIncludedName(this.getNamescheme())).getName().equals(SubstituentTemplate.AMINOTEMPLATENAME)) continue;
                    if (subst.getTemplate().isExtendedAmine(this.getTemplateContainer().getSubstituentTemplateContainer()) && (oLinkedEquivName = subst.getTemplate().getOLinkedEquivalent(this.getTemplateContainer().getSubstituentTemplateContainer())) != null && oLinkedEquivName.length() > 0 && StringUtils.strCmpNullEqualsEmpty(oLinkTmplSepDisp = (oLinkedEquivTmpl = this.getTemplateContainer().getSubstituentTemplateContainer().forName(GlycanNamescheme.GLYCOCT, oLinkedEquivName)).getSeparateDisplay(this.getNamescheme(), LinkageType.H_AT_OH), substTmplSepDisp = null)) {
                        oLinkedEquivName = oLinkedEquivTmpl.getPrimaryAlias(this.getNamescheme(), LinkageType.H_AT_OH).getResidueIncludedName();
                        substName = oLinkedEquivTmpl.getResidueIncludedName(this.getNamescheme(), LinkageType.H_AT_OH);
                        if (substName == null || substName.length() == 0) {
                            substName = oLinkedEquivTmpl.getSeparateDisplay(this.getNamescheme(), LinkageType.H_AT_OH);
                        }
                        if (oLinkedEquivName.startsWith("O")) {
                            oLinkedEquivName = oLinkedEquivName.substring(1);
                        }
                        if (oLinkedEquivName.startsWith("-")) {
                            oLinkedEquivName = oLinkedEquivName.substring(1);
                        }
                        substName = oLinkedEquivTmpl.equals(this.getTemplateContainer().getSubstituentTemplateContainer().forName(this.getNamescheme(), oLinkedEquivName)) ? oLinkedEquivName : subst.getResidueIncludedName(this.getNamescheme());
                    }
                }
            }
            if (substName == null || substName.length() <= 0) continue;
            msNameStr = msNameStr + posStr + substName;
            ++substCount;
        }
        if (ms.isAlditol()) {
            msNameStr = msNameStr + "-ol";
        }
        if (trivTmpl == null) {
            if (ms.isAldaric()) {
                msNameStr = msNameStr + "-aric";
            }
            if (ms.isAldonic()) {
                msNameStr = msNameStr + "-onic";
            }
        }
        return msNameStr;
    }

    private static String unknownConfigBasetypeXtoQMark(String basetypeStr) {
        if (basetypeStr.substring(0, 2).equalsIgnoreCase("X-")) {
            return "?-" + basetypeStr.substring(2);
        }
        return basetypeStr;
    }

    private static String deleteUnknownConfigBasetypeX(String basetypeStr) {
        if (basetypeStr.substring(0, 2).equalsIgnoreCase("X-")) {
            return basetypeStr.substring(2);
        }
        return basetypeStr;
    }
}

