/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.grammar;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureGenerator;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureScorer;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarTree;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.Rule;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.RuleProfile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Grammar
implements StructureGenerator,
StructureScorer {
    public static final int SCORE_DIST = 0;
    public static final int SCORE_PDIST = 1;
    public static final int SCORE_PROB = 2;
    public static final int SCORE_PROB_DIST = 3;
    private static GrammarTree[] cores = new GrammarTree[8];
    private static GrammarTree[] cores_tagged = new GrammarTree[8];
    private TreeMap<Rule, Double> rules = new TreeMap();
    private TreeMap<GrammarTree, RuleProfile> seeds = new TreeMap();
    private GrammarOptions options = new GrammarOptions();
    private MassOptions mass_opt = null;
    private LinkedList<GrammarTree> pool = new LinkedList();
    private TreeSet<String> visited = new TreeSet();
    private GrammarTree last_structure = null;

    public Grammar() {
    }

    public Grammar(String filename, boolean on_file_system) throws Exception {
        this.load(filename, on_file_system);
    }

    public Collection<Rule> getRules() {
        return this.rules.keySet();
    }

    @Override
    public String getScorerType() {
        return "Grammar";
    }

    public void load(String filename, boolean on_file_system) throws Exception {
        this.load(FileUtils.open(this.getClass(), (String)filename, (!on_file_system ? 1 : 0) != 0));
    }

    public void load(InputStream is) throws Exception {
        Document d = XMLUtils.read((InputStream)is);
        this.fromXML(XMLUtils.assertChild((Node)d, (String)"Grammar"), false);
    }

    public void save(String filename) throws Exception {
        this.save(new FileOutputStream(filename));
    }

    public void save(OutputStream os) throws Exception {
        Document d = XMLUtils.newDocument();
        d.appendChild(this.toXML(d));
        XMLUtils.write((OutputStream)os, (Document)d);
    }

    public static Collection<Rule> extractRules(Glycan structure, GrammarOptions opt) throws Exception {
        Vector<Rule> ret = new Vector<Rule>();
        Grammar.extractRules(ret, structure, opt);
        return ret;
    }

    public static Collection<Rule> extractRules(GrammarTree structure, GrammarOptions opt) {
        Vector<Rule> ret = new Vector<Rule>();
        Grammar.extractRules(ret, structure, opt);
        return ret;
    }

    public static void extractRules(Collection<Rule> buffer, Glycan structure, GrammarOptions opt) throws Exception {
        GrammarTree gt = GrammarTree.fromGlycan(structure, opt.ADD_LINKAGE_INFO);
        if (opt.TAG_CORES) {
            Grammar.tagCore(gt);
        }
        Grammar.extractRules(buffer, gt, opt);
    }

    private static void extractRules(Collection<Rule> buffer, GrammarTree gt, GrammarOptions opt) {
        if (buffer == null) {
            return;
        }
        Rule toadd = Rule.createRule(gt, opt);
        if (toadd != null) {
            buffer.add(toadd);
        }
        for (GrammarTree gtc : gt.getChildren()) {
            Grammar.extractRules(buffer, gtc, opt);
        }
    }

    public static Grammar createGrammar(Collection<Glycan> structures, GrammarOptions opt) {
        if (structures == null || opt == null) {
            return new Grammar();
        }
        Grammar ret = new Grammar();
        ret.options = opt;
        try {
            String nkey;
            RuleProfile all_rules = new RuleProfile();
            for (Glycan s : structures) {
                GrammarTree gt = GrammarTree.fromGlycan(s, ret.options.ADD_LINKAGE_INFO);
                if (ret.seeds.containsKey(gt)) continue;
                if (opt.TAG_CORES) {
                    Grammar.tagCore(gt);
                }
                Collection<Rule> extracted = Grammar.extractRules(gt, ret.options);
                all_rules.addAll(extracted);
                extracted = Grammar.extractRules(gt, ret.options);
                ret.seeds.put(gt, new RuleProfile(extracted));
            }
            HashMap<String, Double> normalizations = new HashMap<String, Double>();
            for (Map.Entry<Rule, Double> e : all_rules.getEntries()) {
                nkey = e.getKey().leftSide();
                Double old_val = (Double)normalizations.get(nkey);
                if (old_val == null) {
                    normalizations.put(nkey, e.getValue());
                    continue;
                }
                normalizations.put(nkey, old_val + e.getValue());
            }
            for (Map.Entry<Rule, Double> e : all_rules.getEntries()) {
                nkey = e.getKey().leftSide();
                ret.rules.put(e.getKey(), e.getValue() / (Double)normalizations.get(nkey));
            }
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
        return ret;
    }

    private static void tagCore(GrammarTree gt) {
        for (int i = 0; i < cores.length; ++i) {
            HashSet<GrammarTree> matchings = new HashSet<GrammarTree>();
            if (!Grammar.subtreeMatches(gt, cores[i], matchings)) continue;
            GrammarTree.tag(gt, "" + i, matchings);
            return;
        }
    }

    public static int whichCore(GrammarTree gt) {
        for (int i = 0; i < cores.length; ++i) {
            HashSet<GrammarTree> matchings = new HashSet<GrammarTree>();
            if (!Grammar.subtreeMatches(gt, cores[i], matchings)) continue;
            return i;
        }
        return -1;
    }

    private static boolean subtreeMatches(GrammarTree structure, GrammarTree core, Collection<GrammarTree> matchings) {
        if (!structure.getLabel().equals(core.getLabel())) {
            return false;
        }
        if (core.getNoChildren() == 0) {
            matchings.add(structure);
            return true;
        }
        for (Vector<GrammarTree> combination : Grammar.getAllCombinations(structure.getChildren(), core.getNoChildren())) {
            Vector<GrammarTree> children_matchings = new Vector<GrammarTree>();
            Iterator i = combination.iterator();
            Iterator<GrammarTree> l = core.getChildren().iterator();
            boolean matches = true;
            while (i.hasNext()) {
                if (Grammar.subtreeMatches((GrammarTree)i.next(), l.next(), children_matchings)) continue;
                matches = false;
            }
            if (!matches) continue;
            matchings.add(structure);
            matchings.addAll(children_matchings);
            return true;
        }
        return false;
    }

    private static Vector<Vector<GrammarTree>> getAllCombinations(Collection<GrammarTree> src, int size) {
        Vector<Vector<GrammarTree>> ret = new Vector<Vector<GrammarTree>>();
        Grammar.getAllCombinations(ret, src, (Union<GrammarTree>)new Union(), size);
        return ret;
    }

    private static void getAllCombinations(Vector<Vector<GrammarTree>> buffer, Collection<GrammarTree> src, Union<GrammarTree> combination, int size) {
        if (src.size() - combination.size() < size) {
            return;
        }
        if (size == 0 && combination.size() > 0) {
            buffer.add((Vector<GrammarTree>)combination);
        }
        for (GrammarTree o : src) {
            if (combination.contains((Object)o)) continue;
            Grammar.getAllCombinations(buffer, src, (Union<GrammarTree>)combination.and((Object)o), size - 1);
        }
    }

    public boolean accept(Glycan structure) throws Exception {
        if (structure == null || structure.isEmpty()) {
            return true;
        }
        GrammarTree gt = GrammarTree.fromGlycan(structure, this.options.ADD_LINKAGE_INFO);
        if (this.seeds.containsKey(gt)) {
            return true;
        }
        if (this.options.TAG_CORES) {
            Grammar.tagCore(gt);
        }
        Collection<Rule> extracted = Grammar.extractRules(gt, this.options);
        for (Rule r : extracted) {
            if (this.rules.containsKey(r)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void start(MassOptions _mass_opt) {
        this.mass_opt = _mass_opt;
        if (this.seeds.size() == 0 || !this.options.USE_SEEDS) {
            for (int i = 0; i < cores_tagged.length; ++i) {
                this.pool.add(cores_tagged[i]);
            }
        } else {
            this.pool.addAll(this.seeds.keySet());
        }
        this.last_structure = null;
        this.visited.clear();
    }

    @Override
    public FragmentEntry next(boolean backtrack) {
        if (this.last_structure != null && !backtrack) {
            this.generateStructures(this.pool, this.last_structure);
        }
        while (this.pool.size() > 0) {
            String str_structure;
            if (this.seeds.size() == 0 || !this.options.USE_SEEDS) {
                this.last_structure = this.pool.getLast();
                this.pool.removeLast();
            } else {
                this.last_structure = this.pool.getFirst();
                this.pool.removeFirst();
            }
            if (this.visited.contains(str_structure = this.last_structure.toString(true))) continue;
            this.visited.add(str_structure);
            try {
                Glycan s = this.last_structure.toGlycan(this.mass_opt);
                if (this.options.USE_SEEDS && this.seeds.containsKey(this.last_structure)) {
                    return new FragmentEntry(s, "seed");
                }
                return new FragmentEntry(s, "generated");
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public double computeScore(Glycan structure) {
        return this.computeScore(structure, 0);
    }

    public double computeMinDist(RuleProfile rp) {
        double min_dist = Double.MAX_VALUE;
        for (Map.Entry<GrammarTree, RuleProfile> e : this.seeds.entrySet()) {
            double dist = rp.intersection(e.getValue()).absSum();
            min_dist = Math.min(min_dist, dist);
        }
        return min_dist;
    }

    public double computeMinPDist(RuleProfile rp) {
        double min_pdist = Double.MAX_VALUE;
        for (Map.Entry<GrammarTree, RuleProfile> e : this.seeds.entrySet()) {
            double dist = -this.computeLogProb(rp.intersection(e.getValue()));
            min_pdist = Math.min(min_pdist, dist);
        }
        return min_pdist;
    }

    public double computeLogProb(RuleProfile rp) {
        double ret = 0.0;
        for (Map.Entry<Rule, Double> e : rp.getEntries()) {
            ret += Math.log(this.rules.get(e.getKey())) * Math.abs(e.getValue());
        }
        return ret;
    }

    public double computeScore(Glycan structure, int type) {
        try {
            RuleProfile rp = new RuleProfile(Grammar.extractRules(structure, this.options));
            if (type == 0) {
                return -this.computeMinDist(rp);
            }
            if (type == 1) {
                return -this.computeMinPDist(rp);
            }
            if (type == 2) {
                return this.computeLogProb(rp);
            }
            if (type == 3) {
                return this.computeMinDist(rp) * this.computeLogProb(rp);
            }
            throw new Exception("Invalid score type");
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return 0.0;
        }
    }

    public StructureDictionary generateDictionary(String dict_name, String s_type, String source, double max_mass) {
        StructureDictionary dict = new StructureDictionary(dict_name);
        dict.setScorer(this);
        boolean backtrack = false;
        FragmentEntry fe = null;
        this.start(MassOptions.empty());
        while ((fe = this.next(backtrack)) != null) {
            dict.add(new StructureType(dict_name, s_type, source, fe.structure));
            backtrack = fe.mass >= max_mass;
        }
        return dict;
    }

    public StructureDictionary generateDictionary(String dict_name, String s_type, String source, double max_mass, int max_res, int score_type) {
        StructureDictionary dict = new StructureDictionary(dict_name);
        dict.setScorer(this);
        TreeMap<Double, ArrayList<FragmentEntry>> generated = new TreeMap<Double, ArrayList<FragmentEntry>>();
        System.out.println("generating structures");
        boolean backtrack = false;
        FragmentEntry gen = null;
        this.start(MassOptions.empty());
        while ((gen = this.next(backtrack)) != null) {
            if (gen.mass <= max_mass) {
                gen.score = this.computeScore(gen.fragment, score_type);
                gen.fragment = null;
                ArrayList<FragmentEntry> mass_group = (ArrayList<FragmentEntry>)generated.get(gen.mass);
                if (mass_group == null) {
                    mass_group = new ArrayList<FragmentEntry>();
                    generated.put(gen.mass, mass_group);
                }
                mass_group.add(gen);
            }
            backtrack = gen.mass >= max_mass;
        }
        System.out.println("adding to dict");
        block1: for (ArrayList mass_group : generated.values()) {
            TreeMap<Double, ArrayList<FragmentEntry>> ranked = new TreeMap<Double, ArrayList<FragmentEntry>>();
            for (FragmentEntry fe : mass_group) {
                ArrayList<FragmentEntry> rank_group = (ArrayList<FragmentEntry>)ranked.get(-fe.score.doubleValue());
                if (rank_group == null) {
                    rank_group = new ArrayList<FragmentEntry>();
                    ranked.put(-fe.score.doubleValue(), rank_group);
                }
                rank_group.add(fe);
            }
            int rank = 0;
            for (ArrayList<FragmentEntry> rank_group : ranked.values()) {
                if (rank > max_res) continue block1;
                for (FragmentEntry fe : rank_group) {
                    dict.add(new StructureType(dict_name, s_type, source, fe.structure));
                }
                rank += rank_group.size();
            }
        }
        return dict;
    }

    public TreeMap<Glycan, Double> generateStructures(double mass, int score_type) {
        boolean backtrack = false;
        FragmentEntry fe = null;
        TreeMap<Glycan, Double> ret = new TreeMap<Glycan, Double>();
        this.start(MassOptions.empty());
        while ((fe = this.next(backtrack)) != null) {
            if (Math.abs(fe.mass - mass) < 0.1) {
                double score = this.computeScore(fe.fragment, score_type);
                ret.put(fe.fragment, score);
            }
            backtrack = fe.mass >= mass;
        }
        return ret;
    }

    public Collection<GrammarTree> generateStructures(GrammarTree seed) {
        Vector<GrammarTree> ret = new Vector<GrammarTree>();
        this.generateStructures(ret, seed);
        return ret;
    }

    public void generateStructures(Collection<GrammarTree> buffer, GrammarTree seed) {
        if (seed == null) {
            seed = new GrammarTree("+");
        }
        for (Rule r : this.rules.keySet()) {
            Grammar.generateStructures(buffer, seed, r, this.options);
        }
    }

    public static void generateStructures(Collection<GrammarTree> buffer, GrammarTree seed, Rule r, GrammarOptions opt) {
        GrammarTree toadd;
        if (r == null || buffer == null) {
            return;
        }
        if (seed == null) {
            seed = new GrammarTree("+");
        }
        if ((toadd = r.generateStructure(seed, opt)) != null) {
            buffer.add(toadd);
        }
        for (GrammarTree c : seed.getChildren()) {
            Grammar.generateStructures(buffer, c, r, opt);
        }
    }

    @Override
    public StructureScorer fromXML(Node g_node) throws Exception {
        Grammar ret = new Grammar();
        ret.fromXML(g_node, false);
        return ret;
    }

    public void fromXML(Node g_node, boolean merge) throws Exception {
        if (!merge) {
            this.rules.clear();
        }
        Node c_node = XMLUtils.assertChild((Node)g_node, (String)"Configuration");
        Configuration conf = new Configuration();
        conf.fromXML(c_node);
        this.options.retrieve(conf);
        Vector r_nodes = XMLUtils.findAllChildren((Node)g_node, (String)"Rule");
        for (Node r_node : r_nodes) {
            Rule r = Rule.fromXML(r_node);
            String p = XMLUtils.getAttribute((Node)r_node, (String)"probability");
            if (p != null) {
                this.rules.put(r, Double.valueOf(p));
                continue;
            }
            this.rules.put(r, 1.0);
        }
        Vector s_nodes = XMLUtils.findAllChildren((Node)g_node, (String)"Seed");
        for (Node s_node : s_nodes) {
            GrammarTree gt = GrammarTree.fromString(XMLUtils.getAttribute((Node)s_node, (String)"structure"));
            RuleProfile rp = new RuleProfile(Grammar.extractRules(gt, this.options));
            this.seeds.put(gt, rp);
        }
    }

    @Override
    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element g_node = document.createElement("Grammar");
        if (g_node == null) {
            return null;
        }
        Configuration conf = new Configuration();
        this.options.store(conf);
        g_node.appendChild(conf.toXML(document));
        for (Map.Entry<Rule, Double> e : this.rules.entrySet()) {
            Element r_node = e.getKey().toXML(document);
            if (r_node == null) continue;
            r_node.setAttribute("probability", e.getValue().toString());
            g_node.appendChild(r_node);
        }
        for (GrammarTree s : this.seeds.keySet()) {
            Element s_node = document.createElement("Seed");
            s_node.setAttribute("structure", s.toString(false));
            if (s_node == null) continue;
            g_node.appendChild(s_node);
        }
        return g_node;
    }

    static {
        try {
            Grammar.cores[0] = GrammarTree.fromString("(+(GlcNAc(Fuc)(GlcNAc(Man(Man(Man)(Man))(GlcNAc)(Man)))))");
            Grammar.cores[1] = GrammarTree.fromString("(+(GlcNAc(Fuc)(GlcNAc(Man(Man(Man)(Man))(Man)))))");
            Grammar.cores[2] = GrammarTree.fromString("(+(GlcNAc(Fuc)(GlcNAc(Man(Man)(GlcNAc)(Man)))))");
            Grammar.cores[3] = GrammarTree.fromString("(+(GlcNAc(Fuc)(GlcNAc(Man(Man)(Man)))))");
            Grammar.cores[4] = GrammarTree.fromString("(+(GlcNAc(GlcNAc(Man(Man(Man)(Man))(GlcNAc)(Man)))))");
            Grammar.cores[5] = GrammarTree.fromString("(+(GlcNAc(GlcNAc(Man(Man(Man)(Man))(Man)))))");
            Grammar.cores[6] = GrammarTree.fromString("(+(GlcNAc(GlcNAc(Man(Man)(GlcNAc)(Man)))))");
            Grammar.cores[7] = GrammarTree.fromString("(+(GlcNAc(GlcNAc(Man(Man)(Man)))))");
            for (int i = 0; i < cores.length; ++i) {
                Grammar.cores_tagged[i] = cores[i].clone();
                Grammar.tagCore(cores_tagged[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

