/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.MMFCreator;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakData;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.ScanData;
import org.proteomecommons.io.GenericPeakListReader;
import org.proteomecommons.io.PeakList;
import org.proteomecommons.io.PeakListReader;
import org.systemsbiology.jrap.MSXMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SpectraDocument
extends BaseDocument
implements SAXUtils.SAXWriter {
    private MMFCreator mmfc;
    protected Vector<ScanData> theScans = new Vector();
    protected Vector<PeakData> thePeaks = new Vector();
    protected Scan theScan;

    public SpectraDocument(Scan scan) {
        super(false);
        this.theScan = scan;
    }

    protected void setScan(Scan scan) {
        this.theScan = scan;
    }

    private MMFCreator getMMFCreator() {
        try {
            if (this.mmfc == null) {
                this.mmfc = new MMFCreator();
            }
            return this.mmfc;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    public String getName() {
        return "Spectra";
    }

    public ImageIcon getIcon() {
        return FileUtils.defaultThemeManager.getImageIcon("spectradoc");
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"mzdata", "xml"}, "mzData spectra file"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"mzxml", "xml"}, "mzXML spectra file"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"t2d"}, "ABI 4000 series spectra file"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"txt"}, "ASCII spectra file"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"mzdata", "mzxml", "xml", "t2d", "txt"}, "All spectra files"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter(new String[]{"mzdata", "mzxml", "xml", "t2d", "txt"}, "Spectra files");
    }

    public boolean open(String filename, boolean merge, boolean warning) {
        try {
            if (!this.readSpectra(filename, warning)) {
                return false;
            }
            if (filename.toUpperCase().endsWith(".T2D")) {
                int level = this.theScan.isMsMs() ? 2 : 1;
                for (ScanData scanData : this.theScans) {
                    scanData.ms_level = level;
                }
            }
            this.setFilename(filename);
            this.fireDocumentInit();
            return true;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    protected void read(InputStream is, boolean merge) throws Exception {
        throw new Exception("Unsupported");
    }

    private boolean readSpectra(String filename, boolean warning) throws Exception {
        PeakList p;
        List<Peak> peaks = this.readCSV(filename);
        if (peaks.size() > 0) {
            this.clear();
            PeakData pd = new PeakData(peaks, this.getMMFCreator());
            if (pd.getMaxMZ() > pd.getMinMZ()) {
                ScanData sd = new ScanData(1);
                this.theScans.add(sd);
                this.thePeaks.add(pd);
            }
            return true;
        }
        try {
            MSXMLParser parser = new MSXMLParser(filename);
            if (parser.getScanCount() > 0) {
                this.clear();
                for (int i = 1; i <= parser.getScanCount(); ++i) {
                    org.systemsbiology.jrap.Scan toadd = parser.rap(i);
                    ScanData sd = new ScanData(toadd);
                    PeakData pd = new PeakData(toadd, this.getMMFCreator());
                    if (!(pd.getMaxMZ() > pd.getMinMZ())) continue;
                    this.theScans.add(sd);
                    this.thePeaks.add(pd);
                }
                return true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        PeakListReader plr = GenericPeakListReader.getPeakListReader((String)filename);
        if (plr == null) {
            if (warning) {
                throw new Exception("Spectra file format not recognized");
            }
            return false;
        }
        this.clear();
        int i = 1;
        while ((p = plr.getPeakList()) != null) {
            PeakData pd = new PeakData(p, this.getMMFCreator());
            if (!(pd.getMaxMZ() > pd.getMinMZ())) continue;
            ScanData sd = new ScanData(i++, p);
            this.theScans.add(sd);
            this.thePeaks.add(pd);
        }
        return true;
    }

    private List<Peak> readCSV(String filename) throws Exception {
        System.out.println("reading csv");
        try {
            Vector<Peak> ret = new Vector<Peak>();
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = "";
            boolean header = true;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.length() != 0) {
                    Peak p = Peak.parseString(line);
                    if (p == null && !header) {
                        System.out.println("wrong format in line " + i);
                        return Collections.emptyList();
                    }
                    if (p != null) {
                        if (header) {
                            System.out.println("first peak at line " + i);
                        }
                        header = false;
                        ret.add(p);
                    }
                    if (header && i > 10) {
                        System.out.println("too many lines of header");
                        return Collections.emptyList();
                    }
                }
                ++i;
            }
            System.out.println("read " + ret.size());
            return ret;
        }
        catch (Exception e) {
            System.out.println("exception " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public boolean save(String filename) {
        return false;
    }

    public void fromString(String str, boolean merge) {
    }

    public String toString() {
        return "";
    }

    public int size() {
        return this.getNoScans();
    }

    public Vector<ScanData> getScans() {
        return this.theScans;
    }

    public Vector<PeakData> getPeaks() {
        return this.thePeaks;
    }

    public ScanData getScanDataAt(int ind) {
        return this.theScans.elementAt(ind);
    }

    public PeakData getPeakDataAt(int ind) {
        return this.thePeaks.elementAt(ind);
    }

    public void initData() {
        this.theScans = new Vector();
        this.thePeaks = new Vector();
    }

    public void removeScan(int ind) {
        this.theScans.removeElementAt(ind);
        this.thePeaks.removeElementAt(ind);
        this.fireDocumentChanged();
    }

    public int getNoScans() {
        if (this.theScans == null) {
            return 0;
        }
        return this.theScans.size();
    }

    public int getScanNum(int ind) {
        return this.theScans.elementAt(ind).getNum();
    }

    public void baselineCorrection(int ind) {
        this.thePeaks.elementAt(ind).baselineCorrection();
        this.fireDocumentChanged();
    }

    public void recalibrate(int ind, List<Double> params) {
        this.thePeaks.elementAt(ind).recalibrate(params);
        this.fireDocumentChanged();
    }

    public void noiseFilter(int ind) {
        this.thePeaks.elementAt(ind).noiseFilter();
        this.fireDocumentChanged();
    }

    public void fromXML(Node sd_node, boolean merge) throws Exception {
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        int num = merge && this.theScans.size() > 0 ? this.theScans.lastElement().getNum() + 1 : 0;
        Vector s_nodes = XMLUtils.findAllChildren((Node)sd_node, (String)"ScanData");
        for (Node s_node : s_nodes) {
            ScanData s = ScanData.fromXML(s_node);
            this.theScans.add(s);
            if (!merge) continue;
            s.setNum(num++);
        }
        Vector p_nodes = XMLUtils.findAllChildren((Node)sd_node, (String)"PeakData");
        for (Node p_node : p_nodes) {
            this.thePeaks.add(PeakData.fromXML(p_node, this.getMMFCreator()));
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element sd_node = document.createElement("SpectraDocument");
        if (sd_node == null) {
            return null;
        }
        for (ScanData s : this.theScans) {
            sd_node.appendChild(s.toXML(document));
        }
        for (PeakData p : this.thePeaks) {
            sd_node.appendChild(p.toXML(document));
        }
        return sd_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "SpectraDocument", new AttributesImpl());
        for (ScanData s : this.theScans) {
            s.write(th);
        }
        for (PeakData p : this.thePeaks) {
            p.write(th);
        }
        th.endElement("", "", "SpectraDocument");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private SpectraDocument theDocument;
        private boolean merge;

        public SAXHandler(SpectraDocument _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "SpectraDocument";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(ScanData.SAXHandler.getNodeElementName())) {
                return new ScanData.SAXHandler();
            }
            if (qName.equals(PeakData.SAXHandler.getNodeElementName())) {
                return new PeakData.SAXHandler(this.theDocument.getMMFCreator());
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.resetStatus();
                this.theDocument.initData();
            } else {
                this.theDocument.setChanged(true);
            }
            int num = this.merge && this.theDocument.theScans.size() > 0 ? this.theDocument.theScans.lastElement().getNum() + 1 : 0;
            for (Object o : this.getSubObjects(ScanData.SAXHandler.getNodeElementName())) {
                this.theDocument.theScans.add((ScanData)o);
                if (!this.merge) continue;
                ((ScanData)o).setNum(num++);
            }
            for (Object o : this.getSubObjects(PeakData.SAXHandler.getNodeElementName())) {
                this.theDocument.thePeaks.add((PeakData)o);
            }
            this.object = this.theDocument;
            return this.object;
        }
    }
}

