/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycoMindsParser;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Pair;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.MassUnit;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationMultiple;
import org.jfree.data.Range;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class AnnotatedPeakList
extends BaseDocument
implements SAXUtils.SAXWriter {
    private double max_intensity = 0.0;
    private Vector<Glycan> structures;
    private Vector<PeakAnnotationCollection> peak_annotations_single;
    private Vector<PeakAnnotationMultiple> peak_annotations_multiple;
    private Vector<String> msa_header;
    private Vector<AnnotationChangeListener> ac_listeners = new Vector();

    public AnnotatedPeakList() {
        super(false);
    }

    public String getName() {
        return "Annotated PeakList";
    }

    public ImageIcon getIcon() {
        return FileUtils.defaultThemeManager.getImageIcon("annpeaksdoc");
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter("msa", "Cartoonist annotated peaklist file"));
        filters.add((FileFilter)new ExtensionFileFilter("gwa", "GlycoWorkbench annotated peaklist file"));
        filters.add((FileFilter)new ExtensionFileFilter("xls", "GlycoWorkbench annotated peaklist excel file"));
        filters.add((FileFilter)new ExtensionFileFilter(new String[]{"gwa", "msa", "xls"}, "All annotated peaklist files"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter(new String[]{"gwa", "msa", "xls"}, "Annotated peaklist files");
    }

    public void initData() {
        this.max_intensity = 0.0;
        this.structures = new Vector();
        this.peak_annotations_single = new Vector();
        this.peak_annotations_multiple = new Vector();
        this.msa_header = new Vector();
    }

    private void addStructure(Glycan structure) {
        this.structures.add(structure);
        this.peak_annotations_single.add(new PeakAnnotationCollection());
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            pam.addStructure();
        }
    }

    private void insertStructureAt(Glycan structure, int s_ind) {
        this.structures.insertElementAt(structure, s_ind);
        this.peak_annotations_single.insertElementAt(new PeakAnnotationCollection(), s_ind);
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            pam.insertStructureAt(s_ind);
        }
    }

    private void removeStructureAt(int s_ind) {
        this.structures.removeElementAt(s_ind);
        this.peak_annotations_single.removeElementAt(s_ind);
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            pam.removeStructureAt(s_ind);
        }
        if (this.peak_annotations_single.size() == 0) {
            this.peak_annotations_multiple.clear();
        }
    }

    public int indexOf(Glycan structure) {
        if (structure == null) {
            return -1;
        }
        int ind = 0;
        for (Glycan s : this.structures) {
            if (s.compareTo((Object)structure) == 0) {
                return ind;
            }
            ++ind;
        }
        return -1;
    }

    public int indexOf(Peak p) {
        if (p == null) {
            return -1;
        }
        for (int i = 0; i < this.peak_annotations_multiple.size(); ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (pam.getPeak().compareTo(p) > 0) {
                return -1;
            }
            if (!pam.getPeak().mzEquals(p)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Peak p, double accuracy, MassUnit unit) {
        if (p == null) {
            return -1;
        }
        for (int i = 0; i < this.peak_annotations_multiple.size(); ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (!pam.getPeak().mzEquals(p, unit, accuracy)) continue;
            return i;
        }
        return -1;
    }

    public List<Integer> indexOfList(Peak p, double accuracy, MassUnit unit) {
        if (p == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.peak_annotations_multiple.size(); ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (!pam.getPeak().mzEquals(p, unit, accuracy)) continue;
            list.add(i);
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public int indexOf(double mz_ratio) {
        double mz_tol = 1.0E-6;
        for (int i = 0; i < this.peak_annotations_multiple.size(); ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (pam.getPeak().getMZ() > mz_ratio + mz_tol) {
                return -1;
            }
            if (!(pam.getPeak().getMZ() > mz_ratio - mz_tol)) continue;
            return i;
        }
        return -1;
    }

    private void addPeakAnnotationsPVT(int ind, PeakAnnotationCollection pac) {
        this.peak_annotations_single.elementAt(ind).addPeakAnnotations(pac);
        for (PeakAnnotation pa : pac.getPeakAnnotations()) {
            PeakAnnotationMultiple pam = this.getAnnotations(pa.getPeak(), true);
            pam.addAnnotation(ind, pa.getAnnotation());
        }
    }

    private void addPeakAnnotationsPVT(Glycan structure, PeakAnnotationCollection pac, boolean merge) {
        int ind = -1;
        if (!merge || (ind = this.indexOf(structure)) == -1) {
            this.addStructure(structure);
            ind = this.structures.size() - 1;
        }
        this.addPeakAnnotationsPVT(ind, pac);
    }

    private void addPeakAnnotationPVT(int ind, PeakAnnotation pa) {
        this.peak_annotations_single.elementAt(ind).addPeakAnnotation(pa);
        PeakAnnotationMultiple pam = this.getAnnotations(pa.getPeak(), true);
        pam.addAnnotation(ind, pa.getAnnotation());
    }

    private void addPeakAnnotationPVT(Glycan structure, PeakAnnotation pa, boolean merge) {
        int ind = -1;
        if (!merge || (ind = this.indexOf(structure)) == -1) {
            this.addStructure(structure);
            ind = this.structures.size() - 1;
        }
        this.addPeakAnnotationPVT(ind, pa);
    }

    public boolean addPeakAnnotations(Glycan structure, PeakAnnotationCollection pac, boolean merge) {
        if (structure == null || pac == null) {
            return false;
        }
        this.addPeakAnnotationsPVT(structure, pac, merge);
        this.updateIntensities();
        this.fireStructuresChanged();
        this.fireDocumentChanged();
        return true;
    }

    public boolean addPeakAnnotation(Glycan structure, PeakAnnotation pa, boolean merge) {
        if (structure == null || pa == null) {
            return false;
        }
        this.addPeakAnnotationPVT(structure, pa, merge);
        this.updateIntensities();
        this.fireStructuresChanged();
        this.fireDocumentChanged();
        return true;
    }

    public boolean insertPeakAnnotationsAt(Glycan structure, PeakAnnotationCollection pac, int s_ind) {
        if (structure == null || pac == null) {
            return false;
        }
        this.insertStructureAt(structure, s_ind);
        this.peak_annotations_single.setElementAt(pac, s_ind);
        for (PeakAnnotation pa : pac.getPeakAnnotations()) {
            PeakAnnotationMultiple pam = this.getAnnotations(pa.getPeak(), true);
            pam.addAnnotation(s_ind, pa.getAnnotation());
        }
        this.updateIntensities();
        this.fireStructuresChanged();
        this.fireDocumentChanged();
        return true;
    }

    public boolean removePeak(Peak p) {
        if (p == null) {
            return false;
        }
        if (!this.removeAnnotations(p)) {
            return false;
        }
        for (PeakAnnotationCollection pac : this.peak_annotations_single) {
            pac.removeAllPeakAnnotations(p);
        }
        this.updateIntensities();
        this.fireDocumentChanged();
        this.fireAnnotationsChanged();
        return true;
    }

    private int removePeakAnnotation(int s_ind, PeakAnnotation pa, boolean fire) {
        if (pa == null || pa.getAnnotation() == null) {
            return -1;
        }
        PeakAnnotationMultiple pam = this.getAnnotations(pa.getPeak(), false);
        if (pam == null) {
            return -1;
        }
        int ret = this.peak_annotations_single.elementAt(s_ind).removePeakAnnotation(pa, true);
        if (ret == -1) {
            return -1;
        }
        pam.removeAnnotation(s_ind, pa.getAnnotation());
        this.updateIntensities();
        if (fire) {
            this.fireDocumentChanged();
            this.fireAnnotationsChanged();
        }
        return ret;
    }

    public int removePeakAnnotation(int s_ind, PeakAnnotation pa) {
        return this.removePeakAnnotation(s_ind, pa, true);
    }

    public boolean removePeakAnnotations(int s_ind, Collection<PeakAnnotation> toremove) {
        if (toremove == null) {
            return false;
        }
        boolean removed = false;
        for (PeakAnnotation pa : toremove) {
            removed |= this.removePeakAnnotation(s_ind, pa, false) != -1;
        }
        this.updateIntensities();
        if (removed) {
            this.fireDocumentChanged();
            this.fireAnnotationsChanged();
        }
        return removed;
    }

    public void removePeakAnnotationsAt(int s_ind) {
        this.removeStructureAt(s_ind);
        this.updateIntensities();
        this.fireStructuresChanged();
        this.fireDocumentChanged();
    }

    public void removePeakAnnotationsAt(int[] s_inds) {
        Arrays.sort(s_inds);
        for (int i = 0; i < s_inds.length; ++i) {
            this.removeStructureAt(s_inds[i] - i);
        }
        this.updateIntensities();
        this.fireStructuresChanged();
        this.fireDocumentChanged();
    }

    public void clearAnnotationsFor(Peak p) {
        for (PeakAnnotationCollection pac : this.peak_annotations_single) {
            pac.clearAnnotations(p);
        }
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            if (!p.equals(pam.getPeak())) continue;
            pam.clearAnnotations();
        }
        this.updateIntensities();
        this.fireDocumentChanged();
        this.fireAnnotationsChanged();
    }

    public void clearAnnotationsFor(Collection<Peak> peaks) {
        for (PeakAnnotationCollection pac : this.peak_annotations_single) {
            pac.clearAnnotations(peaks);
        }
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            if (!peaks.contains(pam.getPeak())) continue;
            pam.clearAnnotations();
        }
        this.updateIntensities();
        this.fireDocumentChanged();
        this.fireAnnotationsChanged();
    }

    private boolean removeAnnotations(Peak p) {
        int ind = this.indexOf(p);
        if (ind == -1) {
            return false;
        }
        this.peak_annotations_multiple.removeElementAt(ind);
        return true;
    }

    public boolean updateAnnotations(int s_ind, double start_mz, double end_mz, Collection<PeakAnnotation> toupdate, boolean merge) {
        boolean changed;
        if (toupdate == null) {
            return false;
        }
        PeakAnnotationCollection pac = this.peak_annotations_single.get(s_ind);
        boolean removed = false;
        if (!merge) {
            Vector<PeakAnnotation> peak_annotations = new Vector<PeakAnnotation>(pac.getPeakAnnotations());
            for (PeakAnnotation pa : peak_annotations) {
                if (start_mz != end_mz && (!(pa.getPeak().getMZ() >= start_mz) || !(pa.getPeak().getMZ() <= end_mz)) || toupdate.contains(pa)) continue;
                removed = true;
                this.removePeakAnnotation(s_ind, pa, false);
            }
        }
        boolean added = false;
        for (PeakAnnotation pa : toupdate) {
            if (pac.contains(pa)) continue;
            added = true;
            this.addPeakAnnotationPVT(s_ind, pa);
        }
        this.updateAllIntensities();
        boolean bl = changed = removed || added;
        if (changed) {
            this.fireDocumentChanged();
        }
        return changed;
    }

    private PeakAnnotationMultiple getAnnotations(Peak p, boolean assertive) {
        for (int i = 0; i < this.peak_annotations_multiple.size(); ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (pam.getPeak().compareTo(p) > 0) {
                if (assertive) {
                    PeakAnnotationMultiple toadd = new PeakAnnotationMultiple(p, this.structures.size());
                    this.peak_annotations_multiple.insertElementAt(toadd, i);
                    return toadd;
                }
                return null;
            }
            if (!pam.getPeak().equals(p)) continue;
            return pam;
        }
        if (assertive) {
            PeakAnnotationMultiple toadd = new PeakAnnotationMultiple(p, this.structures.size());
            this.peak_annotations_multiple.add(toadd);
            return toadd;
        }
        return null;
    }

    public AnnotatedPeakList getFirst(int max_num) {
        Vector<Pair> coverages = new Vector<Pair>();
        for (int i = 0; i < this.structures.size(); ++i) {
            double cov = this.getCoverage(i);
            int ind = coverages.size();
            for (int l = 0; l < coverages.size(); ++l) {
                if (!(cov > (Double)((Pair)coverages.elementAt(l)).getFirst())) continue;
                ind = l;
                break;
            }
            coverages.insertElementAt(new Pair((Object)cov, (Object)i), ind);
        }
        AnnotatedPeakList ret = new AnnotatedPeakList();
        for (int i = 0; i < max_num && i < coverages.size(); ++i) {
            int ind = (Integer)((Pair)coverages.elementAt(i)).getSecond();
            ret.addPeakAnnotationsPVT(this.structures.elementAt(ind), this.peak_annotations_single.elementAt(ind), false);
        }
        ret.updateIntensities();
        return ret;
    }

    public AnnotatedPeakList extractCollections(int[] s_indexes) {
        AnnotatedPeakList ret = new AnnotatedPeakList();
        for (int i = 0; i < s_indexes.length; ++i) {
            Glycan structure = this.structures.elementAt(s_indexes[i]);
            PeakAnnotationCollection pac = this.peak_annotations_single.elementAt(s_indexes[i]);
            ret.addPeakAnnotationsPVT(structure, pac, false);
        }
        ret.updateIntensities();
        return ret;
    }

    public AnnotatedPeakList extractAnnotations(int s_ind, int[] pac_indexes) {
        AnnotatedPeakList ret = new AnnotatedPeakList();
        Glycan structure = this.structures.elementAt(s_ind);
        PeakAnnotationCollection pac = this.peak_annotations_single.elementAt(s_ind);
        ret.addStructure(structure);
        for (int l = 0; l < pac_indexes.length; ++l) {
            ret.addPeakAnnotationPVT(0, pac.getPeakAnnotation(pac_indexes[l]));
        }
        ret.updateIntensities();
        return ret;
    }

    public AnnotatedPeakList extractAnnotations(int[] pam_indexes) {
        AnnotatedPeakList ret = new AnnotatedPeakList();
        for (int i = 0; i < this.structures.size(); ++i) {
            Glycan structure = this.structures.elementAt(i);
            PeakAnnotationCollection pac = this.peak_annotations_single.elementAt(i);
            ret.addStructure(structure);
            for (int l = 0; l < pam_indexes.length; ++l) {
                PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(pam_indexes[l]);
                for (PeakAnnotation pa : pac.getPeakAnnotations(pam.getPeak())) {
                    ret.addPeakAnnotationPVT(i, pa);
                }
            }
        }
        ret.updateIntensities();
        return ret;
    }

    public void copy(AnnotatedPeakList src) {
        this.copy(src, true);
    }

    public void copy(AnnotatedPeakList src, boolean fire) {
        this.setData(src, fire);
    }

    private void setData(AnnotatedPeakList src, boolean fire) {
        if (src != null) {
            this.initData();
            for (int i = 0; i < src.structures.size(); ++i) {
                this.addPeakAnnotationsPVT(src.structures.elementAt(i), src.peak_annotations_single.elementAt(i), false);
            }
            this.updateIntensities();
            if (fire) {
                this.fireStructuresChanged();
                this.fireDocumentChanged();
            }
        }
    }

    public void merge(AnnotatedPeakList src) {
        this.mergeData(src, true);
    }

    private void mergeData(AnnotatedPeakList src, boolean fire) {
        if (src != null) {
            for (int i = 0; i < src.structures.size(); ++i) {
                this.addPeakAnnotationsPVT(src.structures.elementAt(i), src.peak_annotations_single.elementAt(i), true);
            }
            this.updateIntensities();
            if (fire) {
                this.fireStructuresChanged();
                this.fireDocumentChanged();
            }
        }
    }

    private void updateIntensities() {
        this.max_intensity = 0.0;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            this.max_intensity = Math.max(this.max_intensity, pam.getPeak().getIntensity());
        }
    }

    private void updateAllIntensities() {
        this.updateIntensities();
        for (PeakAnnotationCollection pac : this.peak_annotations_single) {
            pac.updateIntensities();
        }
    }

    public Vector<Peak> getPeaks() {
        Vector<Peak> ret = new Vector<Peak>();
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            ret.add(pam.getPeak());
        }
        return ret;
    }

    public double[][] getPeakData() {
        int no_peaks = this.peak_annotations_multiple.size();
        double[][] ret = new double[][]{new double[no_peaks], new double[no_peaks]};
        for (int i = 0; i < no_peaks; ++i) {
            Peak p = this.peak_annotations_multiple.elementAt(i).getPeak();
            ret[0][i] = p.getMZ();
            ret[1][i] = p.getIntensity();
        }
        return ret;
    }

    public int size() {
        return this.getNoPeaks();
    }

    public int getNoStructures() {
        return this.structures.size();
    }

    public Glycan getStructure(int s_ind) {
        return this.structures.elementAt(s_ind);
    }

    public Vector<Glycan> getStructures() {
        return this.structures;
    }

    public int getNoPeaks() {
        return this.peak_annotations_multiple.size();
    }

    public Peak getPeak(int p_ind) {
        return this.peak_annotations_multiple.elementAt(p_ind).getPeak();
    }

    public double getMZ(int p_ind) {
        return this.getPeak(p_ind).getMZ();
    }

    public double getIntensity(int p_ind) {
        return this.getPeak(p_ind).getIntensity();
    }

    public double getRelativeIntensity(int p_ind) {
        if (this.max_intensity == 0.0) {
            return this.getPeak(p_ind).getIntensity();
        }
        return 100.0 * this.getPeak(p_ind).getIntensity() / this.max_intensity;
    }

    public int nearestTo(double mz) {
        if (this.structures.size() == 0) {
            return -1;
        }
        int ind = 0;
        double last_err = Double.POSITIVE_INFINITY;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            double err = Math.abs(mz - pam.getPeak().getMZ());
            if (err > last_err) {
                return ind - 1;
            }
            last_err = err;
            ++ind;
        }
        return ind - 1;
    }

    public boolean isAnnotated(Peak p) {
        return this.peak_annotations_multiple.elementAt(this.indexOf(p)).isAnnotated();
    }

    public boolean isAnnotated(int p_ind) {
        return this.peak_annotations_multiple.elementAt(p_ind).isAnnotated();
    }

    public Collection<PeakAnnotationMultiple> getAnnotations() {
        return this.peak_annotations_multiple;
    }

    public PeakAnnotationMultiple getAnnotations(Peak p) {
        return this.getAnnotations(p, 2.0, MassUnit.Da);
    }

    public PeakAnnotationMultiple getAnnotations(Peak p, double mz_accuracy, MassUnit unit) {
        int comparison = this.indexOf(p, mz_accuracy, unit);
        if (comparison != -1) {
            return this.peak_annotations_multiple.elementAt(comparison);
        }
        return null;
    }

    public List<PeakAnnotationMultiple> getAnnotationList(Peak p, double mz_accuracy, MassUnit unit) {
        List<Integer> indexList = this.indexOfList(p, mz_accuracy, unit);
        ArrayList<PeakAnnotationMultiple> list = new ArrayList<PeakAnnotationMultiple>();
        if (indexList != null) {
            for (Integer index : indexList) {
                list.add(this.peak_annotations_multiple.elementAt(index));
            }
            return list;
        }
        return null;
    }

    public PeakAnnotationMultiple getAnnotations(int p_ind) {
        return this.peak_annotations_multiple.elementAt(p_ind);
    }

    public Vector<Annotation> getAnnotations(Peak p, int s_ind) {
        return this.peak_annotations_multiple.elementAt(this.indexOf(p)).getAnnotations(s_ind);
    }

    public Vector<Annotation> getAnnotations(int p_ind, int s_ind) {
        return this.peak_annotations_multiple.elementAt(p_ind).getAnnotations(s_ind);
    }

    public Vector<Glycan> getFragments(int p_ind, int s_ind) {
        Vector<Glycan> ret = new Vector<Glycan>();
        for (Annotation a : this.peak_annotations_multiple.elementAt(p_ind).getAnnotations(s_ind)) {
            ret.add(a.getFragmentEntry().fragment);
        }
        return ret;
    }

    public Collection<PeakAnnotationCollection> getPeakAnnotationCollections() {
        return this.peak_annotations_single;
    }

    public PeakAnnotationCollection getPeakAnnotationCollection(int s_ind) {
        return this.peak_annotations_single.elementAt(s_ind);
    }

    public PeakAnnotationCollection getPeakAnnotationCollection(Glycan structure) {
        int s_ind = this.structures.indexOf(structure);
        if (s_ind == -1) {
            return null;
        }
        return this.peak_annotations_single.elementAt(s_ind);
    }

    public double getCoverage(int s_ind) {
        double assigned = 0.0;
        double total = 0.0;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            Peak p = pam.getPeak();
            if (pam.isAnnotated(s_ind)) {
                assigned += p.getIntensity();
            }
            total += p.getIntensity();
        }
        return 100.0 * assigned / total;
    }

    public double getRMSD(int s_ind) {
        int count = 0;
        double rmsd = 0.0;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            if (!pam.isAnnotated(s_ind)) continue;
            rmsd += Math.pow(pam.getBestAccuracy(s_ind), 2.0);
            ++count;
        }
        return count > 0 ? Math.sqrt(rmsd / (double)count) : 0.0;
    }

    public double getRMSD_PPM(int s_ind) {
        int count = 0;
        double rmsd = 0.0;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            if (!pam.isAnnotated(s_ind)) continue;
            rmsd += Math.pow(pam.getBestAccuracyPPM(s_ind), 2.0);
            ++count;
        }
        return count > 0 ? Math.sqrt(rmsd / (double)count) : 0.0;
    }

    public int getNoPeaks(double min_rel_int) {
        int count = 0;
        double min_int = min_rel_int / 100.0 * this.max_intensity;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            Peak p = pam.getPeak();
            if (!(p.getIntensity() >= min_int)) continue;
            ++count;
        }
        return count;
    }

    public int getNoAnnotatedPeaks(int s_ind) {
        return this.getNoAnnotatedPeaks(s_ind, 0.0);
    }

    public int getNoAnnotatedPeaks(int s_ind, double min_rel_int) {
        int count = 0;
        double min_int = min_rel_int / 100.0 * this.max_intensity;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            Peak p = pam.getPeak();
            if (!(p.getIntensity() >= min_int) || !pam.isAnnotated(s_ind)) continue;
            ++count;
        }
        return count;
    }

    public Range getMZRange() {
        return new Range(this.getMinMZ(), this.getMaxMZ());
    }

    public double getMinMZ() {
        return this.peak_annotations_multiple.firstElement().getPeak().getMZ();
    }

    public double getMaxMZ() {
        return this.peak_annotations_multiple.lastElement().getPeak().getMZ();
    }

    public Range getAccuracyRange(int s_ind) {
        return new Range(this.getMinAccuracy(s_ind), this.getMaxAccuracy(s_ind));
    }

    public double getMinAccuracy(int s_ind) {
        return this.peak_annotations_single.elementAt(s_ind).getMinAccuracy();
    }

    public double getMaxAccuracy(int s_ind) {
        return this.peak_annotations_single.elementAt(s_ind).getMaxAccuracy();
    }

    public Range getAccuracyRangePPM(int s_ind) {
        return new Range(this.getMinAccuracyPPM(s_ind), this.getMaxAccuracyPPM(s_ind));
    }

    public double getMinAccuracyPPM(int s_ind) {
        return this.peak_annotations_single.elementAt(s_ind).getMinAccuracyPPM();
    }

    public double getMaxAccuracyPPM(int s_ind) {
        return this.peak_annotations_single.elementAt(s_ind).getMaxAccuracyPPM();
    }

    public double[][] getCalibrationData(int s_ind) {
        PeakAnnotationCollection pac = this.peak_annotations_single.elementAt(s_ind);
        int n = pac.size();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (!pac.isAnnotated(i)) continue;
            ++count;
        }
        double[][] ret = new double[][]{new double[count], new double[count]};
        int l = 0;
        for (int i = 0; i < n; ++i) {
            PeakAnnotation pa = pac.elementAt(i);
            if (!pa.isAnnotated()) continue;
            ret[0][l] = pa.getPeak().getMZ();
            ret[1][l] = pa.getAccuracy();
            ++l;
        }
        return ret;
    }

    public double[][] getBestCalibrationData(int s_ind) {
        int count = 0;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            if (!pam.isAnnotated(s_ind)) continue;
            ++count;
        }
        int n = this.peak_annotations_multiple.size();
        double[][] ret = new double[][]{new double[count], new double[count]};
        int l = 0;
        for (int i = 0; i < n; ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (!pam.isAnnotated(s_ind)) continue;
            ret[0][l] = pam.getPeak().getMZ();
            ret[1][l] = pam.getBestAccuracy(s_ind);
            ++l;
        }
        return ret;
    }

    public double[][] getCalibrationDataPPM(int s_ind) {
        PeakAnnotationCollection pac = this.peak_annotations_single.elementAt(s_ind);
        int n = this.size();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (!pac.isAnnotated(i)) continue;
            ++count;
        }
        double[][] ret = new double[][]{new double[count], new double[count]};
        int l = 0;
        for (int i = 0; i < n; ++i) {
            PeakAnnotation pa = pac.elementAt(i);
            if (!pa.isAnnotated()) continue;
            ret[0][l] = pa.getPeak().getMZ();
            ret[1][l] = pa.getAccuracyPPM();
            ++l;
        }
        return ret;
    }

    public double[][] getBestCalibrationDataPPM(int s_ind) {
        int count = 0;
        for (PeakAnnotationMultiple pam : this.peak_annotations_multiple) {
            if (!pam.isAnnotated(s_ind)) continue;
            ++count;
        }
        int n = this.peak_annotations_multiple.size();
        double[][] ret = new double[][]{new double[count], new double[count]};
        int l = 0;
        for (int i = 0; i < n; ++i) {
            PeakAnnotationMultiple pam = this.peak_annotations_multiple.elementAt(i);
            if (!pam.isAnnotated(s_ind)) continue;
            ret[0][l] = pam.getPeak().getMZ();
            ret[1][l] = pam.getBestAccuracyPPM(s_ind);
            ++l;
        }
        return ret;
    }

    private boolean updatePeakPVT(Peak p) {
        int ind = this.indexOf(p.getMZ());
        if (ind == -1) {
            return false;
        }
        PeakAnnotationMultiple pam = this.peak_annotations_multiple.get(ind);
        pam.getPeak().setIntensity(p.getIntensity());
        for (PeakAnnotationCollection pac : this.peak_annotations_single) {
            for (PeakAnnotation pa : pac.getPeakAnnotations(p.getMZ())) {
                pa.getPeak().setIntensity(p.getIntensity());
            }
        }
        return true;
    }

    public boolean updatePeak(Peak p) {
        if (this.updatePeakPVT(p)) {
            this.updateAllIntensities();
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean updatePeaks(Collection<Peak> peaks) {
        boolean changed = false;
        for (Peak p : peaks) {
            changed |= this.updatePeakPVT(p);
        }
        if (changed) {
            this.updateAllIntensities();
            this.fireDocumentChanged();
        }
        return changed;
    }

    public void addAnnotationChangeListener(AnnotationChangeListener l) {
        if (l != null) {
            this.ac_listeners.add(l);
        }
    }

    public void removeAnnotationChangeListener(AnnotationChangeListener l) {
        if (l != null) {
            this.ac_listeners.remove(l);
        }
    }

    public void fireStructuresChanged() {
        if (this.ac_listeners != null) {
            for (AnnotationChangeListener acl : this.ac_listeners) {
                acl.structuresChanged(new AnnotationChangeEvent(this));
            }
        }
    }

    public void fireAnnotationsChanged() {
        if (this.ac_listeners != null) {
            for (AnnotationChangeListener acl : this.ac_listeners) {
                acl.annotationsChanged(new AnnotationChangeEvent(this));
            }
        }
    }

    public void fireDocumentInit() {
        super.fireDocumentInit();
        this.fireStructuresChanged();
    }

    public void fireDocumentInit(BaseDocument source) {
        super.fireDocumentInit(source);
        if (source == this) {
            this.fireStructuresChanged();
        }
    }

    public void fromString(String str, boolean merge) throws Exception {
        this.fromString(str, merge, false);
    }

    public void fromString(String str, boolean merge, boolean fire) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        this.read(bis, merge);
        if (fire) {
            this.fireStructuresChanged();
            this.fireDocumentChanged();
        }
    }

    protected void read(InputStream is, boolean merge) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        if (bis.markSupported()) {
            bis.mark(100);
            byte[] buf = new byte[18];
            if (bis.read(buf, 0, 18) == 18) {
                bis.reset();
                String str_buf = new String(buf);
                if (str_buf.startsWith("# .msa version 002")) {
                    this.readMSA2(bis, merge);
                    return;
                }
                if (str_buf.startsWith("# .msa version 003")) {
                    this.readMSA3(bis, merge);
                    return;
                }
            } else {
                bis.reset();
            }
        }
        SAXUtils.read((InputStream)bis, (DefaultHandler)((Object)new SAXHandler(this, merge)));
    }

    public String toString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.write(bos);
            return bos.toString();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return "";
        }
    }

    public void write(OutputStream os) throws Exception {
        SAXUtils.write((OutputStream)os, (SAXUtils.SAXWriter)this);
    }

    public void fromXML(Node apl_node, boolean merge) throws Exception {
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        Vector ann_nodes = XMLUtils.findAllChildren((Node)apl_node, (String)"Annotations");
        for (Node ann_node : ann_nodes) {
            Node s_node = XMLUtils.assertChild((Node)ann_node, (String)"Glycan");
            Glycan structure = Glycan.fromXML((Node)s_node, (MassOptions)new MassOptions());
            Node pac_node = XMLUtils.assertChild((Node)ann_node, (String)"PeakAnnotationCollection");
            PeakAnnotationCollection pac = PeakAnnotationCollection.fromXML(pac_node);
            this.addPeakAnnotationsPVT(structure, pac, true);
        }
        this.updateIntensities();
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element apl_node = document.createElement("AnnotatedPeakList");
        if (apl_node == null) {
            return null;
        }
        for (int i = 0; i < this.structures.size(); ++i) {
            Element ann_node;
            Element pac_node;
            Element s_node = this.structures.elementAt(i).toXML(document);
            if (s_node == null || (pac_node = this.peak_annotations_single.elementAt(i).toXML(document)) == null || (ann_node = document.createElement("Annotations")) == null) continue;
            ann_node.appendChild(s_node);
            ann_node.appendChild(pac_node);
            apl_node.appendChild(ann_node);
        }
        return apl_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "AnnotatedPeakList", new AttributesImpl());
        for (int i = 0; i < this.structures.size(); ++i) {
            th.startElement("", "", "Annotations", new AttributesImpl());
            this.structures.elementAt(i).write(th);
            this.peak_annotations_single.elementAt(i).write(th);
            th.endElement("", "", "Annotations");
        }
        th.endElement("", "", "AnnotatedPeakList");
    }

    private void readMSA2(InputStream is, boolean merge) throws Exception {
        String line;
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        Glycan empty = new Glycan();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            Peak peak;
            if (line.length() == 0 || line.startsWith("#")) {
                this.msa_header.add(line);
                continue;
            }
            Vector tokens = TextUtils.tokenize((String)line, (String)" ");
            if (tokens.size() < 15) {
                throw new Exception("Invalid format for line: " + line);
            }
            double mz_value = Double.valueOf((String)tokens.get(1));
            int offset = Integer.valueOf((String)tokens.get(2));
            if (offset > 0) {
                mz_value -= (double)offset;
            }
            if ((peak = new Peak(mz_value, 1.0)) == null) {
                throw new Exception("m/z value not found in peaklist: " + mz_value);
            }
            Vector<Glycan> cartoons = new Vector<Glycan>();
            if (tokens.size() > 15) {
                MassOptions mopt = new MassOptions("perMe", "freeEnd");
                mopt.ION_CLOUD = new IonCloud("Na");
                GlycoMindsParser parser = new GlycoMindsParser();
                String str_cartoons = (String)tokens.get(15);
                str_cartoons = str_cartoons.substring(1, str_cartoons.length() - 1);
                for (String str_cartoon : TextUtils.tokenize((String)str_cartoons, (String)";")) {
                    cartoons.add(parser.readGlycan(str_cartoon, mopt));
                }
            }
            if (cartoons.size() > 0) {
                for (Glycan cartoon : cartoons) {
                    this.addPeakAnnotation(empty, new PeakAnnotation(peak, new FragmentEntry(cartoon, "")), true);
                }
                continue;
            }
            this.addPeakAnnotation(empty, new PeakAnnotation(peak), true);
        }
    }

    private void readMSA3(InputStream is, boolean merge) throws Exception {
        String line;
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        Glycan empty = new Glycan();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) {
                this.msa_header.add(line);
                continue;
            }
            Vector tokens = TextUtils.tokenize((String)line, (String)" ");
            if (tokens.size() < 17) {
                throw new Exception("Invalid format for line: " + line);
            }
            double mz_value = Double.valueOf((String)tokens.get(1));
            int offset = Integer.valueOf((String)tokens.get(2));
            if (offset > 0) {
                mz_value -= (double)offset;
            }
            double int_value = Double.valueOf((String)tokens.get(5));
            Peak peak = new Peak(mz_value, int_value);
            Vector<Glycan> cartoons = new Vector<Glycan>();
            if (tokens.size() > 17) {
                MassOptions mopt = new MassOptions("perMe", "freeEnd");
                mopt.ION_CLOUD = this.parseCharges((String)tokens.get(3));
                GlycoMindsParser parser = new GlycoMindsParser();
                String str_cartoons = (String)tokens.get(17);
                str_cartoons = str_cartoons.substring(1, str_cartoons.length() - 1);
                for (String str_cartoon : TextUtils.tokenize((String)str_cartoons, (String)";")) {
                    cartoons.add(parser.readGlycan(str_cartoon, mopt));
                }
            }
            if (cartoons.size() > 0) {
                for (Glycan cartoon : cartoons) {
                    this.addPeakAnnotation(empty, new PeakAnnotation(peak, new FragmentEntry(cartoon, "")), true);
                }
                continue;
            }
            this.addPeakAnnotation(empty, new PeakAnnotation(peak), true);
        }
    }

    private IonCloud parseCharges(String charges) throws Exception {
        IonCloud ret = new IonCloud();
        String[] tokens = charges.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String ion;
            int c;
            for (c = 0; c < tokens[i].length() && Character.isDigit(tokens[i].charAt(c)); ++c) {
            }
            int count = 1;
            if (c > 0) {
                count = Integer.valueOf(tokens[i].substring(0, c));
            }
            if ((ion = tokens[i].substring(c)).equals("H+")) {
                ret.add("H", count);
                continue;
            }
            if (ion.equals("Na+")) {
                ret.add("Na", count);
                continue;
            }
            if (ion.equals("Li+")) {
                ret.add("Li", count);
                continue;
            }
            if (ion.equals("K+")) {
                ret.add("K", count);
                continue;
            }
            throw new Exception("Unrecognized ion " + ion);
        }
        return ret;
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private AnnotatedPeakList theDocument;
        private boolean merge;

        public SAXHandler(AnnotatedPeakList _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "AnnotatedPeakList";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(AnnotationsSAXHandler.getNodeElementName())) {
                return new AnnotationsSAXHandler();
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.resetStatus();
                this.theDocument.initData();
            } else {
                this.theDocument.setChanged(true);
            }
            for (Object o : this.getSubObjects(AnnotationsSAXHandler.getNodeElementName())) {
                Pair p = (Pair)o;
                this.theDocument.addPeakAnnotationsPVT((Glycan)p.getFirst(), (PeakAnnotationCollection)p.getSecond(), true);
            }
            this.theDocument.updateIntensities();
            this.object = this.theDocument;
            return this.object;
        }
    }

    public static class AnnotationsSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(AnnotationsSAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Annotations";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(Glycan.SAXHandler.getNodeElementName())) {
                return new Glycan.SAXHandler(new MassOptions());
            }
            if (qName.equals(PeakAnnotationCollection.SAXHandler.getNodeElementName())) {
                return new PeakAnnotationCollection.SAXHandler();
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            Glycan g = (Glycan)this.getSubObject(Glycan.SAXHandler.getNodeElementName(), true);
            PeakAnnotationCollection pac = (PeakAnnotationCollection)this.getSubObject(PeakAnnotationCollection.SAXHandler.getNodeElementName(), true);
            return new Pair((Object)g, (Object)pac);
        }
    }

    public static class AnnotationChangeEvent {
        protected AnnotatedPeakList source;

        public AnnotationChangeEvent(AnnotatedPeakList _source) {
            this.source = _source;
        }

        public AnnotatedPeakList getSource() {
            return this.source;
        }
    }

    public static interface AnnotationChangeListener {
        public void structuresChanged(AnnotationChangeEvent var1);

        public void annotationsChanged(AnnotationChangeEvent var1);
    }
}

