/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.adapter;

import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.EntrySelectionAdapter;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader.MSGlycanAnnotationReportTableDataProcessorUtil;

public class MSGlycanAnnotationReportDialogAdapter
extends EntrySelectionAdapter {
    private Grid entryDialogGrid = null;
    private HashMap<String, String> listEntries = null;
    private List<Entry> entries = null;

    public MSGlycanAnnotationReportDialogAdapter(String a_propertyType, String a_dialogTitle, String a_dialogMessage) {
        super(a_propertyType, a_dialogTitle, a_dialogMessage);
    }

    public void widgetSelected(SelectionEvent event) {
        Entry entry;
        Shell newShell = new Shell(this.parent.getShell(), 0x10008000);
        ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
        dlg.addFilter(this.m_propertyType);
        dlg.setTitle(this.m_title);
        dlg.setMessage(this.m_message);
        if (dlg.open() == 0 && (entry = dlg.getEntry()) != null) {
            String displayName = MSGlycanAnnotationReportTableDataProcessorUtil.getDisplayNameByEntryName(((MSGlycanAnnotationProperty)entry.getProperty()).getMSAnnotationMetaData().getAnnotationId());
            if (displayName == null) {
                throw new NullPointerException("Unable to determine display name for entry: " + entry.getDisplayName());
            }
            if (this.listEntries.isEmpty()) {
                this.addToList(entry, displayName);
            } else if (!this.listEntries.containsKey(displayName)) {
                if (this.sameParent(entry, "org.grits.toolbox.property.project")) {
                    this.addToList(entry, displayName);
                } else {
                    ErrorUtils.createWarningMessageBox((Shell)new Shell(this.parent.getShell(), 0x10008000), (String)"Cannot Merge Across Projects", (String)"Cannot add the selected annotation\nSelected annotation is not in the same project of other annotations.");
                }
            }
        }
    }

    private boolean sameParent(Entry entry, String type) {
        Entry myParent;
        Entry curParent = DataModelSearch.findParentByType((Entry)this.entries.get(0), (String)type);
        return curParent.equals(myParent = DataModelSearch.findParentByType((Entry)entry, (String)type));
    }

    private void addToList(Entry entry, String name) {
        this.listEntries.put(name, name);
        GridItem item = new GridItem(this.entryDialogGrid, 0);
        item.setText(0, name);
        item.setText(1, name);
        this.entryDialogGrid.setSelection(this.entryDialogGrid.getItemCount() - 1);
        this.entryDialogGrid.notifyListeners(24, null);
        this.entries.add(entry);
    }

    public void setList(Grid entryDialogGrid) {
        this.entryDialogGrid = entryDialogGrid;
    }

    public void setListEntries(HashMap<String, String> listEntries) {
        this.listEntries = listEntries;
    }

    public void setEntries(List<Entry> simGLycanEntryList) {
        this.entries = simGLycanEntryList;
    }
}

