/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.EndstreamOutputStream;
import org.apache.pdfbox.persistence.util.COSObjectKey;

public abstract class BaseParser {
    private static final long OBJECT_NUMBER_THRESHOLD = 10000000000L;
    private static final long GENERATION_NUMBER_THRESHOLD = 65535L;
    public static final String PROP_PUSHBACK_SIZE = "org.apache.pdfbox.baseParser.pushBackSize";
    private static final Log LOG = LogFactory.getLog(BaseParser.class);
    private static final int E = 101;
    private static final int N = 110;
    private static final int D = 100;
    private static final int S = 115;
    private static final int T = 116;
    private static final int R = 114;
    private static final int A = 97;
    private static final int M = 109;
    private static final int O = 111;
    private static final int B = 98;
    private static final int J = 106;
    private final int strmBufLen = 2048;
    private final byte[] strmBuf = new byte[2048];
    public static final byte[] ENDSTREAM = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    public static final byte[] ENDOBJ = new byte[]{101, 110, 100, 111, 98, 106};
    public static final String DEF = "def";
    private static final String ENDOBJ_STRING = "endobj";
    private static final String ENDSTREAM_STRING = "endstream";
    private static final String STREAM_STRING = "stream";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    static boolean FORCE_PARSING = true;
    protected PushBackInputStream pdfSource;
    protected COSDocument document;
    protected final boolean forceParsing;

    public BaseParser() {
        this.forceParsing = FORCE_PARSING;
    }

    public BaseParser(InputStream input, boolean forceParsingValue) throws IOException {
        int pushbacksize = 65536;
        try {
            pushbacksize = Integer.getInteger(PROP_PUSHBACK_SIZE, 65536);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.pdfSource = new PushBackInputStream(new BufferedInputStream(input, 16384), pushbacksize);
        this.forceParsing = forceParsingValue;
    }

    public BaseParser(InputStream input) throws IOException {
        this(input, FORCE_PARSING);
    }

    protected BaseParser(byte[] input) throws IOException {
        this(new ByteArrayInputStream(input));
    }

    public void setDocument(COSDocument doc) {
        this.document = doc;
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private COSBase parseCOSDictionaryValue() throws IOException {
        COSBase retval = null;
        long numOffset = this.pdfSource.getOffset();
        COSBase number = this.parseDirObject();
        this.skipSpaces();
        char next = (char)this.pdfSource.peek();
        if (next >= '0' && next <= '9') {
            long genOffset = this.pdfSource.getOffset();
            COSBase generationNumber = this.parseDirObject();
            this.skipSpaces();
            char r = (char)this.pdfSource.read();
            if (r != 'R') {
                throw new IOException("expected='R' actual='" + r + "' at offset " + this.pdfSource.getOffset());
            }
            if (!(number instanceof COSInteger)) {
                throw new IOException("expected number, actual=" + number + " at offset " + numOffset);
            }
            if (!(generationNumber instanceof COSInteger)) {
                throw new IOException("expected number, actual=" + number + " at offset " + genOffset);
            }
            COSObjectKey key = new COSObjectKey(((COSInteger)number).intValue(), ((COSInteger)generationNumber).intValue());
            retval = this.document.getObjectFromPool(key);
        } else {
            retval = number;
        }
        return retval;
    }

    protected COSDictionary parseCOSDictionary() throws IOException {
        char c = (char)this.pdfSource.read();
        if (c != '<') {
            throw new IOException("expected='<' actual='" + c + "' at offset " + this.pdfSource.getOffset());
        }
        c = (char)this.pdfSource.read();
        if (c != '<') {
            throw new IOException("expected='<' actual='" + c + "' at offset " + this.pdfSource.getOffset());
        }
        this.skipSpaces();
        COSDictionary obj = new COSDictionary();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            c = (char)this.pdfSource.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            if (c != '/') {
                LOG.warn("Invalid dictionary, found: '" + c + "' but expected: '/'");
                int read = this.pdfSource.read();
                while (read != -1 && read != 47 && read != 62) {
                    if (read == 101 && (read = this.pdfSource.read()) == 110 && (read = this.pdfSource.read()) == 100) {
                        boolean isObj;
                        read = this.pdfSource.read();
                        boolean isStream = read == 115 && this.pdfSource.read() == 116 && this.pdfSource.read() == 114 && this.pdfSource.read() == 101 && this.pdfSource.read() == 97 && this.pdfSource.read() == 109;
                        boolean bl = isObj = !isStream && read == 111 && this.pdfSource.read() == 98 && this.pdfSource.read() == 106;
                        if (isStream || isObj) {
                            return obj;
                        }
                    }
                    read = this.pdfSource.read();
                }
                if (read != -1) {
                    this.pdfSource.unread(read);
                    continue;
                }
                return obj;
            }
            COSName key = this.parseCOSName();
            COSBase value = this.parseCOSDictionaryValue();
            this.skipSpaces();
            if ((char)this.pdfSource.peek() == 'd') {
                String potentialDEF = this.readString();
                if (!potentialDEF.equals(DEF)) {
                    this.pdfSource.unread(potentialDEF.getBytes("ISO-8859-1"));
                } else {
                    this.skipSpaces();
                }
            }
            if (value == null) {
                LOG.warn("Bad Dictionary Declaration " + this.pdfSource);
                continue;
            }
            value.setDirect(true);
            obj.setItem(key, value);
        }
        char ch = (char)this.pdfSource.read();
        if (ch != '>') {
            throw new IOException("expected='>' actual='" + ch + "' at offset " + this.pdfSource.getOffset());
        }
        ch = (char)this.pdfSource.read();
        if (ch != '>') {
            throw new IOException("expected='>' actual='" + ch + "' at offset " + this.pdfSource.getOffset());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccess file) throws IOException {
        COSStream stream = new COSStream(dic, file);
        OutputStream out = null;
        try {
            String streamString = this.readString();
            if (!streamString.equals(STREAM_STRING)) {
                throw new IOException("expected='stream' actual='" + streamString + "' at offset " + this.pdfSource.getOffset());
            }
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            COSBase streamLength = dic.getItem(COSName.LENGTH);
            out = stream.createFilteredStream(streamLength);
            int length = -1;
            if (streamLength instanceof COSNumber) {
                length = ((COSNumber)streamLength).intValue();
            }
            if (length == -1) {
                this.readUntilEndStream(new EndstreamOutputStream(out));
            } else {
                int chunk;
                int readCount;
                for (int left = length; left > 0 && (readCount = this.pdfSource.read(this.strmBuf, 0, chunk = Math.min(left, 2048))) != -1; left -= readCount) {
                    out.write(this.strmBuf, 0, readCount);
                }
                int readCount2 = this.pdfSource.read(this.strmBuf, 0, 20);
                if (readCount2 > 0) {
                    boolean foundEndstream = false;
                    int nextEndstreamCIdx = 0;
                    for (int cIdx = 0; cIdx < readCount2; ++cIdx) {
                        int ch = this.strmBuf[cIdx] & 0xFF;
                        if (ch == ENDSTREAM[nextEndstreamCIdx]) {
                            if (++nextEndstreamCIdx < ENDSTREAM.length) continue;
                            foundEndstream = true;
                            break;
                        }
                        if (nextEndstreamCIdx > 0 || !this.isWhitespace(ch)) break;
                    }
                    this.pdfSource.unread(this.strmBuf, 0, readCount2);
                    if (!foundEndstream) {
                        LOG.warn("Specified stream length " + length + " is wrong. Fall back to reading stream until 'endstream'.");
                        out.flush();
                        InputStream writtenStreamBytes = stream.getFilteredStream();
                        ByteArrayOutputStream bout = new ByteArrayOutputStream(length);
                        IOUtils.copy(writtenStreamBytes, bout);
                        IOUtils.closeQuietly(writtenStreamBytes);
                        try {
                            this.pdfSource.unread(bout.toByteArray());
                        }
                        catch (IOException ioe) {
                            throw new WrappedIOException("Could not push back " + bout.size() + " bytes in order to reparse stream. " + "Try increasing push back buffer using system property " + PROP_PUSHBACK_SIZE, ioe);
                        }
                        IOUtils.closeQuietly(out);
                        out = stream.createFilteredStream(streamLength);
                        this.readUntilEndStream(new EndstreamOutputStream(out));
                    }
                }
            }
            this.skipSpaces();
            String endStream = this.readString();
            if (!endStream.equals(ENDSTREAM_STRING)) {
                if (endStream.startsWith(ENDOBJ_STRING)) {
                    byte[] endobjarray = endStream.getBytes("ISO-8859-1");
                    this.pdfSource.unread(endobjarray);
                } else if (endStream.startsWith(ENDSTREAM_STRING)) {
                    String extra = endStream.substring(9, endStream.length());
                    byte[] array = extra.getBytes("ISO-8859-1");
                    this.pdfSource.unread(array);
                } else {
                    this.readUntilEndStream(new EndstreamOutputStream(out));
                    endStream = this.readString();
                    if (!endStream.equals(ENDSTREAM_STRING)) {
                        throw new IOException("expected='endstream' actual='" + endStream + "' at offset " + this.pdfSource.getOffset());
                    }
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return stream;
    }

    protected void readUntilEndStream(OutputStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.pdfSource.read(this.strmBuf, charMatchCount, 2048 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx;
                if (charMatchCount == 0 && (quickTestIdx = bIdx + 5) < maxQuicktestIdx && ((ch = this.strmBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.strmBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.write(this.strmBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.pdfSource.unread(this.strmBuf, contentBytes, bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.strmBuf, 0, charMatchCount);
        }
        out.flush();
    }

    private int checkForMissingCloseParen(int bracesParameter) throws IOException {
        int braces = bracesParameter;
        byte[] nextThreeBytes = new byte[3];
        int amountRead = this.pdfSource.read(nextThreeBytes);
        if (amountRead == 3 && (nextThreeBytes[0] == 13 && nextThreeBytes[1] == 10 && nextThreeBytes[2] == 47 || nextThreeBytes[0] == 13 && nextThreeBytes[1] == 47)) {
            braces = 0;
        }
        if (amountRead > 0) {
            this.pdfSource.unread(nextThreeBytes, 0, amountRead);
        }
        return braces;
    }

    @Deprecated
    protected COSString parseCOSString(boolean isDictionary) throws IOException {
        return this.parseCOSString();
    }

    protected COSString parseCOSString() throws IOException {
        char nextChar = (char)this.pdfSource.read();
        COSString retval = new COSString();
        if (nextChar != '(') {
            if (nextChar == '<') {
                return this.parseCOSHexString();
            }
            throw new IOException("parseCOSString string should start with '(' or '<' and not '" + nextChar + "' " + this.pdfSource);
        }
        char openBrace = '(';
        char closeBrace = ')';
        int braces = 1;
        int c = this.pdfSource.read();
        while (braces > 0 && c != -1) {
            char ch = (char)c;
            int nextc = -2;
            if (ch == closeBrace) {
                --braces;
                if ((braces = this.checkForMissingCloseParen(braces)) != 0) {
                    retval.append(ch);
                }
            } else if (ch == openBrace) {
                ++braces;
                retval.append(ch);
            } else if (ch == '\\') {
                char next = (char)this.pdfSource.read();
                switch (next) {
                    case 'n': {
                        retval.append(10);
                        break;
                    }
                    case 'r': {
                        retval.append(13);
                        break;
                    }
                    case 't': {
                        retval.append(9);
                        break;
                    }
                    case 'b': {
                        retval.append(8);
                        break;
                    }
                    case 'f': {
                        retval.append(12);
                        break;
                    }
                    case ')': {
                        braces = this.checkForMissingCloseParen(braces);
                        if (braces != 0) {
                            retval.append(next);
                            break;
                        }
                        retval.append(92);
                        break;
                    }
                    case '(': 
                    case '\\': {
                        retval.append(next);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        c = this.pdfSource.read();
                        while (this.isEOL(c) && c != -1) {
                            c = this.pdfSource.read();
                        }
                        nextc = c;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        StringBuffer octal = new StringBuffer();
                        octal.append(next);
                        c = this.pdfSource.read();
                        char digit = (char)c;
                        if (digit >= '0' && digit <= '7') {
                            octal.append(digit);
                            c = this.pdfSource.read();
                            digit = (char)c;
                            if (digit >= '0' && digit <= '7') {
                                octal.append(digit);
                            } else {
                                nextc = c;
                            }
                        } else {
                            nextc = c;
                        }
                        int character = 0;
                        try {
                            character = Integer.parseInt(octal.toString(), 8);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Error: Expected octal character, actual='" + octal + "'");
                        }
                        retval.append(character);
                        break;
                    }
                    default: {
                        retval.append(next);
                        break;
                    }
                }
            } else {
                retval.append(ch);
            }
            if (nextc != -2) {
                c = nextc;
                continue;
            }
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return retval;
    }

    private final COSString parseCOSHexString() throws IOException {
        StringBuilder sBuf;
        block6: {
            int c;
            sBuf = new StringBuilder();
            while (true) {
                if (BaseParser.isHexDigit((char)(c = this.pdfSource.read()))) {
                    sBuf.append((char)c);
                    continue;
                }
                if (c == 62) break block6;
                if (c < 0) {
                    throw new IOException("Missing closing bracket for hex string. Reached EOS.");
                }
                if (c != 32 && c != 10 && c != 9 && c != 13 && c != 8 && c != 12) break;
            }
            if (sBuf.length() % 2 != 0) {
                sBuf.deleteCharAt(sBuf.length() - 1);
            }
            while ((c = this.pdfSource.read()) != 62 && c >= 0) {
            }
            if (c < 0) {
                throw new IOException("Missing closing bracket for hex string. Reached EOS.");
            }
        }
        return COSString.createFromHexString(sBuf.toString(), this.forceParsing);
    }

    protected COSArray parseCOSArray() throws IOException {
        int i;
        char ch = (char)this.pdfSource.read();
        if (ch != '[') {
            throw new IOException("expected='[' actual='" + ch + "' at offset " + this.pdfSource.getOffset());
        }
        COSArray po = new COSArray();
        this.skipSpaces();
        while ((i = this.pdfSource.peek()) > 0 && (char)i != ']') {
            COSBase pbo = this.parseDirObject();
            if (pbo instanceof COSObject) {
                if (po.get(po.size() - 1) instanceof COSInteger) {
                    COSInteger genNumber = (COSInteger)po.remove(po.size() - 1);
                    if (po.get(po.size() - 1) instanceof COSInteger) {
                        COSInteger number = (COSInteger)po.remove(po.size() - 1);
                        COSObjectKey key = new COSObjectKey(number.intValue(), genNumber.intValue());
                        pbo = this.document.getObjectFromPool(key);
                    } else {
                        pbo = null;
                    }
                } else {
                    pbo = null;
                }
            }
            if (pbo != null) {
                po.add(pbo);
            } else {
                LOG.warn("Corrupt object reference");
                String isThisTheEnd = this.readString();
                this.pdfSource.unread(isThisTheEnd.getBytes("ISO-8859-1"));
                if (ENDOBJ_STRING.equals(isThisTheEnd) || ENDSTREAM_STRING.equals(isThisTheEnd)) {
                    return po;
                }
            }
            this.skipSpaces();
        }
        this.pdfSource.read();
        this.skipSpaces();
        return po;
    }

    protected boolean isEndOfName(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '>' || ch == '<' || ch == '[' || ch == '/' || ch == ']' || ch == ')' || ch == '(' || ch == '\uffffffff';
    }

    protected COSName parseCOSName() throws IOException {
        int c = this.pdfSource.read();
        if ((char)c != '/') {
            throw new IOException("expected='/' actual='" + (char)c + "'-" + c + " at offset " + this.pdfSource.getOffset());
        }
        StringBuilder buffer = new StringBuilder();
        c = this.pdfSource.read();
        while (c != -1) {
            char ch = (char)c;
            if (ch == '#') {
                char ch1 = (char)this.pdfSource.read();
                char ch2 = (char)this.pdfSource.read();
                if (BaseParser.isHexDigit(ch1) && BaseParser.isHexDigit(ch2)) {
                    String hex = "" + ch1 + ch2;
                    try {
                        buffer.append((char)Integer.parseInt(hex, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error: expected hex number, actual='" + hex + "'");
                    }
                    c = this.pdfSource.read();
                    continue;
                }
                this.pdfSource.unread(ch2);
                c = ch1;
                buffer.append(ch);
                continue;
            }
            if (this.isEndOfName(ch)) break;
            buffer.append(ch);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return COSName.getPDFName(buffer.toString());
    }

    protected COSBoolean parseBoolean() throws IOException {
        COSBoolean retval = null;
        char c = (char)this.pdfSource.peek();
        if (c == 't') {
            String trueString = new String(this.pdfSource.readFully(4), "ISO-8859-1");
            if (!trueString.equals(TRUE)) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + trueString + "' at offset " + this.pdfSource.getOffset());
            }
            retval = COSBoolean.TRUE;
        } else if (c == 'f') {
            String falseString = new String(this.pdfSource.readFully(5), "ISO-8859-1");
            if (!falseString.equals(FALSE)) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + falseString + "' at offset " + this.pdfSource.getOffset());
            }
            retval = COSBoolean.FALSE;
        } else {
            throw new IOException("Error parsing boolean expected='t or f' actual='" + c + "' at offset " + this.pdfSource.getOffset());
        }
        return retval;
    }

    protected COSBase parseDirObject() throws IOException {
        COSBase retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    retval = this.parseCOSDictionary();
                    this.skipSpaces();
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (!nullString.equals(NULL)) {
                    throw new IOException("Expected='null' actual='" + nullString + "' at offset " + this.pdfSource.getOffset());
                }
                retval = COSNull.NULL;
                break;
            }
            case 't': {
                String trueString = new String(this.pdfSource.readFully(4), "ISO-8859-1");
                if (trueString.equals(TRUE)) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                throw new IOException("expected true actual='" + trueString + "' " + this.pdfSource);
            }
            case 'f': {
                String falseString = new String(this.pdfSource.readFully(5), "ISO-8859-1");
                if (falseString.equals(FALSE)) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                throw new IOException("expected false actual='" + falseString + "' " + this.pdfSource);
            }
            case 'R': {
                this.pdfSource.read();
                retval = new COSObject(null);
                break;
            }
            case '\uffff': {
                return null;
            }
            default: {
                if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                    StringBuilder buf = new StringBuilder();
                    int ic = this.pdfSource.read();
                    c = (char)ic;
                    while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'E' || c == 'e') {
                        buf.append(c);
                        ic = this.pdfSource.read();
                        c = (char)ic;
                    }
                    if (ic != -1) {
                        this.pdfSource.unread(ic);
                    }
                    retval = COSNumber.get(buf.toString());
                    break;
                }
                String badString = this.readString();
                if (badString == null || badString.length() == 0) {
                    int peek = this.pdfSource.peek();
                    throw new IOException("Unknown dir object c='" + c + "' cInt=" + c + " peek='" + (char)peek + "' peekInt=" + peek + " " + this.pdfSource.getOffset());
                }
                if (!ENDOBJ_STRING.equals(badString) && !ENDSTREAM_STRING.equals(badString)) break;
                this.pdfSource.unread(badString.getBytes("ISO-8859-1"));
            }
        }
        return retval;
    }

    protected String readString() throws IOException {
        this.skipSpaces();
        StringBuilder buffer = new StringBuilder();
        int c = this.pdfSource.read();
        while (!this.isEndOfName((char)c) && !this.isClosing(c) && c != -1) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected String readExpectedString(String theString) throws IOException {
        int c = this.pdfSource.read();
        while (this.isWhitespace(c) && c != -1) {
            c = this.pdfSource.read();
        }
        StringBuilder buffer = new StringBuilder(theString.length());
        for (int charsRead = 0; !this.isEOL(c) && c != -1 && charsRead < theString.length(); ++charsRead) {
            char next = (char)c;
            buffer.append(next);
            if (theString.charAt(charsRead) == next) {
            } else {
                this.pdfSource.unread(buffer.toString().getBytes("ISO-8859-1"));
                throw new IOException("Error: Expected to read '" + theString + "' instead started reading '" + buffer.toString() + "'");
            }
            c = this.pdfSource.read();
        }
        while (this.isEOL(c) && c != -1) {
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected String readString(int length) throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.read();
        StringBuilder buffer = new StringBuilder(length);
        while (!this.isWhitespace(c) && !this.isClosing(c) && c != -1 && buffer.length() < length && c != 91 && c != 60 && c != 40 && c != 47) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected boolean isClosing() throws IOException {
        return this.isClosing(this.pdfSource.peek());
    }

    protected boolean isClosing(int c) {
        return c == 93;
    }

    protected String readLine() throws IOException {
        int c;
        if (this.pdfSource.isEOF()) {
            throw new IOException("Error: End-of-File, expected line");
        }
        StringBuilder buffer = new StringBuilder(11);
        while ((c = this.pdfSource.read()) != -1 && !this.isEOL(c)) {
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    protected boolean isEOL() throws IOException {
        return this.isEOL(this.pdfSource.peek());
    }

    protected boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    protected boolean isWhitespace() throws IOException {
        return this.isWhitespace(this.pdfSource.peek());
    }

    protected boolean isWhitespace(int c) {
        return c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32;
    }

    protected void skipSpaces() throws IOException {
        int c = this.pdfSource.read();
        while (c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32 || c == 37) {
            if (c == 37) {
                c = this.pdfSource.read();
                while (!this.isEOL(c) && c != -1) {
                    c = this.pdfSource.read();
                }
                continue;
            }
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
    }

    protected long readObjectNumber() throws IOException {
        long retval = this.readLong();
        if (retval < 0L || retval >= 10000000000L) {
            throw new IOException("Object Number '" + retval + "' has more than 10 digits or is negative");
        }
        return retval;
    }

    protected int readGenerationNumber() throws IOException {
        int retval = this.readInt();
        if (retval < 0 || (long)retval > 65535L) {
            throw new IOException("Generation Number '" + retval + "' has more than 5 digits");
        }
        return retval;
    }

    protected int readInt() throws IOException {
        this.skipSpaces();
        int retval = 0;
        StringBuilder intBuffer = this.readStringNumber();
        try {
            retval = Integer.parseInt(intBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.pdfSource.unread(intBuffer.toString().getBytes("ISO-8859-1"));
            throw new IOException("Error: Expected an integer type at offset " + this.pdfSource.getOffset());
        }
        return retval;
    }

    protected long readLong() throws IOException {
        this.skipSpaces();
        long retval = 0L;
        StringBuilder longBuffer = this.readStringNumber();
        try {
            retval = Long.parseLong(longBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.pdfSource.unread(longBuffer.toString().getBytes("ISO-8859-1"));
            throw new IOException("Error: Expected a long type at offset " + this.pdfSource.getOffset() + ", instead got '" + longBuffer + "'");
        }
        return retval;
    }

    protected final StringBuilder readStringNumber() throws IOException {
        int lastByte = 0;
        StringBuilder buffer = new StringBuilder();
        while ((lastByte = this.pdfSource.read()) != 32 && lastByte != 10 && lastByte != 13 && lastByte != 60 && lastByte != 91 && lastByte != 0 && lastByte != -1) {
            buffer.append((char)lastByte);
        }
        if (lastByte != -1) {
            this.pdfSource.unread(lastByte);
        }
        return buffer;
    }

    public void clearResources() {
        this.document = null;
        if (this.pdfSource != null) {
            IOUtils.closeQuietly(this.pdfSource);
            this.pdfSource = null;
        }
    }

    static {
        try {
            FORCE_PARSING = Boolean.getBoolean("org.apache.pdfbox.forceParsing");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

