/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.entry.ms.dialog.IDynamicTableProcessor;
import org.grits.toolbox.entry.ms.dialog.MassSpecPeakIntensityApplyDialog;
import org.grits.toolbox.entry.ms.extquantfiles.process.CorrectedQuantColumnInfo;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.InternalStandardQuantFileList;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFilePeaksToCorrectedIntensities;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFileToCorrectedPeaks;

public class MassSpecPeakIntensityGrid
extends Grid
implements IDynamicTableProcessor,
IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecPeakIntensityGrid.class);
    private static String[] columnHeaders = new String[]{"File Name", "Type", "m/z", "Source Intensity", "Corrected Intensity"};
    public static String TYPE_STD = "Standard";
    public static String TYPE_EXT = "External";
    public static String TYPE_PRE = "MSn Precursor";
    public static String TYPE_PEAK = "MS Peak";
    protected GridEditor editor = null;
    protected boolean bIsEditingTable = false;
    private static int CELL_EDIT_COLUMN = 4;
    public static final String PROPERTY_WIN_CLOSED = "Window Closed";
    public static final String PROPERTY_LOCAL_CHANGE = "Local changes";
    private Color bgColor = null;
    protected MassSpecPeakIntensityApplyDialog parentDialog = null;
    protected MassSpecTableDataObject msTableDataObject = null;
    protected boolean bHasStandards = false;
    protected boolean bShowStandards = false;
    protected boolean bHasExternal = false;
    protected boolean bShowExternal = false;
    protected boolean bShowInternal = false;
    protected Double dStartMz = null;
    protected Double dEndMz = null;
    private List<IPropertyChangeListener> listeners = null;
    protected HashMap<String, HashMap<String, HashMap<Double, Double[]>>> peakIntensityData = null;
    protected HashMap<String, HashMap<String, HashMap<Double, String>>> peaksChanged = null;
    protected HashMap<GRITSColumnHeader, int[]> peakColumnData = null;

    public MassSpecPeakIntensityGrid(Composite parent, MassSpecPeakIntensityApplyDialog parentDialog) {
        super(parent, 2816);
        this.parentDialog = parentDialog;
    }

    public void setMSTableDataObject(MassSpecTableDataObject simianTableDataObject) {
        this.msTableDataObject = simianTableDataObject;
    }

    public MassSpecTableDataObject getMSTableDataObject() {
        return this.msTableDataObject;
    }

    public void setShowExternal(boolean bShowExternal) {
        this.bShowExternal = bShowExternal;
    }

    public void setShowStandards(boolean bShowStandards) {
        this.bShowStandards = bShowStandards;
    }

    public void setShowInternal(boolean bShowInternal) {
        this.bShowInternal = bShowInternal;
    }

    public void setStartMz(Double dStartMz) {
        this.dStartMz = dStartMz;
    }

    public void setEndMz(Double dEndMz) {
        this.dEndMz = dEndMz;
    }

    public boolean hasStandards() {
        return this.bHasStandards;
    }

    public boolean hasExternal() {
        return this.bHasExternal;
    }

    protected boolean passesMzFilter(double dMz) {
        if (this.dStartMz != null && dMz < this.dStartMz) {
            return false;
        }
        return this.dEndMz == null || !(dMz > this.dEndMz);
    }

    public HashMap<String, HashMap<String, HashMap<Double, Double[]>>> getPeakIntensityData() {
        return this.peakIntensityData;
    }

    protected void initPeakData() {
        Set<GRITSColumnHeader> keys;
        GRITSColumnHeader header;
        this.peakIntensityData = new HashMap();
        this.peakColumnData = new HashMap();
        this.peaksChanged = new HashMap();
        if (this.getMSTableDataObject() == null) {
            return;
        }
        List headerRow = this.getMSTableDataObject().getLastHeader();
        int i = 0;
        while (i < headerRow.size()) {
            header = (GRITSColumnHeader)headerRow.get(i);
            if (header.getKeyValue().contains("_mz")) {
                int[] iColNums = new int[3];
                iColNums[0] = i;
                this.peakColumnData.put(header, iColNums);
            }
            ++i;
        }
        i = 0;
        while (i < headerRow.size()) {
            header = (GRITSColumnHeader)headerRow.get(i);
            keys = this.peakColumnData.keySet();
            for (GRITSColumnHeader keyHeader : keys) {
                String sIntHeader = keyHeader.getKeyValue().replace("mz", "intensity");
                int[] iColNums = this.peakColumnData.get(keyHeader);
                if (header.getKeyValue().equals(sIntHeader)) {
                    iColNums[1] = i;
                } else if (header.getKeyValue().startsWith(sIntHeader) && header.getKeyValue().endsWith(CorrectedQuantColumnInfo.CORRECTED_QUANT_KEY_PREFIX)) {
                    iColNums[2] = i;
                }
                if (keyHeader.getKeyValue().equals(DMPeak.peak_mz.name()) || keyHeader.getKeyValue().equals(DMPrecursorPeak.precursor_peak_mz.name()) || !keyHeader.getKeyValue().contains("_mz")) continue;
                if (keyHeader.getKeyValue().contains("_internal")) {
                    this.bHasStandards = true;
                    continue;
                }
                this.bHasExternal = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.getMSTableDataObject().getTableData().size()) {
            GRITSListDataRow row = (GRITSListDataRow)this.getMSTableDataObject().getTableData().get(i);
            keys = this.peakColumnData.keySet();
            for (GRITSColumnHeader keyHeader : keys) {
                Double dMz;
                String sFileName = this.getFileFromColumnHeader(keyHeader);
                if (sFileName == null) continue;
                Double dIntStdMz = null;
                String sType = null;
                if (keyHeader.getKeyValue().equals(DMPeak.peak_mz.name())) {
                    if (this.bShowInternal) {
                        sType = TYPE_PEAK;
                    }
                } else if (keyHeader.getKeyValue().equals(DMPrecursorPeak.precursor_peak_mz.name())) {
                    if (this.bShowInternal) {
                        sType = TYPE_PRE;
                    }
                } else if (keyHeader.getKeyValue().contains("_mz")) {
                    if (keyHeader.getKeyValue().contains("_internal")) {
                        if (this.bShowStandards) {
                            sType = TYPE_STD;
                            int iInx1 = keyHeader.getKeyValue().indexOf("_internal-") + 10;
                            String sPiece1 = keyHeader.getKeyValue().substring(iInx1);
                            int iInx2 = sPiece1.indexOf("_quant");
                            String sPiece2 = sPiece1.substring(0, iInx2);
                            try {
                                dIntStdMz = Double.parseDouble(sPiece2);
                            }
                            catch (NumberFormatException ex) {
                                logger.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                    } else if (this.bShowExternal) {
                        sType = TYPE_EXT;
                    }
                }
                if (sType == null) continue;
                HashMap<Object, Object> mFileToType = null;
                if (this.peakIntensityData.containsKey(sFileName)) {
                    mFileToType = this.peakIntensityData.get(sFileName);
                } else {
                    mFileToType = new HashMap();
                    this.peakIntensityData.put(sFileName, mFileToType);
                }
                HashMap dMztoInt = null;
                if (mFileToType.containsKey(sType)) {
                    dMztoInt = (HashMap)mFileToType.get(sType);
                } else {
                    dMztoInt = new HashMap();
                    mFileToType.put(sType, dMztoInt);
                }
                int[] iColNums = this.peakColumnData.get(keyHeader);
                if (iColNums == null) continue;
                Object oMz = row.getDataRow().get(iColNums[0]);
                Object oInt = row.getDataRow().get(iColNums[1]);
                if (oMz == null || oInt == null || !this.passesMzFilter(dMz = (Double)oMz)) continue;
                Double dInt = (Double)oInt;
                Double dCorInt = null;
                if (iColNums[2] > 0 && row.getDataRow().get(iColNums[2]) != null) {
                    dCorInt = (Double)row.getDataRow().get(iColNums[2]);
                }
                Double[] dVals = new Double[]{dInt, dCorInt};
                if (dIntStdMz != null) {
                    dMztoInt.put(dIntStdMz, dVals);
                    continue;
                }
                dMztoInt.put(dMz, dVals);
            }
            ++i;
        }
    }

    public boolean applyPressed() {
        boolean bChanged = false;
        try {
            MassSpecUISettings entrySettings = this.parentDialog.getSourceMassSpecEntrySettings();
            int i = 0;
            while (i < this.getItems().length) {
                GridItem gi = this.getItem(i);
                String sFileName = gi.getText(0);
                String sType = gi.getText(1);
                String sMz = gi.getText(2);
                Double dMz = null;
                String sVal = gi.getText(4);
                Double dCorrInt = null;
                try {
                    dMz = Double.parseDouble(sMz);
                    if (!sVal.equals("")) {
                        dCorrInt = Double.parseDouble(sVal);
                    }
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                QuantFileToCorrectedPeaks qfcp = null;
                if (entrySettings.getQuantFileToCorrectedPeaks() == null) {
                    entrySettings.setQuantFileToCorrectedPeaks(new HashMap<String, QuantFileToCorrectedPeaks>());
                }
                if (!entrySettings.getQuantFileToCorrectedPeaks().containsKey(sFileName)) {
                    qfcp = new QuantFileToCorrectedPeaks();
                    entrySettings.getQuantFileToCorrectedPeaks().put(sFileName, qfcp);
                } else {
                    qfcp = entrySettings.getQuantFileToCorrectedPeaks().get(sFileName);
                }
                QuantFilePeaksToCorrectedIntensities qfpci = null;
                if (!qfcp.getPeakTypeToMZs().containsKey(sType)) {
                    qfpci = new QuantFilePeaksToCorrectedIntensities();
                    qfcp.getPeakTypeToMZs().put(sType, qfpci);
                } else {
                    qfpci = qfcp.getPeakTypeToMZs().get(sType);
                }
                Double dCorrectedInt = null;
                if (qfpci.getPeakMzToIntensity().containsKey(dMz)) {
                    dCorrectedInt = qfpci.getPeakMzToIntensity().get(dMz);
                }
                HashMap<String, HashMap<Double, Double[]>> hmStoredFiles = this.peakIntensityData.get(sFileName);
                HashMap<Double, Double[]> hmMZs = hmStoredFiles.get(sType);
                Double[] dInts = hmMZs.get(dMz);
                boolean bCurChanged = false;
                if (dCorrInt != null) {
                    if (dInts[1] == null || dCorrectedInt == null || Double.compare(dCorrInt, dCorrectedInt) != 0) {
                        qfpci.getPeakMzToIntensity().put(dMz, dCorrInt);
                        bCurChanged = true;
                    }
                } else if (dCorrectedInt != null) {
                    qfpci.getPeakMzToIntensity().put(dMz, null);
                    bCurChanged = true;
                }
                bChanged |= bCurChanged;
                if (bCurChanged) {
                    dInts[1] = dCorrInt;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return bChanged;
    }

    protected String getFileFromColumnHeader(GRITSColumnHeader header) {
        try {
            Set<String> setQuantTypes;
            MassSpecUISettings entrySettings = this.parentDialog.getEntrySettingsForInternalStandardFiles();
            Entry entry = this.parentDialog.getEntryForCurrentViewer();
            String sFileName = null;
            if (entrySettings.getQuantTypeToExternalQuant() != null) {
                setQuantTypes = entrySettings.getQuantTypeToExternalQuant().keySet();
                for (String sQuantType : setQuantTypes) {
                    ExternalQuantFileToAlias eqfa = entrySettings.getExternalQuantToAliasByQuantType(sQuantType);
                    Set<String> setQuantFileNames = eqfa.getSourceDataFileNameToAlias().keySet();
                    for (String sQuantFileName : setQuantFileNames) {
                        ExternalQuantAlias eqa = eqfa.getSourceDataFileNameToAlias().get(sQuantFileName);
                        if (eqa.getKey() == null || !header.getKeyValue().startsWith(eqa.getKey())) continue;
                        sFileName = sQuantFileName;
                    }
                }
                if (sFileName != null) {
                    return sFileName;
                }
            }
            if (entrySettings.getInternalStandardQuantFiles() != null) {
                setQuantTypes = entrySettings.getInternalStandardQuantFiles().keySet();
                for (String sQuantType : setQuantTypes) {
                    InternalStandardQuantFileList isqfl = entrySettings.getInternalStandardQuantFiles().get(sQuantType);
                    Set<String> sQuantNames = isqfl.getQuantNameToFileAlias().keySet();
                    for (String sQuantName : sQuantNames) {
                        ExternalQuantFileToAlias eqfa = isqfl.getQuantNameToFileAlias().get(sQuantName);
                        Set<String> setQuantFileNames = eqfa.getSourceDataFileNameToAlias().keySet();
                        for (String sQuantFileName : setQuantFileNames) {
                            ExternalQuantAlias eqa = eqfa.getSourceDataFileNameToAlias().get(sQuantFileName);
                            if (eqa.getKey() == null) continue;
                            String sKeyPrefix = String.valueOf(sQuantName) + ":" + eqa.getKey();
                            if (!header.getKeyValue().startsWith(sKeyPrefix)) continue;
                            sFileName = sQuantFileName;
                        }
                    }
                }
                if (sFileName != null) {
                    return sFileName;
                }
            }
            if (header.getKeyValue() == DMPeak.peak_mz.name() || header.getKeyValue() == DMPrecursorPeak.precursor_peak_mz.name()) {
                MassSpecEntityProperty msep = (MassSpecEntityProperty)entry.getProperty();
                sFileName = msep.getDataFile().getName();
                return sFileName;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public void initializeGridHeaders() {
        this.setLinesVisible(true);
        this.setHeaderVisible(true);
        int i = 0;
        while (i < columnHeaders.length) {
            final GridColumn column = new GridColumn((Grid)this, 0);
            column.setText(columnHeaders[i]);
            column.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (column.getSort() == 128) {
                        column.setSort(1024);
                    } else {
                        column.setSort(128);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        this.editor = new GridEditor((Grid)this);
    }

    public void initializeGrid() {
        this.disposeAllItems();
        this.initPeakData();
        if (this.peakIntensityData == null) {
            return;
        }
        String sType = null;
        int i = 0;
        while (i < 4) {
            sType = i == 0 ? TYPE_STD : (i == 1 ? TYPE_EXT : (i == 2 ? TYPE_PRE : TYPE_PEAK));
            for (String sFileName : this.peakIntensityData.keySet()) {
                HashMap<Object, Object> mFileToType = null;
                if (this.peakIntensityData.containsKey(sFileName)) {
                    mFileToType = this.peakIntensityData.get(sFileName);
                } else {
                    mFileToType = new HashMap();
                    this.peakIntensityData.put(sFileName, mFileToType);
                }
                if (!mFileToType.containsKey(sType)) continue;
                HashMap hMztoInt = (HashMap)mFileToType.get(sType);
                Set setMZs = hMztoInt.keySet();
                TreeSet sortedMZs = new TreeSet(setMZs);
                for (Double dMz : sortedMZs) {
                    if (sType == TYPE_EXT && mFileToType.containsKey(TYPE_STD) && ((HashMap)mFileToType.get(TYPE_STD)).containsKey(dMz)) continue;
                    GridItem item = new GridItem((Grid)this, 0);
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            logger.debug((Object)"Did you click the cell?");
                        }
                    });
                    item.setText(0, sFileName);
                    item.setText(1, sType);
                    item.setText(2, dMz.toString());
                    Double[] dInts = (Double[])hMztoInt.get(dMz);
                    item.setText(3, dInts[0].toString());
                    item.setText(4, dInts[1] != null ? dInts[1].toString() : "");
                }
            }
            ++i;
        }
        i = 0;
        while (i < columnHeaders.length) {
            this.getColumn(i).pack();
            ++i;
        }
        final MassSpecPeakIntensityGrid me = this;
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
                MassSpecPeakIntensityGrid.this.disposeEditor();
                Point pt = new Point(e.x, e.y);
                GridColumn col = MassSpecPeakIntensityGrid.this.getColumn(pt);
                GridItem item = MassSpecPeakIntensityGrid.this.getItem(pt);
                if (item == null && col != null) {
                    MassSpecPeakIntensityGrid.this.getColNumberForGridColumn(col);
                    if (col.getSort() == 128) {
                        // empty if block
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                MassSpecPeakIntensityGrid.this.bIsEditingTable = true;
                Control oldEditor = MassSpecPeakIntensityGrid.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                Point pt = new Point(e.x, e.y);
                final GridItem item = MassSpecPeakIntensityGrid.this.getItem(pt);
                final Point cell = MassSpecPeakIntensityGrid.this.getCell(pt);
                if (item == null || cell == null) {
                    return;
                }
                if (cell.x != CELL_EDIT_COLUMN) {
                    return;
                }
                MassSpecPeakIntensityGrid.this.deselect(cell.y);
                final Text newEditor = new Text((Composite)me, 2052);
                String curText = item.getText(cell.x);
                newEditor.setText(curText);
                MassSpecPeakIntensityGrid.this.editor.setEditor((Control)newEditor, item, cell.x);
                MassSpecPeakIntensityGrid.this.editor.grabHorizontal = true;
                MassSpecPeakIntensityGrid.this.editor.grabVertical = true;
                newEditor.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                        item.setText(cell.x, newEditor.getText());
                        MassSpecPeakIntensityGrid.this.setTableChanged(cell.x, cell.y, newEditor.getText());
                    }

                    public void keyPressed(KeyEvent e) {
                    }
                });
                newEditor.forceFocus();
                newEditor.setSelection(newEditor.getText().length());
                newEditor.selectAll();
            }
        });
    }

    protected void setTableChanged(int x, int y, String sText) {
        GridItem gi = this.getItem(y);
        String sFile = gi.getText(0);
        String sType = gi.getText(1);
        String sMz = gi.getText(2);
        Double dMz = Double.parseDouble(sMz);
        HashMap<Object, Object> hmFiles = null;
        if (this.peaksChanged.containsKey(sType)) {
            hmFiles = this.peaksChanged.get(sType);
        } else {
            hmFiles = new HashMap();
            this.peaksChanged.put(sType, hmFiles);
        }
        HashMap hmPeaks = null;
        if (hmFiles.containsKey(sType)) {
            hmPeaks = (HashMap)hmFiles.get(sFile);
        } else {
            hmPeaks = new HashMap();
            hmFiles.put(sFile, hmPeaks);
        }
        String sNewInt = sText.trim();
        hmPeaks.put(dMz, sNewInt);
        this.valueChanged();
    }

    protected boolean isValidIntensity(String sInt) {
        if (!sInt.equals("")) {
            try {
                Double.parseDouble(sInt);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public String getErrorMessage() {
        if (this.peaksChanged == null) {
            return "";
        }
        for (String sType : this.peaksChanged.keySet()) {
            HashMap<String, HashMap<Double, String>> hmFiles = this.peaksChanged.get(sType);
            for (String sFile : hmFiles.keySet()) {
                HashMap<Double, String> hmPeaks = hmFiles.get(sFile);
                for (Double dMz : hmPeaks.keySet()) {
                    String sInt = hmPeaks.get(dMz);
                    if (this.isValidIntensity(sInt)) continue;
                    return "Intensity value " + sInt + " is not a valid double.";
                }
            }
        }
        return "";
    }

    public boolean isChanged(Double dOldInt, String sNewInt) {
        Double dNewInt = null;
        if (!sNewInt.equals("")) {
            try {
                dNewInt = Double.parseDouble(sNewInt);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (dNewInt != null && dOldInt != null) {
            return Double.compare(dNewInt, dOldInt) != 0;
        }
        return dNewInt != null && dOldInt == null || dNewInt == null && dOldInt != null;
    }

    public boolean isChanged() {
        if (this.peaksChanged == null) {
            return false;
        }
        for (String sType : this.peaksChanged.keySet()) {
            HashMap<String, HashMap<Double, String>> hmFiles = this.peaksChanged.get(sType);
            for (String sFile : hmFiles.keySet()) {
                HashMap<Double, String> hmPeaks = hmFiles.get(sFile);
                for (Double dMz : hmPeaks.keySet()) {
                    String sNewInt = hmPeaks.get(dMz);
                    HashMap<String, HashMap<Double, Double[]>> hmStoredFiles = this.peakIntensityData.get(sFile);
                    HashMap<Double, Double[]> hmMZs = hmStoredFiles.get(sType);
                    Double[] dInts = hmMZs.get(dMz);
                    Double dOldInt = dInts[1];
                    if (!this.isChanged(dOldInt, sNewInt)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void disposeEditor() {
        if (this.editor == null) {
            return;
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.editor.setEditor(null);
            this.bIsEditingTable = false;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setBackground(this.bgColor);
        }
    }

    protected int getColNumberForGridColumn(GridColumn col) {
        int i = 0;
        while (i < columnHeaders.length) {
            if (col.getText().equals(columnHeaders[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<String> getColumnKeyLabels() {
        return null;
    }

    public void addListener(IPropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyChangeListener>();
        }
        this.listeners.add(listener);
    }

    public List<IPropertyChangeListener> getListeners() {
        return this.listeners;
    }

    protected void valueChanged() {
        PropertyChangeEvent pce = new PropertyChangeEvent((Object)this, PROPERTY_LOCAL_CHANGE, (Object)Boolean.FALSE, (Object)Boolean.TRUE);
        for (IPropertyChangeListener listener : this.getListeners()) {
            listener.propertyChange(pce);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_LOCAL_CHANGE, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
    }
}

