/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferences;
import org.jdom.Element;
import org.jdom.JDOMException;

public class MSGlycanAnnotationCartoonPreferencesPreVersion {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationCartoonPreferencesPreVersion.class);
    private static final String PREVIOUS_CARTOON_PREFERENCE_ID = "org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreference";
    private static final String PREVIOUS_IMAGE_LAYOUT_ID = "org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.CartoonTypes.imageLayout";
    private static final String PREVIOUS_IMAGE_ORIENTATION_ID = "org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.CartoonTypes.imageOrientation";
    private static final String PREVIOUS_IMAGE_STYLE_ID = "org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.CartoonTypes.imageStyle";

    public static boolean removeElements() {
        try {
            PreferenceWriter.deletePreference((String)PREVIOUS_CARTOON_PREFERENCE_ID);
            PreferenceWriter.deletePreference((String)PREVIOUS_IMAGE_LAYOUT_ID);
            PreferenceWriter.deletePreference((String)PREVIOUS_IMAGE_ORIENTATION_ID);
            PreferenceWriter.deletePreference((String)PREVIOUS_IMAGE_STYLE_ID);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static MSGlycanAnnotationCartoonPreferences getCartoonPreferences(PreferenceEntity preferenceEntity) {
        MSGlycanAnnotationCartoonPreferences previousPreferences = null;
        try {
            previousPreferences = MSGlycanAnnotationCartoonPreferencesPreVersion.getMSAnnotationCartoonPreference();
            if (previousPreferences != null) {
                String selected;
                Element preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_IMAGE_LAYOUT_ID);
                if (preferenceElement.getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                    previousPreferences.setAllLayouts(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                    selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                    previousPreferences.setImageLayout(selected);
                }
                if ((preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_IMAGE_ORIENTATION_ID)).getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                    previousPreferences.setAllOrientations(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                    selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                    previousPreferences.setOrientation(selected);
                }
                if ((preferenceElement = PreferenceReader.getPreferenceElement((String)PREVIOUS_IMAGE_STYLE_ID)).getAttributeValue("values") != null && preferenceElement.getAttributeValue("values").length() != 0) {
                    previousPreferences.setAllStyles(UtilityPreferenceValue.getPreversioningValues((Element)preferenceElement));
                    selected = UtilityPreferenceValue.getPreversioningSelected((Element)preferenceElement);
                    previousPreferences.setImageStyle(selected);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            previousPreferences = null;
        }
        return previousPreferences;
    }

    private static MSGlycanAnnotationCartoonPreferences getMSAnnotationCartoonPreference() throws IOException, JDOMException {
        Element element = PreferenceReader.getPreferenceElement((String)PREVIOUS_CARTOON_PREFERENCE_ID);
        if (element == null) {
            return null;
        }
        MSGlycanAnnotationCartoonPreferences spf = new MSGlycanAnnotationCartoonPreferences();
        if (element.getAttributeValue("scalingFactor") != null && element.getAttributeValue("scalingFactor").length() != 0) {
            spf.setImageScaleFactor(element.getAttributeValue("scalingFactor"));
        } else {
            spf.setImageScaleFactor("0.5");
        }
        if (element.getAttributeValue("showMasses") != null && element.getAttributeValue("showMasses").length() != 0) {
            spf.setShowMasses(element.getAttributeValue("showMasses").equals(Boolean.toString(true)));
        } else {
            spf.setShowMasses(false);
        }
        if (element.getAttributeValue("showRedEnd") != null && element.getAttributeValue("showRedEnd").length() != 0) {
            spf.setShowRedEnd(element.getAttributeValue("showRedEnd").equals(Boolean.toString(true)));
        } else {
            spf.setShowRedEnd(true);
        }
        return spf;
    }
}

