/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.oldUtil;

import java.util.ArrayList;
import java.util.Iterator;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;
import org.glycoinfo.WURCSFramework.util.residuecontainer.ResidueContainer;
import org.glycoinfo.WURCSFramework.wurcs.array.LIP;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.BRIDGE;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.GRES;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.MSPERI;
import org.glycoinfo.WURCSFramework.wurcs.sequence2.SUBST;

public class SubstituentAnalyzer {
    private ArrayList<String> a_aSubs;
    private ResidueContainer a_oRC;

    public ArrayList<String> getSubstituents(ResidueContainer a_oRC, GRES a_oGRES, MS a_oMS) throws ConverterExchangeException {
        this.a_aSubs = new ArrayList();
        this.a_oRC = a_oRC;
        this.analyzeSUBST(a_oGRES.getMS(), a_oMS);
        this.analyzeBRIDGE(a_oGRES, a_oMS);
        return this.a_aSubs;
    }

    private void analyzeSUBST(MSPERI a_oMSPERI, MS a_oMS) {
        for (SUBST a_oSUBST : a_oMSPERI.getCoreStructure().getSubstituents()) {
            int a_iPosition = (Integer)a_oSUBST.getPositions().getFirst();
            String a_sMAP = a_oSUBST.getMAP();
            if (this.a_oRC.getBackBoneSize() == 9 && a_sMAP.startsWith("*N") && (a_iPosition == 5 || a_iPosition == 7 && this.a_oRC.getNativeSubstituent().contains("5*N"))) {
                this.a_oRC.addNativeSubstituent(a_iPosition + "*N");
                if (a_sMAP.equals("*N")) continue;
                String a_sNativeSub = a_iPosition + a_sMAP.replaceFirst("N", "O");
                if (a_sNativeSub.contains("OCC") && a_sNativeSub.contains("/3=O")) {
                    this.a_oRC.addNativeSubstituent(a_sNativeSub);
                    continue;
                }
                this.a_aSubs.add(a_sNativeSub);
                continue;
            }
            if (this.a_oRC.getBackBoneSize() == 6 && a_sMAP.startsWith("*N")) {
                if (a_iPosition == 2) {
                    if (!this.a_oRC.isAcidicSugar()) {
                        if (a_sMAP.equals("*NCC/3=O") || a_sMAP.equals("*N")) {
                            this.a_oRC.addNativeSubstituent(a_iPosition + a_sMAP);
                            continue;
                        }
                        this.a_oRC.addNativeSubstituent(a_iPosition + "*N");
                        this.a_aSubs.add(a_iPosition + a_sMAP.replaceFirst("N", "O"));
                        continue;
                    }
                    this.a_aSubs.add(a_iPosition + a_sMAP);
                    continue;
                }
                if (a_iPosition == 4 && this.a_oRC.getNativeSubstituent().contains("2*N")) {
                    this.a_aSubs.add(a_iPosition + "*N");
                    if (a_sMAP.equals("*N")) continue;
                    this.a_aSubs.add(a_iPosition + a_sMAP.replaceFirst("N", "O"));
                    continue;
                }
            }
            String a_sPosition = String.valueOf(a_iPosition);
            if (a_iPosition == -1) {
                a_sPosition = "?";
            }
            this.a_aSubs.add(a_sPosition + a_sMAP);
        }
        for (SUBST a_oSUBST : a_oMSPERI.getSubstituents()) {
            StringBuilder a_sMAP = new StringBuilder();
            a_sMAP.append(this.checkSubstituentPosition(a_oMS, a_oSUBST));
            a_sMAP.append(a_oSUBST.getMAP());
            if (this.a_aSubs.contains(a_sMAP.toString()) && a_sMAP.indexOf("?") != 0) continue;
            this.a_aSubs.add(a_sMAP.toString());
        }
    }

    private void analyzeBRIDGE(GRES a_oGRES, MS a_oMS) throws ConverterExchangeException {
        for (BRIDGE a_oBRIDGE : a_oGRES.getMS().getCoreStructure().getDivalentSubstituents()) {
            if (a_oBRIDGE.getMAP().equals("")) {
                if (a_oBRIDGE.getStartPositions().contains(a_oGRES.getMS().getCoreStructure().getAnomericPosition())) continue;
                this.a_oRC.addModification(this.makeBridgePosiiton(a_oMS, a_oBRIDGE) + "*o");
                continue;
            }
            throw new ConverterExchangeException("Divelent substituent could not converted");
        }
        for (BRIDGE a_oBRIDGE : a_oGRES.getMS().getDivalentSubstituents()) {
            if (a_oBRIDGE.getMAP().equals("")) continue;
            throw new ConverterExchangeException("Divelent substituent could not converted");
        }
    }

    private String checkSubstituentPosition(MS a_oMS, SUBST a_oSUBST) {
        StringBuilder a_sPosition = new StringBuilder();
        Iterator i = a_oSUBST.getPositions().iterator();
        while (i.hasNext()) {
            int a_iPosition = (Integer)i.next();
            a_sPosition.append(a_iPosition == -1 ? "?" : Integer.valueOf(a_iPosition));
            a_sPosition.append(this.extractProbabilityPosition(a_oMS, a_oSUBST, a_iPosition));
            if (!i.hasNext()) continue;
            a_sPosition.append("/");
        }
        return a_sPosition.toString();
    }

    private String makeBridgePosiiton(MS a_oMS, BRIDGE a_oBRIDGE) {
        StringBuilder a_sbPosition = new StringBuilder();
        a_sbPosition.append(a_oBRIDGE.getStartPositions().getFirst() + ",");
        a_sbPosition.append(a_oBRIDGE.getEndPositions().getFirst());
        return a_sbPosition.toString();
    }

    private String extractProbabilityPosition(MS a_oMS, SUBST a_oSUBST, int a_iPosition) {
        StringBuilder a_sProbability = new StringBuilder();
        for (MOD a_oMOD : a_oMS.getMODs()) {
            if (a_oMOD.getMAPCode().equals("") || !a_oMOD.getMAPCode().equals(a_oSUBST.getMAP())) continue;
            for (LIP a_oLIP : ((LIPs)a_oMOD.getListOfLIPs().getFirst()).getLIPs()) {
                if (a_oLIP.getBackbonePosition() != a_iPosition || a_oLIP.getModificationProbabilityLower() == 1.0 && a_oLIP.getModificationProbabilityUpper() == 1.0) continue;
                if (a_oLIP.getModificationProbabilityLower() == -1.0) {
                    a_sProbability.append("(%)");
                    continue;
                }
                a_sProbability.append("(");
                a_sProbability.append((int)(a_oLIP.getModificationProbabilityLower() * 100.0));
                a_sProbability.append("%)");
            }
            if (a_sProbability.length() <= 0) continue;
            break;
        }
        return a_sProbability.toString();
    }
}

