/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util;

import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer.MAPAnalyzer;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;

public class SubstituentUtility {
    public static boolean isNLinkedSubstituent(Substituent _sub) {
        if (_sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            return false;
        }
        BaseSubstituentTemplate bsubT = (BaseSubstituentTemplate)_sub.getSubstituent();
        if (bsubT.getIUPACnotation().equals("N")) {
            return false;
        }
        return bsubT.getIUPACnotation().startsWith("N") || bsubT.equals(BaseSubstituentTemplate.ETHANOLAMINE);
    }

    public static boolean isOLinkedSubstituent(Substituent _sub) {
        SubstituentInterface subFace = _sub.getSubstituent();
        if (subFace instanceof BaseCrossLinkedTemplate) {
            return SubstituentUtility.isOLinkedSubstituent((BaseCrossLinkedTemplate)subFace);
        }
        if (subFace instanceof BaseSubstituentTemplate) {
            return _sub.getHeadAtom().equals("O");
        }
        return false;
    }

    public static boolean isOLinkedSubstituent(BaseCrossLinkedTemplate _crossT) {
        if (_crossT.equals(BaseCrossLinkedTemplate.PHOSPHOETHANOLAMINE)) {
            return true;
        }
        return _crossT.getMAP().startsWith("*O") || _crossT.getMAP().startsWith("*1O");
    }

    public static Substituent MAPToSubstituent(Modification _mod) throws GlycanException, WURCSFormatException {
        if (_mod.getMAPCode().equals("")) {
            return null;
        }
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_mod.getMAPCode());
        Substituent ret = null;
        if (mapAnalyze.getSingleTemplate() != null) {
            ret = new Substituent(mapAnalyze.getSingleTemplate());
            ret.setHeadAtom(mapAnalyze.getHeadAtom());
        }
        if (mapAnalyze.getCrossTemplate() != null) {
            ret = new Substituent(mapAnalyze.getCrossTemplate());
            ret.setHeadAtom(mapAnalyze.getHeadAtom());
            ret.setTailAtom(mapAnalyze.getTailAtom());
        }
        if (mapAnalyze.getSingleTemplate() == null && mapAnalyze.getCrossTemplate() == null) {
            throw new GlycanException("This substituent could not support: " + _mod.getMAPCode());
        }
        return ret;
    }

    public static SubstituentInterface MAPToInterface(String _map) throws GlycanException, WURCSFormatException {
        if (_map.equals("")) {
            return null;
        }
        Enum ret = null;
        MAPAnalyzer mapAnalyze = new MAPAnalyzer();
        mapAnalyze.start(_map);
        if (mapAnalyze.getSingleTemplate() != null) {
            ret = mapAnalyze.getSingleTemplate();
        }
        if (mapAnalyze.getCrossTemplate() != null) {
            ret = mapAnalyze.getCrossTemplate();
        }
        if (ret == null) {
            throw new GlycanException(_map + " could not found !");
        }
        return ret;
    }

    public static String optimizeSubstituentNotationWithLinkageType(Substituent _sub) {
        String ret = _sub.getNameWithIUPAC();
        String bracket = "";
        if (ret.startsWith("(")) {
            bracket = ret.substring(0, ret.indexOf(")") + 1);
            String regex = bracket.replace("(", "\\(").replace(")", "\\)");
            ret = ret.replaceFirst(regex, "");
        }
        if (_sub.getFirstPosition() == null) {
            return ret;
        }
        if (!(!_sub.getFirstPosition().getParentLinkageType().equals((Object)LinkageType.H_LOSE) || bracket.equals("") && ret.startsWith("C"))) {
            ret = "C" + ret;
        }
        return bracket + ret;
    }

    public static void changeOlinkedTemplate(Substituent _sub) {
        BaseSubstituentTemplate bsubT;
        if (!SubstituentUtility.isNLinkedSubstituent(_sub)) {
            return;
        }
        if (_sub.getSubstituent().equals(BaseSubstituentTemplate.ETHANOLAMINE)) {
            bsubT = BaseSubstituentTemplate.ETHANOL;
        } else {
            String plane = _sub.getNameWithIUPAC().replaceFirst("N", "");
            bsubT = BaseSubstituentTemplate.forIUPACNotationWithIgnore(plane);
        }
        _sub.setTemplate(bsubT);
        _sub.setHeadAtom("O");
    }

    public static void changeNlinkedTemplate(Substituent _sub) {
        if (SubstituentUtility.isNLinkedSubstituent(_sub)) {
            return;
        }
        BaseSubstituentTemplate bsubT = _sub.getSubstituent().equals(BaseSubstituentTemplate.ETHANOL) ? BaseSubstituentTemplate.ETHANOLAMINE : BaseSubstituentTemplate.forIUPACNotationWithIgnore("N" + _sub.getNameWithIUPAC());
        _sub.setTemplate(bsubT);
        _sub.setHeadAtom("N");
    }
}

