/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.ms.property.LockEntry;

@XmlRootElement(name="file")
public class FileLock {
    String filename;
    Integer lockCount = 0;
    List<LockEntry> usedBy;

    @XmlElement
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @XmlAttribute
    public Integer getLockCount() {
        return this.lockCount;
    }

    public void setLockCount(Integer lockCount) {
        this.lockCount = lockCount;
    }

    public void incrementLock() {
        this.lockCount = this.lockCount + 1;
    }

    public void decrementLock() {
        if (this.lockCount > 0) {
            this.lockCount = this.lockCount - 1;
        }
    }

    boolean isLocked() {
        return this.lockCount > 0;
    }

    public List<LockEntry> getUsedBy() {
        return this.usedBy;
    }

    public void setUsedBy(List<LockEntry> usedBy) {
        this.usedBy = usedBy;
    }

    public void addEntry(Entry entry) {
        if (this.usedBy == null) {
            this.usedBy = new ArrayList<LockEntry>();
        }
        LockEntry lockEntry = new LockEntry();
        lockEntry.entryId = entry.getId();
        lockEntry.entryName = entry.getDisplayName();
        if (this.findEntry(lockEntry) == null) {
            this.usedBy.add(lockEntry);
        }
    }

    private LockEntry findEntry(LockEntry entry) {
        if (this.usedBy == null) {
            return null;
        }
        for (LockEntry e : this.usedBy) {
            if (e.entryId == null || !e.entryId.equals(entry.entryId)) continue;
            return e;
        }
        return null;
    }

    public void deleteEntry(Entry entry) {
        if (this.usedBy == null) {
            return;
        }
        LockEntry lockEntry = new LockEntry();
        lockEntry.entryId = entry.getId();
        lockEntry.entryName = entry.getDisplayName();
        LockEntry toDelete = this.findEntry(lockEntry);
        if (toDelete != null) {
            this.usedBy.remove(toDelete);
        }
    }

    public void addEntry(LockEntry lockEntry) {
        if (this.usedBy == null) {
            this.usedBy = new ArrayList<LockEntry>();
        }
        if (this.findEntry(lockEntry) == null) {
            this.usedBy.add(lockEntry);
        }
    }

    public void removeEntry(LockEntry lockEntry) {
        LockEntry existing = this.findEntry(lockEntry);
        if (existing != null) {
            this.usedBy.remove(existing);
        }
    }
}

