/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.dialog.IDynamicTableProcessor;
import org.grits.toolbox.entry.ms.dialog.MassSpecPeakIntensityGrid;
import org.grits.toolbox.entry.ms.dialog.MassSpecViewerDialog;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecPeakIntensityApplyDialog
extends MassSpecViewerDialog
implements IPropertyChangeListener,
IDynamicTableProcessor {
    private static final Logger logger = Logger.getLogger(MassSpecPeakIntensityApplyDialog.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    protected Text txtOutput;
    protected static final String PARAMS_OK = "Valid parameters";
    protected Label lblPeakTypes = null;
    protected Button cbShowStandards = null;
    protected Button cbShowExternals = null;
    protected Button cbShowAnnotated = null;
    protected Label lblMzRange = null;
    protected Label lblStartMz = null;
    protected Text txtStartMz = null;
    protected Label lblEndMz = null;
    protected Text txtEndMz = null;
    protected Button btnRefreshList = null;
    protected Button btnApplyFilter = null;
    protected Button btnModifyList = null;
    protected Button btnClearStandardQuant = null;
    protected MassSpecPeakIntensityGrid peakIntensityGrid = null;
    public static final String PROPERTY_WIN_CLOSED = "Window Closed";
    protected MassSpecTableDataObject msTableDataObject = null;
    protected boolean bHasStandards = false;
    protected boolean bHasExternal = false;

    public MassSpecPeakIntensityApplyDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer, MassSpecTableDataObject msTableDataObject) {
        super(parentShell, contextViewer);
        this.msTableDataObject = msTableDataObject;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getFormTitle());
        Composite area = (Composite)super.createDialogArea(parent);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        area.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(area, 0);
        GridLayout subLayout = new GridLayout(5, false);
        composite.setLayout((Layout)subLayout);
        this.addPeakTypeCheckboxes(composite);
        this.addMzRangeItems(composite);
        this.addBlankRow(composite);
        this.addRefreshButton(composite);
        this.addMassSpecPeakIntensityGrid(area);
        this.cbShowStandards.setEnabled(this.peakIntensityGrid.hasStandards());
        this.cbShowExternals.setEnabled(this.peakIntensityGrid.hasExternal());
        boolean bShowSomething = false;
        if (this.cbShowStandards.isEnabled()) {
            this.cbShowStandards.setSelection(true);
            bShowSomething = true;
        }
        if (this.cbShowExternals.isEnabled()) {
            this.cbShowExternals.setSelection(false);
            bShowSomething = true;
        }
        if (!bShowSomething) {
            this.cbShowAnnotated.setSelection(true);
        }
        this.txtStartMz.setText("800.0");
        this.txtEndMz.setText("1000.0");
        this.updateList();
        return area;
    }

    @Override
    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            MassSpecMultiPageViewer viewer;
            EPartService partService = this.getContextViewer().getPartService();
            MPart mPart = partService.getActivePart();
            if (mPart != null && mPart.equals(mPart.getParent().getSelectedElement()) && mPart.getObject() instanceof MassSpecMultiPageViewer && (viewer = (MassSpecMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() != null && viewer.getEntry().getProperty() instanceof MassSpecEntityProperty) {
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Entry getEntryForCurrentViewer() {
        MassSpecMultiPageViewer viewer = this.getCurrentViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getEntry();
    }

    @Override
    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MassSpecEntityProperty msep = (MassSpecEntityProperty)entry.getProperty();
            MassSpecProperty pp = msep.getMassSpecParentProperty();
            return pp;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public MassSpecUISettings getSourceMassSpecEntrySettings() {
        MassSpecProperty msp = (MassSpecProperty)this.getEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings;
    }

    public MassSpecUISettings getEntrySettingsForInternalStandardFiles() {
        MassSpecProperty msp = (MassSpecProperty)this.getEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings;
    }

    protected MassSpecPeakIntensityGrid getNewMassSpecPeakIntensityGrid(Composite parent) {
        return new MassSpecPeakIntensityGrid(parent, this);
    }

    protected void addBlankRow(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, true, 5, 1);
        Label lblGoDawgs = new Label(parent, 0);
        lblGoDawgs.setLayoutData((Object)gd1);
        lblGoDawgs.setText("    ");
    }

    protected void addPeakTypeCheckboxes(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 5, 1);
        this.lblPeakTypes = new Label(parent, 0);
        this.lblPeakTypes.setText("Select peak types to show:");
        this.lblPeakTypes.setLayoutData((Object)gd1);
        gd1 = new GridData(16384, 4, false, false, 1, 1);
        Label lblGoDawgs = new Label(parent, 0);
        lblGoDawgs.setLayoutData((Object)gd1);
        lblGoDawgs.setText("    ");
        GridData gd2 = new GridData(16384, 4, true, false, 4, 1);
        this.cbShowStandards = new Button(parent, 32);
        this.cbShowStandards.setText("Internal Standards");
        this.cbShowStandards.setLayoutData((Object)gd2);
        gd1 = new GridData(4, 4, false, false, 1, 1);
        lblGoDawgs = new Label(parent, 0);
        lblGoDawgs.setLayoutData((Object)gd1);
        lblGoDawgs.setText("    ");
        gd2 = new GridData(16384, 4, true, false, 4, 1);
        this.cbShowExternals = new Button(parent, 32);
        this.cbShowExternals.setText("External Quantification");
        this.cbShowExternals.setLayoutData((Object)gd2);
        gd1 = new GridData(4, 4, false, false, 1, 1);
        lblGoDawgs = new Label(parent, 0);
        lblGoDawgs.setLayoutData((Object)gd1);
        lblGoDawgs.setText("    ");
        gd2 = new GridData(16384, 4, true, false, 4, 1);
        this.cbShowAnnotated = new Button(parent, 32);
        this.cbShowAnnotated.setText("Peaks from Annotation File");
        this.cbShowAnnotated.setLayoutData((Object)gd2);
    }

    protected void addMzRangeItems(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 5, 1);
        this.lblMzRange = new Label(parent, 0);
        this.lblMzRange.setText("Specify m/z range to show:");
        this.lblMzRange.setLayoutData((Object)gd1);
        gd1 = new GridData(16384, 4, false, false, 1, 1);
        Label lblGoDawgs = new Label(parent, 0);
        lblGoDawgs.setLayoutData((Object)gd1);
        lblGoDawgs.setText("    ");
        GridData gd2 = new GridData(16384, 4, false, false, 1, 1);
        this.lblStartMz = new Label(parent, 0);
        this.lblStartMz.setLayoutData((Object)gd2);
        this.lblStartMz.setText("Start: ");
        GridData gd3 = new GridData(16384, 4, false, false, 1, 1);
        this.txtStartMz = new Text(parent, 0);
        this.txtStartMz.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(16384, 4, false, false, 1, 1);
        this.lblEndMz = new Label(parent, 0);
        this.lblEndMz.setLayoutData((Object)gd4);
        this.lblEndMz.setText("End: ");
        GridData gd5 = new GridData(16384, 4, true, false, 1, 1);
        this.txtEndMz = new Text(parent, 0);
        this.txtEndMz.setLayoutData((Object)gd5);
    }

    protected void updateList() {
        this.peakIntensityGrid.setShowStandards(false);
        if (this.cbShowStandards.isEnabled()) {
            this.peakIntensityGrid.setShowStandards(this.cbShowStandards.getSelection());
        }
        this.peakIntensityGrid.setShowExternal(false);
        if (this.cbShowExternals.isEnabled()) {
            this.peakIntensityGrid.setShowExternal(this.cbShowExternals.getSelection());
        }
        this.peakIntensityGrid.setShowInternal(false);
        if (this.cbShowAnnotated.isEnabled()) {
            this.peakIntensityGrid.setShowInternal(this.cbShowAnnotated.getSelection());
        }
        try {
            this.peakIntensityGrid.setStartMz(null);
            if (!this.txtStartMz.getText().equals("")) {
                this.peakIntensityGrid.setStartMz(Double.parseDouble(this.txtStartMz.getText()));
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            this.peakIntensityGrid.setEndMz(null);
            if (!this.txtEndMz.getText().equals("")) {
                this.peakIntensityGrid.setEndMz(Double.parseDouble(this.txtEndMz.getText()));
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.peakIntensityGrid.initializeGrid();
    }

    protected void addRefreshButton(Composite parent) {
        GridData gd2 = new GridData(4, 1024, true, true, 5, 2);
        this.btnApplyFilter = new Button(parent, 524288);
        this.btnApplyFilter.setText("Update Peak List");
        this.btnApplyFilter.setLayoutData((Object)gd2);
        this.btnApplyFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecPeakIntensityApplyDialog.this.updateList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void addMassSpecPeakIntensityGrid(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, true, 1, 50);
        MassSpecMultiPageViewer curView = this.getCurrentViewer();
        if (curView == null) {
            return;
        }
        Entry msEntry = curView.getEntry();
        if (msEntry == null) {
            return;
        }
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MassSpecEntityProperty) {
            this.peakIntensityGrid = this.getNewMassSpecPeakIntensityGrid(parent);
            this.peakIntensityGrid.setMSTableDataObject(this.msTableDataObject);
            this.peakIntensityGrid.initializeGridHeaders();
            this.peakIntensityGrid.initializeGrid();
            this.peakIntensityGrid.setLayoutData(gd1);
            this.peakIntensityGrid.addListener(this);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 10) {
            boolean bChanged = this.peakIntensityGrid.applyPressed();
            if (bChanged) {
                this.updateSettings();
                this.updateViewer();
                this.getButton(1).setText(IDialogConstants.CLOSE_LABEL);
                this.getButton(10).setEnabled(false);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, "Apply", true);
        this.getButton(10).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public int open() {
        Entry entry = this.getEntryForCurrentViewer();
        if (entry == null) {
            return -1;
        }
        this.setMassSpecEntry(entry);
        super.create();
        this.getShell().open();
        this.getShell().layout();
        this.getShell().pack();
        this.getShell().setSize(900, 700);
        return this.getReturnCode();
    }

    protected boolean isResizable() {
        return true;
    }

    protected String getFormTitle() {
        return "Mass Spec Peak Intensity Correction";
    }

    protected String getStandardQuantificationLabelText() {
        return "MS Std Quantification";
    }

    public void validateInput() {
        this.txtOutput.setText(PARAMS_OK);
        if (this.getMassSpecEntry() == null) {
            this.txtOutput.setText("Please select Mass Spec Results");
        }
    }

    public boolean close() {
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_WIN_CLOSED, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
        return super.close();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof MassSpecPeakIntensityGrid && event.getProperty().equals("Local changes")) {
            this.getButton(10).setEnabled(false);
            String sError = this.peakIntensityGrid.getErrorMessage();
            if (!sError.equals("")) {
                this.setErrorMessage(sError);
                return;
            }
            if (this.peakIntensityGrid.isChanged()) {
                this.getButton(10).setEnabled(true);
            }
        }
    }

    protected void updateSettings() {
        MassSpecProperty property = (MassSpecProperty)this.getEntryParentProperty();
        try {
            Entry projectEntry = this.getEntryForCurrentViewer();
            String settingsFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(projectEntry)) + File.separator + property.getMSSettingsFile().getName();
            property.marshallSettingsFile(settingsFile, property.getMassSpecMetaData());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void updateViewer() {
        try {
            MassSpecMultiPageViewer viewer = this.getCurrentViewer();
            List<String> sKeyVals = this.getColumnKeyLabels();
            viewer.reLoadScansTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getColumnKeyLabels() {
        return null;
    }
}

