/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.style;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageStyle;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class LinkageStyleDictionary {
    private Vector<LinkageStyle> styles = new Vector();

    public void loadStyles(String filename) {
        this.styles.clear();
        try {
            String line;
            URL file_url = LinkageStyleDictionary.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim((String)line)).length() <= 0 || line.startsWith("%")) continue;
                LinkageStyle toadd = new LinkageStyle(line);
                this.styles.add(toadd);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            this.styles.clear();
        }
    }

    public LinkageStyle getStyle(Linkage link) {
        return this.getStyle(link.getParentResidue(), link, link.getChildResidue());
    }

    public LinkageStyle getStyle(Residue parent, Linkage link, Residue child) {
        for (LinkageStyle s : this.styles) {
            if (!s.matches(parent, link, child)) continue;
            return s;
        }
        return new LinkageStyle();
    }
}

