/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.render.ps.EPSTranscoder;
import org.apache.fop.render.ps.PSTranscoder;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.GlycanRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.GlycanRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.GroupingSVGGraphics2D;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.LinkageRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.ResidueRendererAWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.awt.SVGGlycanRenderer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGUtils {
    private SVGUtils() {
    }

    public static GlycanRendererAWT convertRenderer(GlycanRendererSWT src) {
        GlycanRendererAWT conv = new GlycanRendererAWT();
        conv.setResiduePlacementDictionary(src.getResiduePlacementDictionary());
        conv.setResidueStyleDictionary(src.getResidueStyleDictionary());
        conv.setLinkageStyleDictionary(src.getLinkageStyleDictionary());
        conv.setGraphicOptions(src.getGraphicOptions().cloneSuper());
        conv.setResidueRenderer(new ResidueRendererAWT(conv));
        conv.setLinkageRenderer(new LinkageRendererAWT(conv));
        return conv;
    }

    public static Map<String, String> getExportFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("svg", "SVG");
        map.put("pdf", "PDF");
        map.put("ps", "PS");
        map.put("eps", "EPS");
        map.put("bmp", "BMP");
        map.put("png", "PNG");
        map.put("jpg", "JPG");
        return map;
    }

    public static boolean isGraphicFormat(String format) {
        return SVGUtils.getExportFormats().containsKey(format);
    }

    public static String getVectorGraphics(GlycanRendererAWT gr, Collection<Glycan> structures) {
        return SVGUtils.getVectorGraphics(gr, structures, false, false);
    }

    public static String getVectorGraphics(GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend) {
        if (structures == null) {
            structures = new Vector<Glycan>();
        }
        try {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            Document document = domImpl.createDocument(null, "svg", null);
            GroupingSVGGraphics2D g2d = new GroupingSVGGraphics2D(document, true);
            SVGGlycanRenderer sgr = new SVGGlycanRenderer(gr);
            PositionManager posManager = new PositionManager();
            BBoxManager bboxManager = new BBoxManager();
            Rectangle all_bbox = sgr.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager);
            Dimension d = sgr.computeSize(all_bbox);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setBackground(Color.white);
            g2d.clearRect(0, 0, d.width, d.height);
            for (Glycan s : structures) {
                sgr.paint(g2d, s, null, null, show_masses, show_redend, posManager, bboxManager);
            }
            StringWriter out = new StringWriter();
            g2d.stream(out, true);
            return out.toString();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    public static byte[] getPSGraphics(GlycanRendererAWT gr, Collection<Glycan> structures) {
        return SVGUtils.getTranscodedSVG(gr, structures, false, false, (Transcoder)new PSTranscoder());
    }

    public static byte[] getPSGraphics(GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend) {
        return SVGUtils.getTranscodedSVG(gr, structures, show_masses, show_redend, (Transcoder)new PSTranscoder());
    }

    public static byte[] getEPSGraphics(GlycanRendererAWT gr, Collection<Glycan> structures) {
        return SVGUtils.getTranscodedSVG(gr, structures, false, false, (Transcoder)new EPSTranscoder());
    }

    public static byte[] getEPSGraphics(GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend) {
        return SVGUtils.getTranscodedSVG(gr, structures, show_masses, show_redend, (Transcoder)new EPSTranscoder());
    }

    private static SVGGraphics2D prepareGraphics(Dimension all_dim) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D g2d = new SVGGraphics2D(document);
        g2d.setBackground(Color.white);
        g2d.setSVGCanvasSize(all_dim);
        return g2d;
    }

    private static byte[] transcode(SVGGraphics2D g2d, Dimension all_dim, Transcoder transcoder) throws Exception {
        StringWriter out = new StringWriter();
        g2d.stream((Writer)out, true);
        String svg = out.toString();
        if (transcoder == null) {
            return svg.getBytes();
        }
        transcoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.white);
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(0.3528f));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, (Object)new Float(all_dim.width));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, (Object)new Float(all_dim.height));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(all_dim.width));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(all_dim.height));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_AOI, (Object)new Rectangle(0, 0, all_dim.width, all_dim.height));
        StringReader in = new StringReader(svg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        TranscoderInput input = new TranscoderInput((Reader)in);
        TranscoderOutput output = new TranscoderOutput((OutputStream)bos);
        transcoder.transcode(input, output);
        return baos.toByteArray();
    }

    private static byte[] getTranscodedSVG(GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend, Transcoder transcoder) {
        if (structures == null) {
            structures = new Vector<Glycan>();
        }
        try {
            PositionManager posManager = new PositionManager();
            BBoxManager bboxManager = new BBoxManager();
            Rectangle all_bbox = gr.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager);
            Dimension all_dim = gr.computeSize(all_bbox);
            SVGGraphics2D g2d = SVGUtils.prepareGraphics(all_dim);
            if (transcoder != null && transcoder instanceof EPSTranscoder) {
                g2d.scale(1.0, -1.0);
                g2d.translate(0, -all_dim.height);
            }
            for (Glycan s : structures) {
                gr.paint((Graphics2D)g2d, s, null, null, show_masses, show_redend, posManager, bboxManager);
            }
            return SVGUtils.transcode(g2d, all_dim, transcoder);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    private static byte[] getTranscodedSVG(Renderable renderable, Transcoder transcoder) {
        try {
            renderable.beforeRendering();
            Dimension all_dim = renderable.getRenderableSize();
            SVGGraphics2D g2d = SVGUtils.prepareGraphics(all_dim);
            if (transcoder != null && transcoder instanceof EPSTranscoder) {
                g2d.scale(1.0, -1.0);
                g2d.translate(0, -all_dim.height);
            }
            renderable.paintRenderable((Graphics2D)g2d);
            renderable.afterRendering();
            return SVGUtils.transcode(g2d, all_dim, transcoder);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    public static BufferedImage getImage(Renderable renderable) {
        return SVGUtils.getImage(renderable, true);
    }

    public static BufferedImage getImage(Renderable renderable, boolean opaque) {
        renderable.beforeRendering();
        Dimension d = renderable.getRenderableSize();
        BufferedImage img = GraphicUtils.createCompatibleImage((int)d.width, (int)d.height, (boolean)opaque);
        Graphics2D g2d = img.createGraphics();
        if (!opaque) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setBackground(new Color(255, 255, 255, 0));
        }
        renderable.paintRenderable(g2d);
        renderable.afterRendering();
        return img;
    }

    public static boolean export(GlycanRendererAWT gr, String filename, Collection<Glycan> structures, boolean show_masses, boolean show_redend, String format) {
        return SVGUtils.export(gr, filename, structures, show_masses, show_redend, 1.0, format);
    }

    public static boolean export(GlycanRendererAWT gr, String filename, Collection<Glycan> structures, boolean show_masses, boolean show_redend, double scale, String format) {
        try {
            FileOutputStream os = new FileOutputStream(filename);
            SVGUtils.export(os, gr, structures, show_masses, show_redend, scale, format);
            ((OutputStream)os).close();
            return true;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    public static byte[] export(GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend, String format) {
        return SVGUtils.export(gr, structures, show_masses, show_redend, 1.0, format);
    }

    public static byte[] export(GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend, double scale, String format) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SVGUtils.export(bos, gr, structures, show_masses, show_redend, scale, format);
            return bos.toByteArray();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    public static void export(OutputStream os, GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend, String format) throws Exception {
        SVGUtils.export(os, gr, structures, show_masses, show_redend, 1.0, format);
    }

    public static void export(OutputStream os, GlycanRendererAWT gr, Collection<Glycan> structures, boolean show_masses, boolean show_redend, double scale, String format) throws Exception {
        if (format.equals("svg")) {
            os.write(SVGUtils.getVectorGraphics(gr, structures, show_masses, show_redend).getBytes());
        } else if (format.equals("ps")) {
            os.write(SVGUtils.getPSGraphics(gr, structures, show_masses, show_redend));
        } else if (format.equals("eps")) {
            os.write(SVGUtils.getEPSGraphics(gr, structures, show_masses, show_redend));
        } else if (format.equals("bmp") || format.equals("png") || format.equals("jpg")) {
            ImageIO.write((RenderedImage)gr.getImage(structures, true, show_masses, show_redend, scale), format, os);
        } else {
            throw new Exception("Unrecognized graphic format: " + format);
        }
    }

    public static void export(String filename, Renderable renderable, String format) throws Exception {
        FileOutputStream os = new FileOutputStream(filename);
        SVGUtils.export(os, renderable, format);
        ((OutputStream)os).close();
    }

    public static void export(OutputStream os, Renderable renderable, String format) throws Exception {
        if (format.equals("svg")) {
            os.write(SVGUtils.getTranscodedSVG(renderable, null));
        } else if (format.equals("ps")) {
            os.write(SVGUtils.getTranscodedSVG(renderable, (Transcoder)new PSTranscoder()));
        } else if (format.equals("eps")) {
            os.write(SVGUtils.getTranscodedSVG(renderable, (Transcoder)new EPSTranscoder()));
        } else if (format.equals("bmp") || format.equals("png") || format.equals("jpg")) {
            ImageIO.write((RenderedImage)SVGUtils.getImage(renderable), format, os);
        } else {
            throw new Exception("Unrecognized graphic format: " + format);
        }
    }

    public static interface Renderable {
        public void beforeRendering();

        public void paintRenderable(Graphics2D var1);

        public Dimension getRenderableSize();

        public void afterRendering();
    }
}

