/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import ca.odell.glazedlists.SortedList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.comparators.NullComparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.table.PlateTableColumnPropertyAccessor;
import org.grits.toolbox.entry.qrtpcr.table.merge.MergeReportColumnPropertyAccessor;

public class PlateTableSortModel<T>
extends GlazedListsSortModel<T> {
    public PlateTableSortModel(SortedList<T> sortedList, IColumnPropertyAccessor<T> columnAccessor, IConfigRegistry configRegistry, ILayer dataLayer) {
        super(sortedList, columnAccessor, configRegistry, dataLayer);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        String columnName = "";
        if (this.columnAccessor instanceof PlateTableColumnPropertyAccessor) {
            columnName = ((PlateTableColumnPropertyAccessor)this.columnAccessor).getColumnProperty(columnIndex);
        } else if (this.columnAccessor instanceof MergeReportColumnPropertyAccessor) {
            columnName = ((MergeReportColumnPropertyAccessor)this.columnAccessor).getColumnProperty(columnIndex);
        }
        if (columnName.equals("Well") || columnName.equals("ct0") || columnName.equals("2^-ct")) {
            final String column = columnName;
            Comparator<TableData> ownComparator = new Comparator<TableData>(){

                @Override
                public int compare(TableData e1, TableData e2) {
                    int c;
                    block15: {
                        c = 0;
                        if (e1 instanceof Gene && e2 instanceof Gene) {
                            int i = 0;
                            Iterator<GeneData> iterator = ((Gene)e1).getDataMap().get(0).iterator();
                            if (iterator.hasNext()) {
                                GeneData geneData = iterator.next();
                                return this.compare(geneData, ((Gene)e2).getDataMap().get(0).get(i++));
                            }
                        }
                        if (!(e1 instanceof GeneData) || !(e2 instanceof GeneData)) break block15;
                        switch (column) {
                            case "Well": {
                                c = ((GeneData)e1).getPosition().getX().compareTo(((GeneData)e2).getPosition().getX());
                                if (c != 0) break;
                                c = ((GeneData)e1).getPosition().getY().compareTo(((GeneData)e2).getPosition().getY());
                                break;
                            }
                            case "ct0": {
                                c = ((GeneData)e1).getCt().compareTo(((GeneData)e2).getCt());
                                if (c != 0) break;
                                c = ((GeneData)e1).getGene().getGeneIdentifier().compareTo(((GeneData)e2).getGene().getGeneIdentifier());
                                break;
                            }
                            case "2^-ct": {
                                c = ((GeneData)e1).get2PowCt().compareTo(((GeneData)e2).get2PowCt());
                                if (c != 0) break;
                                c = ((GeneData)e1).getGene().getGeneIdentifier().compareTo(((GeneData)e2).getGene().getGeneIdentifier());
                            }
                        }
                    }
                    return c;
                }
            };
            ArrayList<Comparator> comparators = new ArrayList<Comparator>();
            comparators.add(ownComparator);
            return comparators;
        }
        if (columnName.equals("Normalized") || columnName.equals("Norm Value") || columnName.equals("Adjusted") || columnName.equals("Scaler")) {
            ArrayList<Comparator> comparators = new ArrayList<Comparator>();
            comparators.add((Comparator)new NullComparator());
            return comparators;
        }
        return super.getComparatorsForColumnIndex(columnIndex);
    }
}

