/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.qrtpcr.dialogs.CustomSelectionDialogWithDescription;
import org.grits.toolbox.entry.qrtpcr.editor.MergeReportEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class GeneSelectionDialog
extends TitleAreaDialog {
    MergeReportEditor editor;
    private Text pathwayText;
    private Button btnBrowse;
    private Button btnSelectBasedOn;
    protected static Logger logger = Logger.getLogger(GeneSelectionDialog.class);

    public GeneSelectionDialog(Shell parentShell, MergeReportEditor mergeReportEditor) {
        super(parentShell);
        this.editor = mergeReportEditor;
    }

    public void create() {
        super.create();
        this.setTitle("Gene Selection");
        this.setMessage("Please choose one of the following");
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        control.setLayout((Layout)new GridLayout(3, false));
        new Label(control, 0);
        new Label(control, 0);
        final Button btnSelectAll = new Button(control, 16);
        btnSelectAll.setText("Select All");
        btnSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (btnSelectAll.getSelection()) {
                    GeneSelectionDialog.this.btnSelectBasedOn.setSelection(false);
                    GeneSelectionDialog.this.editor.selectAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(control, 0);
        new Label(control, 0);
        this.btnSelectBasedOn = new Button(control, 16);
        this.btnSelectBasedOn.setText("Select based on a Pathway");
        this.btnSelectBasedOn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneSelectionDialog.this.btnSelectBasedOn.getSelection()) {
                    GeneSelectionDialog.this.btnBrowse.setSelection(true);
                    btnSelectAll.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pathwayText = new Text(control, 2048);
        this.pathwayText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowse = new Button(control, 0);
        this.btnBrowse.setText("Browse");
        this.btnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneList inputList;
                GeneSelectionDialog.this.btnSelectBasedOn.setSelection(true);
                btnSelectAll.setSelection(false);
                GeneSelectionDialog.this.editor.clearSelection();
                List<Object> input = new ArrayList();
                try {
                    input = FileUtils.getAllGeneLists(true);
                }
                catch (Exception ex) {
                    logger.warn((Object)" Cannot load the gene lists! ", (Throwable)ex);
                }
                CustomSelectionDialogWithDescription dialog = new CustomSelectionDialogWithDescription(Display.getCurrent().getActiveShell(), true, GeneSelectionDialog.this.pathwayText, input);
                dialog.initializeGeneListSelectionDialog();
                if (dialog.open() == 0 && (inputList = (GeneList)dialog.getSelection()) != null && inputList.getGenes() != null) {
                    GeneSelectionDialog.this.editor.setGeneList(inputList);
                    for (Gene gene : inputList.getGenes()) {
                        GeneSelectionDialog.this.editor.selectGene(gene);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneList inputList;
                GeneSelectionDialog.this.btnSelectBasedOn.setSelection(true);
                List<Object> input = new ArrayList();
                try {
                    input = FileUtils.getAllGeneLists(true);
                }
                catch (Exception ex) {
                    logger.warn((Object)" Cannot load the gene lists! ", (Throwable)ex);
                }
                CustomSelectionDialogWithDescription dialog = new CustomSelectionDialogWithDescription(Display.getCurrent().getActiveShell(), true, GeneSelectionDialog.this.pathwayText, input);
                dialog.initializeGeneListSelectionDialog();
                if (dialog.open() == 0 && (inputList = (GeneList)dialog.getSelection()) != null && inputList.getGenes() != null) {
                    GeneSelectionDialog.this.editor.setGeneList(inputList);
                    for (Gene gene : inputList.getGenes()) {
                        GeneSelectionDialog.this.editor.selectGene(gene);
                    }
                }
            }
        });
        return control;
    }

    protected boolean checkInList(String geneIdentifier, GeneList inputList) {
        for (Gene gene : inputList.getGenes()) {
            if (!gene.getGeneIdentifier().equals(geneIdentifier)) continue;
            return true;
        }
        return false;
    }
}

