/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.HashSet;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class Modification
extends WURCSComponent {
    private String m_strMAPCode;

    public Modification(String MAPCode) {
        this.m_strMAPCode = MAPCode;
    }

    public String getMAPCode() {
        return this.m_strMAPCode;
    }

    private LinkedList<LinkedList<String>> parseMAPToAtoms() {
        LinkedList<String> t_aAtoms = new LinkedList<String>();
        LinkedList<String> t_aPrevAtoms = new LinkedList<String>();
        String t_strPrevAtom = null;
        for (int i = 0; i < this.m_strMAPCode.length(); ++i) {
            char t_cNext;
            char t_cNext2;
            char t_cX = this.m_strMAPCode.charAt(i);
            if (t_cX == '(' || t_cX == ')' || t_cX == '=' || t_cX == '#') continue;
            if (t_cX == '^') {
                ++i;
                continue;
            }
            String t_strPos = "";
            while (i + 1 < this.m_strMAPCode.length() && Character.isDigit(t_cNext2 = this.m_strMAPCode.charAt(i + 1))) {
                t_strPos = t_strPos + t_cNext2;
                ++i;
            }
            String t_strAtom = "" + t_cX;
            if (t_cX == '*') {
                t_strAtom = t_strAtom + t_strPos;
            } else if (!t_strPos.equals("")) {
                int t_iPos = Integer.valueOf(t_strPos);
                String t_strTargetAtom = (String)t_aAtoms.get(t_iPos - 1);
                if (t_cX == '/') {
                    t_strPrevAtom = t_strTargetAtom;
                    continue;
                }
                if (t_cX == '$') {
                    t_strAtom = t_strTargetAtom;
                }
            } else if (i + 1 < this.m_strMAPCode.length() && Character.isLowerCase(t_cNext = this.m_strMAPCode.charAt(i + 1))) {
                t_strAtom = t_strAtom + t_cNext;
            }
            t_aPrevAtoms.addLast(t_strPrevAtom);
            t_aAtoms.addLast(t_strAtom);
            t_strPrevAtom = t_strAtom;
        }
        LinkedList<LinkedList<String>> t_aaAtomMap = new LinkedList<LinkedList<String>>();
        t_aaAtomMap.addLast(t_aAtoms);
        t_aaAtomMap.addLast(t_aPrevAtoms);
        return t_aaAtomMap;
    }

    @Deprecated
    public String getAtomConnectedBackboneCarbon(int a_iCarbonID) {
        LinkedList<LinkedList<String>> t_aaAtomMap;
        LinkedList<String> t_aParsedAtoms;
        int t_iAtomPos;
        String t_strCarbon = "*";
        if (a_iCarbonID != 0) {
            t_strCarbon = t_strCarbon + a_iCarbonID;
        }
        if ((t_iAtomPos = (t_aParsedAtoms = (t_aaAtomMap = this.parseMAPToAtoms()).get(0)).indexOf(t_strCarbon)) == 0) {
            return t_aParsedAtoms.get(1);
        }
        LinkedList<String> t_aPrevAtoms = t_aaAtomMap.get(1);
        return t_aPrevAtoms.get(t_iAtomPos);
    }

    public boolean isAglycone() {
        if (this.getEdges().isEmpty()) {
            return false;
        }
        for (WURCSEdge edge : this.getEdges()) {
            if (edge.getLinkages().size() == 1 && edge.getBackbone().getAnomericPosition() == edge.getLinkages().getFirst().getBackbonePosition()) continue;
            return false;
        }
        return true;
    }

    public boolean isGlycosidic() {
        LinkedList<WURCSEdge> edges = this.getEdges();
        if (edges.isEmpty() || edges.size() == 1) {
            return false;
        }
        HashSet<Backbone> uniqBackbones = new HashSet<Backbone>();
        for (WURCSEdge edge : edges) {
            uniqBackbones.add(edge.getBackbone());
            if (uniqBackbones.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isRing() {
        if (this.isGlycosidic()) {
            return false;
        }
        LinkedList<WURCSEdge> edges = this.getEdges();
        if (edges.size() != 2) {
            return false;
        }
        if (!this.canOmitMAP()) {
            return false;
        }
        Backbone t_oBackbone = edges.getFirst().getBackbone();
        int t_iAnomPos = t_oBackbone.getAnomericPosition();
        if (t_iAnomPos == 0 || t_iAnomPos == -1) {
            return false;
        }
        int t_nConnAnom = 0;
        for (WURCSEdge edge : edges) {
            if (edge.getLinkages().getFirst().getBackbonePosition() != t_iAnomPos) continue;
            ++t_nConnAnom;
        }
        return t_nConnAnom == true;
    }

    public boolean canOmitMAP() {
        if (this.m_strMAPCode.equals("")) {
            return true;
        }
        if (!this.getEdges().isEmpty() && (this.m_strMAPCode.equals("*O") || this.m_strMAPCode.equals("*=O"))) {
            WURCSEdge edge = this.getEdges().getFirst();
            Backbone t_oBackbone = edge.getBackbone();
            int pos = edge.getLinkages().getFirst().getBackbonePosition() - 1;
            if (t_oBackbone.getBackboneCarbons().get(pos).getDescriptor().getChar() == 'A') {
                return false;
            }
        }
        return this.m_strMAPCode.equals("*O") || this.m_strMAPCode.equals("*=O") || this.m_strMAPCode.equals("*O*");
    }

    public boolean hasBackboneCarbonOrder() {
        return this.m_strMAPCode.contains("*1");
    }

    @Override
    public Modification copy() {
        return new Modification(this.m_strMAPCode);
    }

    @Override
    public void accept(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        a_objVisitor.visit(this);
    }
}

