/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.Ion;
import org.grits.toolbox.ms.om.data.IonAdduct;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;
import org.grits.toolbox.tools.gsl.structure.IonCombination;

public class IonCombinationGenerator {
    private List<IonSettings> m_lISAdducts;
    private Integer m_nMaxIonCount;
    private List<IonSettings> m_lISExchanges;
    private Integer m_nMaxIonExchangeCount;
    private List<MoleculeSettings> m_lMSLoss;
    private List<IonCombination> m_lPositiveIonCombinations;
    private List<IonCombination> m_lNegativeIonCombinations;
    private List<IonCombination> m_lIonCombinations;
    private List<Map<Molecule, Integer>> m_lMolToNumbers;

    public IonCombinationGenerator(Method a_method) {
        this.m_lISAdducts = a_method.getIons();
        for (IonSettings t_isAdduct : this.m_lISAdducts) {
            this.fillLackingIonCounts(t_isAdduct);
        }
        this.m_nMaxIonCount = a_method.getMaxIonCount();
        if (this.m_nMaxIonCount == null) {
            this.m_nMaxIonCount = -1;
        }
        this.m_lISExchanges = a_method.getIonExchanges();
        for (IonSettings t_isExchange : this.m_lISExchanges) {
            this.fillLackingIonCounts(t_isExchange);
        }
        this.m_nMaxIonExchangeCount = a_method.getMaxIonExchangeCount();
        if (this.m_nMaxIonExchangeCount == null) {
            this.m_nMaxIonExchangeCount = -1;
        }
        this.m_lMSLoss = a_method.getNeutralLoss();
        this.m_lIonCombinations = null;
    }

    public IonCombinationGenerator(IonCombination a_ionCombination) {
        int i;
        ArrayList<Integer> t_lIonCount;
        IonSettings t_ionSettings;
        this.m_lISAdducts = new ArrayList<IonSettings>();
        for (IonAdduct t_ion : a_ionCombination.getIonAdducts()) {
            t_ionSettings = new IonSettings();
            t_ionSettings.setCharge(t_ion.getCharge());
            t_ionSettings.setLabel(t_ion.getLabel());
            t_ionSettings.setMass(t_ion.getMass());
            t_ionSettings.setName(t_ion.getName());
            t_ionSettings.setPolarity(t_ion.getPolarity());
            t_lIonCount = new ArrayList<Integer>();
            i = 1;
            while (i <= t_ion.getCount()) {
                t_lIonCount.add(i);
                ++i;
            }
            t_ionSettings.setCounts(t_lIonCount);
            this.m_lISAdducts.add(t_ionSettings);
        }
        this.m_nMaxIonCount = -1;
        this.m_lISExchanges = new ArrayList<IonSettings>();
        for (IonAdduct t_ion : a_ionCombination.getIonExchanges()) {
            t_ionSettings = new IonSettings();
            t_ionSettings.setCharge(t_ion.getCharge());
            t_ionSettings.setLabel(t_ion.getLabel());
            t_ionSettings.setMass(t_ion.getMass());
            t_ionSettings.setName(t_ion.getName());
            t_ionSettings.setPolarity(t_ion.getPolarity());
            t_lIonCount = new ArrayList();
            i = 1;
            while (i <= t_ion.getCount()) {
                t_lIonCount.add(i);
                ++i;
            }
            t_ionSettings.setCounts(t_lIonCount);
            this.m_lISExchanges.add(t_ionSettings);
        }
        this.m_nMaxIonExchangeCount = -1;
        this.m_lMSLoss = new ArrayList<MoleculeSettings>();
        for (MoleculeSettings t_mol : a_ionCombination.getNeutralLosses()) {
            MoleculeSettings t_molSettings = new MoleculeSettings();
            t_molSettings.setLabel(t_mol.getLabel());
            t_molSettings.setMass(t_mol.getMass());
            t_molSettings.setName(t_mol.getName());
            t_molSettings.setCount(t_mol.getCount());
            this.m_lMSLoss.add(t_molSettings);
        }
        this.m_nMaxIonExchangeCount = -1;
        this.m_lIonCombinations = null;
    }

    public List<IonCombination> getPossibleIonCombinations() {
        return this.m_lIonCombinations;
    }

    public List<IonCombination> getPositiveIonCombinations() {
        return this.m_lPositiveIonCombinations;
    }

    public List<IonCombination> getNegativeIonCombinations() {
        return this.m_lNegativeIonCombinations;
    }

    private void fillLackingIonCounts(IonSettings a_is) {
        if (a_is == null || a_is.getCounts() == null || a_is.getCounts().isEmpty()) {
            return;
        }
        if (a_is.getCounts().size() > 1) {
            return;
        }
        if ((Integer)a_is.getCounts().get(0) == 1) {
            return;
        }
        ArrayList<Integer> t_lFilledIonCounts = new ArrayList<Integer>();
        int i = 1;
        while (i <= (Integer)a_is.getCounts().get(0)) {
            t_lFilledIonCounts.add(i);
            ++i;
        }
        a_is.setCounts(t_lFilledIonCounts);
    }

    public void generate() {
        this.m_lPositiveIonCombinations = this.generate(true);
        this.m_lNegativeIonCombinations = this.generate(false);
        this.m_lIonCombinations = new ArrayList<IonCombination>();
        this.m_lIonCombinations.addAll(this.m_lPositiveIonCombinations);
        this.m_lIonCombinations.addAll(this.m_lNegativeIonCombinations);
    }

    public List<IonCombination> generate(boolean polarity) {
        IonCombination t_ionComb2;
        List<IonCombination> t_lIonCombinations2;
        ArrayList<IonCombination> t_lIonCombinations = new ArrayList<IonCombination>();
        List<Map<Molecule, Integer>> t_lAdductIonToNumbers = this.generatePossibleIonCombinations(this.m_lISAdducts, this.m_nMaxIonCount, false);
        for (Map<Molecule, Integer> t_mapAdductIonToNum : t_lAdductIonToNumbers) {
            IonCombination t_ionComb = new IonCombination();
            boolean t_bHasOppositePolarity = false;
            for (Molecule t_ion : t_mapAdductIonToNum.keySet()) {
                if (((Ion)t_ion).getPolarity() != polarity) {
                    t_bHasOppositePolarity = true;
                    break;
                }
                t_ionComb.addIonAdduct((Ion)t_ion, t_mapAdductIonToNum.get(t_ion));
            }
            if (t_bHasOppositePolarity) continue;
            t_lIonCombinations.add(t_ionComb);
        }
        if (t_lIonCombinations.isEmpty()) {
            return t_lIonCombinations;
        }
        if (this.m_lISExchanges != null && !this.m_lISExchanges.isEmpty()) {
            t_lIonCombinations2 = new ArrayList<IonCombination>();
            List<Map<Molecule, Integer>> t_lExchangeIonToNumbers = this.generatePossibleIonCombinations(this.m_lISExchanges, this.m_nMaxIonExchangeCount, true);
            for (Map<Molecule, Integer> t_mapExchangeIonToNum : t_lExchangeIonToNumbers) {
                for (IonCombination t_ionComb : t_lIonCombinations) {
                    t_ionComb2 = t_ionComb.copy();
                    for (Molecule t_ion : t_mapExchangeIonToNum.keySet()) {
                        t_ionComb2.addIonExchange((Ion)t_ion, t_mapExchangeIonToNum.get(t_ion));
                        t_lIonCombinations2.add(t_ionComb2);
                    }
                }
            }
            t_lIonCombinations2 = this.moveIonExchangeToIonAdduct(t_lIonCombinations2);
            for (IonCombination t_ionCombo : t_lIonCombinations2) {
                if (t_lIonCombinations.contains(t_ionCombo)) continue;
                t_lIonCombinations.add(t_ionCombo);
            }
        }
        if (this.m_lMSLoss != null && !this.m_lMSLoss.isEmpty()) {
            t_lIonCombinations2 = new ArrayList();
            List<Map<Molecule, Integer>> t_lNeutralLossToNumbers = this.generatePossibleMoleculeCombination(this.m_lMSLoss);
            for (Map<Molecule, Integer> t_mapNeutralLossToNum : t_lNeutralLossToNumbers) {
                for (IonCombination t_ionComb : t_lIonCombinations) {
                    t_ionComb2 = t_ionComb.copy();
                    for (Molecule t_mol : t_mapNeutralLossToNum.keySet()) {
                        MoleculeSettings t_molLoss = new MoleculeSettings();
                        t_molLoss.setLabel(t_mol.getLabel());
                        t_molLoss.setMass(t_mol.getMass());
                        t_molLoss.setName(t_mol.getName());
                        t_molLoss.setCount(t_mapNeutralLossToNum.get(t_mol));
                        t_ionComb2.addNeutralLoss(t_molLoss);
                        t_lIonCombinations2.add(t_ionComb2);
                    }
                }
            }
            t_lIonCombinations.addAll(t_lIonCombinations2);
        }
        return t_lIonCombinations;
    }

    private List<IonCombination> moveIonExchangeToIonAdduct(List<IonCombination> a_ionCombos) {
        ArrayList<IonCombination> t_lIonComboToBeRemoved = new ArrayList<IonCombination>();
        ArrayList<IonCombination> t_lIonComboToBeAdded = new ArrayList<IonCombination>();
        for (IonCombination t_ionCombo : a_ionCombos) {
            int t_nHydrogen = 0;
            for (IonAdduct t_ionAdduct : t_ionCombo.getIonAdducts()) {
                if (!this.isAdductHydrogen(t_ionAdduct)) continue;
                t_nHydrogen += t_ionAdduct.getCount().intValue();
            }
            if (t_nHydrogen == 0) continue;
            int t_nExchange = 0;
            for (IonAdduct t_ionExchange : t_ionCombo.getIonExchanges()) {
                t_nExchange += t_ionExchange.getCount().intValue();
            }
            if (t_nExchange == 0) continue;
            t_lIonComboToBeRemoved.add(t_ionCombo);
            IonCombination t_ionComboNew = new IonCombination();
            for (IonAdduct t_ionAdduct : t_ionCombo.getIonAdducts()) {
                if (!this.isAdductHydrogen(t_ionAdduct)) {
                    t_ionComboNew.addIonAdduct((Ion)t_ionAdduct, t_ionAdduct.getCount());
                    continue;
                }
                if (t_nHydrogen <= t_nExchange) continue;
                t_ionComboNew.addIonAdduct((Ion)t_ionAdduct, t_ionAdduct.getCount() - t_nExchange);
            }
            ArrayList<int[]> t_lCountCombos = new ArrayList<int[]>();
            if (t_nHydrogen < t_nExchange) {
                ArrayList<int[]> t_lCountCombosNew;
                t_lCountCombos.add(new int[t_ionCombo.getIonExchanges().size()]);
                int i = 0;
                while (i < t_ionCombo.getIonExchanges().size()) {
                    t_lCountCombosNew = new ArrayList<int[]>();
                    for (int[] t_lCountCombo : t_lCountCombos) {
                        int t_nCount = t_ionCombo.getIonExchanges().get(i).getCount();
                        int j = 0;
                        while (j <= t_nCount) {
                            int[] t_lCountComboNew = new int[t_ionCombo.getIonExchanges().size()];
                            int k = 0;
                            while (k < i) {
                                t_lCountComboNew[k] = t_lCountCombo[k];
                                ++k;
                            }
                            t_lCountComboNew[i] = j++;
                            t_lCountCombosNew.add(t_lCountComboNew);
                        }
                    }
                    t_lCountCombos = t_lCountCombosNew;
                    ++i;
                }
                int t_nTotalRemovedHs = t_nExchange - t_nHydrogen;
                t_lCountCombosNew = new ArrayList();
                for (int[] t_lCountCombo : t_lCountCombos) {
                    int t_nTotalCount = 0;
                    int i2 = 0;
                    while (i2 < t_lCountCombo.length) {
                        t_nTotalCount += t_lCountCombo[i2];
                        ++i2;
                    }
                    if (t_nTotalCount != t_nTotalRemovedHs) continue;
                    t_lCountCombosNew.add(t_lCountCombo);
                }
                t_lCountCombos = t_lCountCombosNew;
            } else {
                int[] t_lCountCombo = new int[t_ionCombo.getIonExchanges().size()];
                int i = 0;
                while (i < t_ionCombo.getIonExchanges().size()) {
                    t_lCountCombo[i] = 0;
                    ++i;
                }
                t_lCountCombos.add(t_lCountCombo);
            }
            for (int[] t_lCountCombo : t_lCountCombos) {
                IonCombination t_ionComboCopy = t_ionComboNew.copy();
                int i = 0;
                while (i < t_ionCombo.getIonExchanges().size()) {
                    int t_nMovedIons;
                    IonAdduct t_ionExchange = t_ionCombo.getIonExchanges().get(i);
                    if (t_lCountCombo[i] > 0) {
                        t_ionComboCopy.addIonExchange((Ion)t_ionExchange, t_lCountCombo[i]);
                    }
                    if ((t_nMovedIons = t_ionExchange.getCount() - t_lCountCombo[i]) != 0) {
                        boolean t_bIsExistSameIon = false;
                        for (IonAdduct t_ionAdduct : t_ionComboCopy.getIonAdducts()) {
                            if (!this.isSameIon((Ion)t_ionAdduct, (Ion)t_ionExchange)) continue;
                            t_bIsExistSameIon = true;
                            t_ionAdduct.setCount(Integer.valueOf(t_ionAdduct.getCount() + t_nMovedIons));
                        }
                        if (!t_bIsExistSameIon) {
                            t_ionComboCopy.addIonAdduct((Ion)t_ionExchange, t_nMovedIons);
                        }
                    }
                    ++i;
                }
                if (t_lIonComboToBeAdded.contains(t_ionComboCopy)) continue;
                t_lIonComboToBeAdded.add(t_ionComboCopy);
            }
        }
        ArrayList<IonCombination> t_lIonCombosNew = new ArrayList<IonCombination>();
        for (IonCombination t_ionCombo : a_ionCombos) {
            if (t_lIonComboToBeRemoved.contains(t_ionCombo)) continue;
            t_lIonCombosNew.add(t_ionCombo);
        }
        t_lIonCombosNew.addAll(t_lIonComboToBeAdded);
        return t_lIonCombosNew;
    }

    private boolean isAdductHydrogen(IonAdduct a_ionAdduct) {
        return a_ionAdduct.getLabel().equals("H") && a_ionAdduct.getMass() == 1.007825032;
    }

    private boolean isSameIon(Ion a_ion1, Ion a_ion2) {
        return a_ion1.getLabel().equals(a_ion2.getLabel()) && a_ion1.getName().equals(a_ion2.getName()) && a_ion1.getMass().equals(a_ion2.getMass()) && a_ion1.getCharge().equals(a_ion2.getCharge()) && a_ion1.getPolarity().equals(a_ion2.getPolarity());
    }

    private List<Map<Molecule, Integer>> generatePossibleMoleculeCombination(List<MoleculeSettings> a_lMols) {
        this.m_lMolToNumbers = new ArrayList<Map<Molecule, Integer>>();
        ArrayList<Molecule> t_lSearchedMols = new ArrayList<Molecule>();
        for (MoleculeSettings t_mol : a_lMols) {
            int i = 0;
            while (i < t_mol.getCount()) {
                HashMap<Molecule, Integer> t_mapMolToNum = new HashMap<Molecule, Integer>();
                t_mapMolToNum.put((Molecule)t_mol, i + 1);
                this.searchPossibleMoleculeCombination(t_mapMolToNum, t_lSearchedMols, a_lMols);
                ++i;
            }
            t_lSearchedMols.add((Molecule)t_mol);
        }
        return this.m_lMolToNumbers;
    }

    private void searchPossibleMoleculeCombination(Map<Molecule, Integer> a_mapMolToNumber, List<Molecule> a_lSearchedMols, List<MoleculeSettings> a_lMols) {
        if (this.isNewMoleculeCombination(a_mapMolToNumber)) {
            HashMap<Molecule, Integer> t_mapCopy = new HashMap<Molecule, Integer>();
            for (Molecule t_mol : a_mapMolToNumber.keySet()) {
                t_mapCopy.put(t_mol, a_mapMolToNumber.get(t_mol));
            }
            this.m_lMolToNumbers.add(t_mapCopy);
        }
        for (MoleculeSettings t_mol : a_lMols) {
            if (a_lSearchedMols.contains(t_mol) || a_mapMolToNumber.containsKey(t_mol)) continue;
            int i = 0;
            while (i < t_mol.getCount()) {
                a_mapMolToNumber.put((Molecule)t_mol, i + 1);
                this.searchPossibleMoleculeCombination(a_mapMolToNumber, a_lSearchedMols, a_lMols);
                a_mapMolToNumber.remove(t_mol, i + 1);
                ++i;
            }
        }
    }

    private List<Map<Molecule, Integer>> generatePossibleIonCombinations(List<IonSettings> a_lIons, int a_nMaxIonCnt, boolean a_bIsExchange) {
        this.m_lMolToNumbers = new ArrayList<Map<Molecule, Integer>>();
        ArrayList<Ion> t_lSearchedIons = new ArrayList<Ion>();
        for (IonSettings t_ion : a_lIons) {
            Iterator iterator = t_ion.getCounts().iterator();
            while (iterator.hasNext()) {
                int t_nIon = (Integer)iterator.next();
                HashMap<Ion, Integer> t_mapIonToNum = new HashMap<Ion, Integer>();
                t_mapIonToNum.put((Ion)t_ion, t_nIon);
                this.searchPossibleIonCombination(t_mapIonToNum, t_lSearchedIons, a_lIons, a_nMaxIonCnt, a_bIsExchange);
            }
            t_lSearchedIons.add((Ion)t_ion);
        }
        return this.m_lMolToNumbers;
    }

    private void searchPossibleIonCombination(Map<Ion, Integer> a_mapIonToNumber, List<Ion> a_lSearchedIons, List<IonSettings> a_lIons, int a_nMaxIonCnt, boolean a_bIsExchange) {
        if (a_nMaxIonCnt != -1) {
            int t_nCurIonCount = 0;
            for (Ion t_ion : a_mapIonToNumber.keySet()) {
                t_nCurIonCount += a_mapIonToNumber.get(t_ion) * (a_bIsExchange ? 1 : t_ion.getCharge());
            }
            if (t_nCurIonCount > a_nMaxIonCnt) {
                return;
            }
        }
        if (this.isNewIonCombination(a_mapIonToNumber)) {
            HashMap<Ion, Integer> t_mapCopy = new HashMap<Ion, Integer>();
            for (Ion t_ion : a_mapIonToNumber.keySet()) {
                t_mapCopy.put(t_ion, a_mapIonToNumber.get(t_ion));
            }
            this.m_lMolToNumbers.add(t_mapCopy);
        }
        for (IonSettings t_ion : a_lIons) {
            if (a_lSearchedIons.contains(t_ion) || a_mapIonToNumber.containsKey(t_ion)) continue;
            Iterator iterator = t_ion.getCounts().iterator();
            while (iterator.hasNext()) {
                int t_nIon = (Integer)iterator.next();
                a_mapIonToNumber.put((Ion)t_ion, t_nIon);
                this.searchPossibleIonCombination(a_mapIonToNumber, a_lSearchedIons, a_lIons, a_nMaxIonCnt, a_bIsExchange);
                a_mapIonToNumber.remove(t_ion, t_nIon);
            }
        }
    }

    private boolean isNewIonCombination(Map<Ion, Integer> a_mapIonToNumber) {
        HashMap<Molecule, Integer> t_mapMolToNumber = new HashMap<Molecule, Integer>();
        for (Ion t_ion : a_mapIonToNumber.keySet()) {
            t_mapMolToNumber.put((Molecule)t_ion, a_mapIonToNumber.get(t_ion));
        }
        return this.isNewMoleculeCombination(t_mapMolToNumber);
    }

    private boolean isNewMoleculeCombination(Map<Molecule, Integer> a_mapMolToNumber) {
        for (Map<Molecule, Integer> t_mapIonToNumberStored : this.m_lMolToNumbers) {
            if (!this.compareCombination(t_mapIonToNumberStored, a_mapMolToNumber)) continue;
            return false;
        }
        return true;
    }

    private boolean compareCombination(Map<Molecule, Integer> a_map1, Map<Molecule, Integer> a_map2) {
        if (a_map1.keySet().size() != a_map2.keySet().size()) {
            return false;
        }
        for (Molecule t_mol1 : a_map1.keySet()) {
            if (!a_map2.keySet().contains(t_mol1)) {
                return false;
            }
            int t_nMol1 = a_map1.get(t_mol1);
            for (Molecule t_mol2 : a_map2.keySet()) {
                int t_nMol2;
                if (!t_mol1.equals((Object)t_mol2) || t_nMol1 == (t_nMol2 = a_map2.get(t_mol2).intValue())) continue;
                return false;
            }
        }
        return true;
    }

    public static IonCombination getSingleIonCombo(Ion a_ion, int a_nIon) {
        IonCombination t_ionCombo = new IonCombination();
        t_ionCombo.addIonAdduct(a_ion, a_nIon);
        return t_ionCombo;
    }

    public static IonCombination getHydrogenIon() {
        return IonCombinationGenerator.getSingleIonCombo(GlycanPreDefinedOptions.ION_ADDUCT_HYDROGEN, 1);
    }
}

