/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.commands;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;

public class ResizeAllNodesCommand
extends Command {
    private final ExperimentGraph parent;
    HashMap<GraphNode, Dimension> sizeMap;

    public ResizeAllNodesCommand(ExperimentGraph graph) {
        this.parent = graph;
    }

    public boolean canExecute() {
        return this.parent != null;
    }

    public void execute() {
        this.sizeMap = new HashMap();
        for (GraphNode node : this.parent.getNodes()) {
            Dimension current = node.getSize();
            this.sizeMap.put(node, current);
        }
        this.redo();
    }

    public void redo() {
        Dimension maxSize = new Dimension(0, 0);
        for (GraphNode node : this.parent.getNodes()) {
            Dimension current = node.getSize();
            if (current.getArea() <= maxSize.getArea()) continue;
            maxSize = current;
        }
        for (GraphNode node : this.parent.getNodes()) {
            node.setSize(maxSize);
        }
    }

    public void undo() {
        if (this.sizeMap != null) {
            for (GraphNode node : this.parent.getNodes()) {
                Dimension oldSize = this.sizeMap.get(node);
                if (oldSize == null) continue;
                node.setSize(oldSize);
            }
        }
    }
}

