/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterCateogoryPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.FileUtils;
import org.grits.toolbox.util.structure.glycan.filter.om.Category;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;

public class MSGlycanAnnotationFilterPreferencePage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationFilterPreferencePage.class);
    MSGlycanFilterCateogoryPreference categoryPreference;
    private ComboViewer categoryCombo;
    List<Category> categories = new ArrayList<Category>();

    public MSGlycanAnnotationFilterPreferencePage() {
        this.loadFilterCategories();
        this.loadCategoryPreference();
    }

    private void loadFilterCategories() {
        try {
            FiltersLibrary filterLibrary = FileUtils.readFilters(FileUtils.getFilterPath());
            this.categories = filterLibrary.getCategories();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot locate the filters file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Error loading the filters", (Throwable)e);
        }
    }

    private void loadCategoryPreference() {
        try {
            this.categoryPreference = MSGlycanFilterCateogoryPreference.getMSGlycanFilterCategoryPreferences(MSGlycanFilterCateogoryPreference.getPreferenceEntity());
        }
        catch (Exception e) {
            logger.error((Object)"Cannot get filter category preference", (Throwable)e);
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Filter Category Preference");
        this.categoryCombo = new ComboViewer(container, 8);
        this.categoryCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.categoryCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "All";
                }
                if (element instanceof Category) {
                    return ((Category)element).getLabel();
                }
                return null;
            }
        });
        this.categoryCombo.setInput(this.categories);
        this.categoryCombo.insert(null, 0);
        if (this.categoryPreference != null) {
            Category current = this.categoryPreference.getCategoryPreference();
            if (current == null) {
                this.categoryCombo.getCombo().select(0);
            } else {
                int i = 1;
                for (Category c : this.categories) {
                    if (c.getLabel().equals(current.getLabel())) {
                        this.categoryCombo.getCombo().select(i);
                    }
                    ++i;
                }
            }
        }
        this.categoryCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index = MSGlycanAnnotationFilterPreferencePage.this.categoryCombo.getCombo().getSelectionIndex();
                if (index > 0) {
                    IStructuredSelection selected = MSGlycanAnnotationFilterPreferencePage.this.categoryCombo.getStructuredSelection();
                    MSGlycanAnnotationFilterPreferencePage.this.categoryPreference.setCategoryPreference((Category)selected.getFirstElement());
                } else {
                    MSGlycanAnnotationFilterPreferencePage.this.categoryPreference.setCategoryPreference(null);
                }
            }
        });
        return container;
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    private void save() {
        try {
            logger.debug((Object)"Time to save values!");
            this.categoryPreference.saveValues();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

