/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.om.io.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.IntensityFilter;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.data.ScansAnnotation;
import org.grits.toolbox.ms.om.io.xml.AnnotationObjectCache;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class AnnotationReader {
    private static final Logger logger = Logger.getLogger(AnnotationReader.class);
    public static final Class[] filterClassContext = new Class[]{IntensityFilter.class};

    public ScanFeatures readScanAnnotation(String fileName, int scanId) {
        try {
            String sTempFile;
            File fData;
            File fArchive = new File(fileName);
            if (!fArchive.exists()) {
                throw new IOException("Can't find archive: " + fileName);
            }
            String sArchive = fArchive.getName();
            int dotInx = sArchive.lastIndexOf(".");
            String sTempFolder = AnnotationObjectCache.getTempPath(fArchive.getParent(), sArchive.substring(0, dotInx));
            String sXMLFile = scanId + ".xml";
            ScanFeatures scanFeatures = (ScanFeatures)AnnotationObjectCache.getObject(sXMLFile, fData = new File(sTempFile = sTempFolder + File.separator + sXMLFile));
            if (scanFeatures == null) {
                File fldr = new File(sTempFolder);
                if (!fldr.exists()) {
                    fldr.mkdirs();
                    fldr.deleteOnExit();
                }
                fData = this.extractXMLFile(fileName, sTempFolder, sXMLFile);
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(ScanFeatures.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                scanFeatures = (ScanFeatures)jaxbUnmarshaller.unmarshal(fData);
                AnnotationObjectCache.cacheObject(sXMLFile, fData, scanFeatures);
                fData.deleteOnExit();
            }
            return scanFeatures;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in AnnotationReader:readScanAnnotation.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File extractXMLFile(String sourceFilePath, String targetFilePath, String targetFileName) throws IOException {
        byte[] buffer = new byte[2048];
        FileInputStream theFile = new FileInputStream(sourceFilePath);
        ZipInputStream stream = new ZipInputStream(theFile);
        File outputFile = null;
        try {
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                block11: {
                    if (!entry.getName().trim().equalsIgnoreCase(targetFileName)) continue;
                    String outpath = targetFilePath + File.separator + entry.getName();
                    FileOutputStream output = null;
                    try {
                        outputFile = new File(outpath);
                        output = new FileOutputStream(outputFile);
                        int len = 0;
                        while ((len = stream.read(buffer)) > 0) {
                            output.write(buffer, 0, len);
                        }
                        if (output == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            output.close();
                        }
                        File file = outputFile;
                        stream.close();
                        if (outputFile == null) {
                            return null;
                        }
                        return outputFile;
                    }
                    output.close();
                }
                File file = outputFile;
                return file;
            }
            {
                catch (Throwable throwable) {}
            }
        }
        finally {
            stream.close();
            if (outputFile == null) {
                return null;
            }
            return outputFile;
        }
    }

    public Data readDataWithoutFeatures(String fileName) {
        try {
            DataHeader dataHeader;
            File fArchive = new File(fileName);
            if (!fArchive.exists()) {
                throw new IOException("Can't find archive: " + fileName);
            }
            String sArchive = fArchive.getName();
            int dotInx = sArchive.lastIndexOf(".");
            String sTempFolder = AnnotationObjectCache.getTempPath(fArchive.getParent(), sArchive.substring(0, dotInx));
            String sTempFile = sTempFolder + File.separator + "data.xml";
            File fData = new File(sTempFile);
            Data data = (Data)AnnotationObjectCache.getObject("data.xml", fData);
            if (data == null) {
                File fldr = new File(sTempFolder);
                if (!fldr.exists()) {
                    fldr.mkdirs();
                    fldr.deleteOnExit();
                }
                fData = this.extractXMLFile(fileName, sTempFolder, "data.xml");
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(Data.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                data = (Data)jaxbUnmarshaller.unmarshal(fData);
                AnnotationObjectCache.cacheObject("data.xml", fData, data);
                fData.deleteOnExit();
            }
            if ((dataHeader = this.readDataHeader(fileName)) == null) {
                throw new Exception("DataHeader object is null!");
            }
            data.setDataHeader(dataHeader);
            Method method = this.readMethod(fileName);
            dataHeader.setMethod(method);
            return data;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in AnnotationReader:readDataWithoutFeatures.", (Throwable)e);
            return null;
        }
    }

    public Data readData(String fileName) {
        try {
            File fArchive = new File(fileName);
            if (!fArchive.exists()) {
                throw new IOException("Can't find archive: " + fileName);
            }
            String sArchive = fArchive.getName();
            int dotInx = sArchive.lastIndexOf(".");
            String sTempFolder = AnnotationObjectCache.getTempPath(fArchive.getParent(), sArchive.substring(0, dotInx));
            String sTempFile = sTempFolder + File.separator + "data.xml";
            File fData = new File(sTempFile);
            Data data = (Data)AnnotationObjectCache.getObject("data.xml", fData);
            if (data == null) {
                File fldr = new File(sTempFolder);
                if (!fldr.exists()) {
                    fldr.mkdirs();
                    fldr.deleteOnExit();
                }
                fData = this.extractXMLFile(fileName, sTempFolder, "data.xml");
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(Data.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                data = (Data)jaxbUnmarshaller.unmarshal(fData);
                AnnotationObjectCache.cacheObject("data.xml", fData, data);
                fData.deleteOnExit();
            }
            return data;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in AnnotationReader:readDataWithoutFeatures.", (Throwable)e);
            return null;
        }
    }

    public Method readMethod(String filePath) {
        try {
            File fArchive = new File(filePath);
            if (!fArchive.exists()) {
                throw new IOException("Can't find archive: " + filePath);
            }
            String sArchive = fArchive.getName();
            int dotInx = sArchive.lastIndexOf(".");
            String sTempFolder = AnnotationObjectCache.getTempPath(fArchive.getParent(), sArchive.substring(0, dotInx));
            String sTempFile = sTempFolder + File.separator + "settings.xml";
            File fData = new File(sTempFile);
            Method method = (Method)AnnotationObjectCache.getObject("settings.xml", fData);
            if (method == null) {
                File fldr = new File(sTempFolder);
                if (!fldr.exists()) {
                    fldr.mkdirs();
                    fldr.deleteOnExit();
                }
                fData = this.extractXMLFile(filePath, sTempFolder, "settings.xml");
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(Method.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                method = (Method)jaxbUnmarshaller.unmarshal(fData);
                AnnotationObjectCache.cacheObject("settings.xml", fData, method);
                fData.deleteOnExit();
            }
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in AnnotationReader:readMethod.", (Throwable)e);
            return null;
        }
    }

    public DataHeader readDataHeader(String filePath) {
        try {
            File fArchive = new File(filePath);
            if (!fArchive.exists()) {
                throw new IOException("Can't find archive: " + filePath);
            }
            String sArchive = fArchive.getName();
            int dotInx = sArchive.lastIndexOf(".");
            String sTempFolder = AnnotationObjectCache.getTempPath(fArchive.getParent(), sArchive.substring(0, dotInx));
            String sTempFile = sTempFolder + File.separator + "dataHeader.xml";
            File fData = new File(sTempFile);
            DataHeader dataHeader = (DataHeader)AnnotationObjectCache.getObject("dataHeader.xml", fData);
            if (dataHeader == null) {
                File fldr = new File(sTempFolder);
                if (!fldr.exists()) {
                    fldr.mkdirs();
                    fldr.deleteOnExit();
                }
                fData = this.extractXMLFile(filePath, sTempFolder, "dataHeader.xml");
                ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
                contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
                contextList.add(FilterSetting.class);
                contextList.add(DataHeader.class);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                dataHeader = (DataHeader)jaxbUnmarshaller.unmarshal(fData);
                AnnotationObjectCache.cacheObject("dataHeader.xml", fData, dataHeader);
                fData.deleteOnExit();
            }
            return dataHeader;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in AnnotationReader:readDataHeader.", (Throwable)e);
            return null;
        }
    }

    public ScansAnnotation readAnnotation(String filePath, String annId, Class<?> destClass) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{destClass});
            ScansAnnotation annotations = null;
            File f = new File(filePath + File.separator + annId + ".xml");
            if (f != null && f.exists()) {
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                annotations = (ScansAnnotation)jaxbUnmarshaller.unmarshal(f);
                return annotations;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

