/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.input;

import com.csvreader.CsvWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class CSVWriter {
    public void writeCSV(Scan scan) {
        try {
            CsvWriter writer = null;
            if (scan.getMsLevel() == 1) {
                File file = new File("./scans/" + scan.getScanNo() + ".csv");
                file.createNewFile();
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                for (Peak peak : scan.getPeaklist()) {
                    String[] peaks = new String[]{"" + peak.getMz(), "NA"};
                    bw.write(peak.getMz() + "," + peak.getIntensity() + "\n");
                }
                bw.close();
            } else {
                writer = new CsvWriter("./scans/" + scan.getScanNo() + ".csv");
                for (Peak peak : scan.getPeaklist()) {
                    String[] peaks = new String[]{"" + peak.getMz(), "" + peak.getIntensity()};
                    writer.writeRecord(peaks);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

