/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.processDialog;

import org.apache.log4j.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.widgets.processDialog.ProgressBarWithErrorListener;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.processDialog.TextProgressBar;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressHandler;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class GRITSProgressDialog
extends Dialog
implements IProgressHandler,
IProgressThreadHandler {
    private static final Logger logger = Logger.getLogger(ProgressDialog.class);
    protected TextProgressBar pbMajor;
    protected ProgressBarWithErrorListener pblMajor;
    protected GRITSWorker gritsWorker = null;
    protected TextProgressBar[] pbMinorDeterminants = null;
    protected TextProgressBar[] pbMinorIndeterminants = null;
    protected ProgressBarWithErrorListener[] pblMinors = null;
    protected Composite[] minorContainers = null;
    protected StackLayout[] slMinorLayouts = null;
    protected CancelableThread cpMinorThread = null;
    protected Text errorTextBox;
    protected int iNumMinors = 0;
    protected boolean bUseError;
    protected boolean cancelable = true;
    protected Button cancelButton;
    protected Composite cancelComposite;
    protected Shell shell;
    protected Display display = null;
    protected int iMinorStatus = 0;
    protected int iMajorStatus = 0;

    public GRITSProgressDialog(Shell _shell, int _iNumMinors, boolean _bUseError) {
        super(_shell);
        this.iNumMinors = _iNumMinors;
        if (this.iNumMinors > 0) {
            this.pbMinorDeterminants = new TextProgressBar[this.iNumMinors];
            this.pbMinorIndeterminants = new TextProgressBar[this.iNumMinors];
            this.pblMinors = new ProgressBarWithErrorListener[this.iNumMinors];
            this.minorContainers = new Composite[this.iNumMinors];
            this.slMinorLayouts = new StackLayout[this.iNumMinors];
        }
        this.bUseError = _bUseError;
    }

    public GRITSProgressDialog(Shell _shell, int _iNumMinors, boolean _bUseError, boolean cancelable) {
        this(_shell, _iNumMinors, _bUseError);
        this.cancelable = cancelable;
    }

    public void setGritsWorker(GRITSWorker gritsWorker) {
        this.gritsWorker = gritsWorker;
    }

    public boolean isFinished() {
        boolean bFinished = this.iMajorStatus != 0;
        return bFinished;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public ProgressBarWithErrorListener[] getMinorProgressBarListeners() {
        return this.pblMinors;
    }

    public ProgressBarWithErrorListener getMinorProgressBarListener(int _iInx) {
        return this.pblMinors[_iInx];
    }

    public ProgressBarWithErrorListener getMajorProgressBarListener() {
        return this.pblMajor;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void open() {
        this.createContents();
        Monitor primary = this.shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.open();
        this.shell.layout();
    }

    public int startWorker() {
        this.gritsWorker.addProgressListeners((IProgressListener)this.getMajorProgressBarListener());
        int iRes = this.gritsWorker.doWork();
        this.setMajorStatus(iRes);
        Display display = this.getParent().getDisplay();
        while (!(this.isCanceled() || this.isFinished() || this.shell.isDisposed())) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        this.finish();
        return iRes;
    }

    public boolean isCanceled() {
        return this.getMajorStatus() == 256;
    }

    public void cancelThread() {
        this.iMajorStatus = 256;
        this.iMinorStatus = 256;
        if (this.cpMinorThread != null) {
            this.cpMinorThread.cancelWork();
        }
    }

    protected void createContents() {
        this.shell = ProgressDialog.getModalDialog(this.getParent());
        this.display = this.shell.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setText("Progress Dialog");
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 2, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.pbMajor = new TextProgressBar((Composite)this.shell, 65792);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 500;
        this.pbMajor.setLayoutData(gd);
        int i = 0;
        while (i < this.iNumMinors) {
            this.minorContainers[i] = new Composite((Composite)this.shell, 0);
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 2;
            this.minorContainers[i].setLayoutData((Object)gd2);
            this.slMinorLayouts[i] = new StackLayout();
            this.minorContainers[i].setLayout((Layout)this.slMinorLayouts[i]);
            this.pbMinorDeterminants[i] = new TextProgressBar(this.minorContainers[i], 65792);
            this.slMinorLayouts[i].topControl = this.pbMinorDeterminants[i];
            this.pbMinorIndeterminants[i] = new TextProgressBar(this.minorContainers[i], 258);
            this.pbMinorIndeterminants[i].setVisible(false);
            ++i;
        }
        this.cancelComposite = new Composite((Composite)this.shell, 0);
        this.cancelComposite.setLayoutData((Object)new GridData(4, 2, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.cancelComposite.setLayout((Layout)gridLayout_1);
        if (this.bUseError) {
            GridData errorTextBoxGD = new GridData();
            errorTextBoxGD.minimumHeight = 100;
            errorTextBoxGD.grabExcessHorizontalSpace = true;
            errorTextBoxGD.grabExcessVerticalSpace = true;
            errorTextBoxGD.horizontalAlignment = 4;
            errorTextBoxGD.horizontalSpan = 2;
            errorTextBoxGD.heightHint = 100;
            this.errorTextBox = new Text(this.cancelComposite, 2816);
            this.errorTextBox.setLayoutData((Object)errorTextBoxGD);
            this.errorTextBox.setEditable(false);
        }
        if (this.cancelable) {
            this.cancelButton = new Button(this.cancelComposite, 0);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GRITSProgressDialog.this.cancelThread();
                }
            });
            this.cancelButton.setLayoutData((Object)new GridData(78, -1));
            this.cancelButton.setText("Cancel");
        }
        this.pblMajor = new ProgressBarWithErrorListener(this.pbMajor, this.errorTextBox, this.display);
        int i2 = 0;
        while (i2 < this.iNumMinors) {
            this.pblMinors[i2] = new ProgressBarWithErrorListener(this.pbMinorDeterminants[i2], this.pbMinorIndeterminants[i2], IProgressListener.ProgressType.Determinant, this.slMinorLayouts[i2], this.errorTextBox, this.display, this.shell);
            ++i2;
        }
        this.shell.pack();
        this.shell.setSize(500, this.shell.getBounds().height);
    }

    public void setErrorText(final String a_message) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer();
                if (GRITSProgressDialog.this.errorTextBox.getText().equals("")) {
                    sb.append(a_message);
                } else {
                    sb.append(GRITSProgressDialog.this.errorTextBox.getText());
                    sb.append("\r\n");
                    sb.append(a_message);
                }
                GRITSProgressDialog.this.errorTextBox.setText(sb.toString());
                GRITSProgressDialog.this.errorTextBox.setSelection(GRITSProgressDialog.this.errorTextBox.getCharCount());
            }
        });
    }

    public boolean hasError() {
        if (this.errorTextBox == null || this.errorTextBox.isDisposed()) {
            return false;
        }
        return !this.errorTextBox.getText().equals("");
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setMajorStatus(int iStatus) {
        this.iMajorStatus = iStatus;
    }

    public int getMajorStatus() {
        return this.iMajorStatus;
    }

    public void setMinorStatus(int iStatus) {
        this.iMinorStatus = iStatus;
    }

    public int getMinorStatus() {
        return this.iMinorStatus;
    }

    public void threadFinished(boolean successful) {
        logger.debug((Object)("Thread finished. Successful: " + successful + ", is finished? " + this.isFinished()));
        if (this.isCanceled()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    GRITSProgressDialog.this.close();
                }
            });
        }
    }

    public void endWithException(final Exception e) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                logger.error((Object)e.getMessage(), (Throwable)e);
                GRITSProgressDialog.this.setMajorStatus(1);
                GRITSProgressDialog.this.setMinorStatus(1);
                GRITSProgressDialog.this.close();
            }
        });
    }

    protected void finish() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (GRITSProgressDialog.this.cancelable) {
                    GRITSProgressDialog.this.cancelButton.setText("Finish");
                    GRITSProgressDialog.this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            GRITSProgressDialog.this.setMajorStatus(32);
                            GRITSProgressDialog.this.setMinorStatus(32);
                            GRITSProgressDialog.this.close();
                        }
                    });
                } else {
                    GRITSProgressDialog.this.setMajorStatus(32);
                    GRITSProgressDialog.this.setMinorStatus(32);
                    GRITSProgressDialog.this.close();
                }
                if (!GRITSProgressDialog.this.bUseError || GRITSProgressDialog.this.errorTextBox.getText().equals("")) {
                    GRITSProgressDialog.this.setMajorStatus(32);
                    GRITSProgressDialog.this.setMinorStatus(32);
                    GRITSProgressDialog.this.close();
                }
            }
        });
    }

    public void setThread(CancelableThread _progressThread) {
        this.cpMinorThread = _progressThread;
    }

    protected void close() {
        if (!this.shell.isDisposed()) {
            this.shell.close();
        }
    }
}

