/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.widgets.heatmap.clustering.ClusterComponent;
import org.grits.toolbox.widgets.heatmap.clustering.VCoord;

public class DendrogramPanel
extends Figure {
    private Cluster model;
    private ClusterComponent component;
    private Color lineColor = Display.getCurrent().getSystemColor(2);
    private boolean showDistanceValues = false;
    private boolean showScale = false;
    private int margin = 10;
    private int borderTop = 2;
    private int borderLeft = 2;
    private int borderRight = 2;
    private int borderBottom = 2;
    private int scalePadding = 10;
    private int scaleTickLength = 4;
    private double scaleValueInterval = 0.0;
    private int scaleValueDecimals = 0;
    private double xModelOrigin = 0.0;
    private double yModelOrigin = 0.0;
    private double wModel = 0.0;
    private double hModel = 0.0;
    boolean horizontal = false;
    boolean primarySide = true;
    private Font labelFont;

    public DendrogramPanel() {
        Font sysFont = Display.getCurrent().getSystemFont();
        this.labelFont = XYGraphMediaFactory.getInstance().getFont(new FontData(sysFont.getFontData()[0].getName(), 8, 0));
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public void setPrimarySide(boolean primarySide) {
        this.primarySide = primarySide;
        if (this.component != null && this.model != null) {
            this.component = this.createComponent(this.model);
            this.updateModelMetrics();
        }
    }

    public boolean isPrimarySide() {
        return this.primarySide;
    }

    public boolean isShowDistanceValues() {
        return this.showDistanceValues;
    }

    public void setShowDistances(boolean showDistanceValues) {
        this.showDistanceValues = showDistanceValues;
    }

    public boolean isShowScale() {
        return this.showScale;
    }

    public void setShowScale(boolean showScale) {
        this.showScale = showScale;
    }

    public int getScalePadding() {
        return this.scalePadding;
    }

    public void setScalePadding(int scalePadding) {
        this.scalePadding = scalePadding;
    }

    public int getScaleTickLength() {
        return this.scaleTickLength;
    }

    public void setScaleTickLength(int scaleTickLength) {
        this.scaleTickLength = scaleTickLength;
    }

    public double getScaleValueInterval() {
        return this.scaleValueInterval;
    }

    public void setScaleValueInterval(double scaleTickInterval) {
        this.scaleValueInterval = scaleTickInterval;
    }

    public int getScaleValueDecimals() {
        return this.scaleValueDecimals;
    }

    public void setScaleValueDecimals(int scaleValueDecimals) {
        this.scaleValueDecimals = scaleValueDecimals;
    }

    public int getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(int borderTop) {
        this.borderTop = borderTop;
    }

    public int getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(int borderLeft) {
        this.borderLeft = borderLeft;
    }

    public int getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(int borderRight) {
        this.borderRight = borderRight;
    }

    public int getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(int borderBottom) {
        this.borderBottom = borderBottom;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Cluster getModel() {
        return this.model;
    }

    public void setModel(Cluster model) {
        this.model = model;
        this.component = this.createComponent(model);
        this.updateModelMetrics();
    }

    private void updateModelMetrics() {
        double minX = this.component.getRectMinX();
        double maxX = this.component.getRectMaxX();
        double minY = this.component.getRectMinY();
        double maxY = this.component.getRectMaxY();
        this.xModelOrigin = minX;
        this.yModelOrigin = minY;
        this.wModel = maxX - minX;
        this.hModel = maxY - minY;
    }

    private ClusterComponent createComponent(Cluster cluster, VCoord initCoord, double clusterHeight, double clusterWidth) {
        ClusterComponent comp;
        block10: {
            comp = null;
            if (cluster == null) break block10;
            comp = new ClusterComponent(cluster, cluster.isLeaf(), initCoord);
            if (!this.horizontal) {
                if (this.primarySide) {
                    double leafHeight = clusterHeight / (double)cluster.countLeafs();
                    double yChild = initCoord.getY() - clusterHeight / 2.0;
                    double distance = cluster.getDistanceValue() == null ? 0.0 : cluster.getDistanceValue();
                    for (Cluster child : cluster.getChildren()) {
                        int childLeafCount = child.countLeafs();
                        double childHeight = (double)childLeafCount * leafHeight;
                        double childDistance = child.getDistanceValue() == null ? 0.0 : child.getDistanceValue();
                        VCoord childInitCoord = new VCoord(initCoord.getX() + (distance - childDistance), yChild + childHeight / 2.0);
                        yChild += childHeight;
                        ClusterComponent childComp = this.createComponent(child, childInitCoord, childHeight, clusterWidth);
                        childComp.setLinkPoint(initCoord);
                        comp.getChildren().add(childComp);
                    }
                } else {
                    double leafHeight = clusterHeight / (double)cluster.countLeafs();
                    double yChild = initCoord.getY() - clusterHeight / 2.0;
                    double distance = cluster.getDistanceValue() == null ? 0.0 : cluster.getDistanceValue();
                    for (Cluster child : cluster.getChildren()) {
                        int childLeafCount = child.countLeafs();
                        double childHeight = (double)childLeafCount * leafHeight;
                        double childDistance = child.getDistanceValue() == null ? 0.0 : child.getDistanceValue();
                        VCoord childInitCoord = new VCoord(initCoord.getX() - (distance - childDistance), yChild + childHeight / 2.0);
                        yChild += childHeight;
                        ClusterComponent childComp = this.createComponent(child, childInitCoord, childHeight, clusterWidth);
                        childComp.setLinkPoint(initCoord);
                        comp.getChildren().add(childComp);
                    }
                }
            } else if (this.primarySide) {
                double leafWidth = clusterWidth / (double)cluster.countLeafs();
                double xChild = initCoord.getX() - clusterWidth / 2.0;
                double distance = cluster.getDistanceValue() == null ? 0.0 : cluster.getDistanceValue();
                for (Cluster child : cluster.getChildren()) {
                    int childLeafCount = child.countLeafs();
                    double childWidth = (double)childLeafCount * leafWidth;
                    double childDistance = child.getDistanceValue() == null ? 0.0 : child.getDistanceValue();
                    VCoord childInitCoord = new VCoord(xChild + childWidth / 2.0, initCoord.getY() + (distance - childDistance));
                    xChild += childWidth;
                    ClusterComponent childComp = this.createComponent(child, childInitCoord, clusterHeight, childWidth);
                    childComp.setLinkPoint(initCoord);
                    comp.getChildren().add(childComp);
                }
            } else {
                double leafWidth = clusterWidth / (double)cluster.countLeafs();
                double xChild = initCoord.getX() - clusterWidth / 2.0;
                double distance = cluster.getDistanceValue() == null ? 0.0 : cluster.getDistanceValue();
                for (Cluster child : cluster.getChildren()) {
                    int childLeafCount = child.countLeafs();
                    double childWidth = (double)childLeafCount * leafWidth;
                    double childDistance = child.getDistanceValue() == null ? 0.0 : child.getDistanceValue();
                    VCoord childInitCoord = new VCoord(xChild + childWidth / 2.0, initCoord.getY() - (distance - childDistance));
                    xChild += childWidth;
                    ClusterComponent childComp = this.createComponent(child, childInitCoord, clusterHeight, childWidth);
                    childComp.setLinkPoint(initCoord);
                    comp.getChildren().add(childComp);
                }
            }
        }
        return comp;
    }

    private ClusterComponent createComponent(Cluster model) {
        if (!this.horizontal) {
            VCoord initCoord = null;
            double virtualModelHeight = 1.0;
            double virtualModelWidth = 1.0;
            initCoord = this.primarySide ? new VCoord(0.0, virtualModelHeight / 2.0) : new VCoord(1.0, virtualModelHeight / 2.0);
            ClusterComponent comp = this.createComponent(model, initCoord, virtualModelWidth, virtualModelHeight);
            comp.setLinkPoint(initCoord);
            return comp;
        }
        double virtualModelWidth = 1.0;
        double virtualModelHeight = 1.0;
        VCoord initCoord = null;
        initCoord = this.primarySide ? new VCoord(0.0, virtualModelWidth / 2.0) : new VCoord(virtualModelHeight, virtualModelWidth / 2.0);
        ClusterComponent comp = this.createComponent(model, initCoord, virtualModelWidth, virtualModelHeight);
        comp.setLinkPoint(initCoord);
        return comp;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics g2 = g;
        g2.setAntialias(1);
        g2.setForegroundColor(this.lineColor);
        g2.setLineCap(3);
        g2.setLineJoin(2);
        int wDisplay = this.getWidth() - this.borderLeft - this.borderRight;
        int hDisplay = this.getHeight() - this.borderTop - this.borderBottom;
        int xDisplayOrigin = this.getClientArea().x + this.borderLeft;
        int yDisplayOrigin = this.getClientArea().y + this.borderBottom;
        if (this.component != null) {
            int nameGutterWidth = 0;
            double xFactor = (double)(wDisplay -= nameGutterWidth) / this.wModel;
            double yFactor = (double)hDisplay / this.hModel;
            int xOffset = (int)((double)xDisplayOrigin - this.xModelOrigin * xFactor);
            int yOffset = (int)((double)yDisplayOrigin - this.yModelOrigin * yFactor);
            this.component.paint(g2, xOffset, yOffset, xFactor, yFactor, this.showDistanceValues, this.horizontal, this.primarySide);
        } else {
            String str = "No data";
            Dimension rect = FigureUtilities.getTextExtents((String)str, (Font)this.labelFont);
            int xt = (int)((double)wDisplay / 2.0 - (double)rect.width / 2.0);
            int yt = (int)((double)hDisplay / 2.0 - (double)rect.height / 2.0);
            g2.drawString(str, xt, yt);
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = new Dimension(wHint, hHint);
        if (this.isVisible()) {
            if (this.isHorizontal()) {
                this.borderRight = this.borderLeft = wHint / DendrogramPanel.countLevels(this.model) / 2;
                int minHeight = this.model.countLeafs() * this.margin;
                double factor = hHint / minHeight;
                if (factor > 10.0) {
                    this.margin = (int)((double)this.margin + factor * 0.3);
                }
                size.height = this.model.countLeafs() * this.margin;
            } else {
                this.borderTop = this.borderBottom = hHint / this.model.countLeafs() / 2;
                int minWidth = DendrogramPanel.countLevels(this.model) * this.margin;
                double factor = wHint / minWidth;
                if (factor > 10.0) {
                    this.margin = (int)((double)this.margin + factor * 0.3);
                }
                size.width = DendrogramPanel.countLevels(this.model) * this.margin;
            }
        } else if (this.isHorizontal()) {
            size.height = 0;
        } else {
            size.width = 0;
        }
        return size;
    }

    private int getHeight() {
        return this.getClientArea().height;
    }

    private int getWidth() {
        return this.getClientArea().width;
    }

    private static int countLevels(Cluster node) {
        if (node == null) {
            return 0;
        }
        List children = node.getChildren();
        if (children.size() == 0) {
            return 1;
        }
        Cluster child0 = (Cluster)children.get(0);
        Cluster child1 = (Cluster)children.get(1);
        return 1 + Math.max(DendrogramPanel.countLevels(child0), DendrogramPanel.countLevels(child1));
    }

    public void recalculate(double t1, double t2) {
        this.component = this.createComponent(this.model);
        this.updateModelMetrics();
        this.revalidate();
        this.repaint();
    }
}

