/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.io.GlycoCT;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorToGlycoCT;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.validation.GlycoVisitorValidation;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph.SugarToWURCSGraph;
import org.glycoinfo.WURCSFramework.io.GlycoCT.GlycoVisitorValidationForWURCS;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSGraphExporterUniqueMonosaccharides;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSExporterGlycoCT {
    private String m_strGlycoCT = "";
    private String m_strWURCS = "";
    private boolean m_bResidueCodeCollection = false;
    private TreeSet<String> m_setResidueCodes = new TreeSet();
    private StringBuffer m_sbLog = new StringBuffer("");

    public void setResidueCodeCollection(boolean a_bCollection) {
        this.m_bResidueCodeCollection = a_bCollection;
    }

    public String getGlycoCT() {
        return this.m_strGlycoCT;
    }

    public String getWURCS() {
        return this.m_strWURCS;
    }

    public boolean doesCollectResidueCodes() {
        return this.m_bResidueCodeCollection;
    }

    public TreeSet<String> getUniqueResidueCodes() {
        return this.m_setResidueCodes;
    }

    public StringBuffer getValidationErrorLog() {
        return this.m_sbLog;
    }

    public void start(String a_strGlycoCT) throws SugarImporterException, GlycoVisitorException, WURCSException {
        this.m_strGlycoCT = a_strGlycoCT;
        SugarImporterGlycoCTCondensed t_objImporterGlycoCT = new SugarImporterGlycoCTCondensed();
        SugarToWURCSGraph t_objExporterWURCSGraph = new SugarToWURCSGraph();
        Sugar t_oSugar = t_objImporterGlycoCT.parse(this.m_strGlycoCT);
        this.validate(t_oSugar);
        t_oSugar = this.normalize(t_oSugar);
        t_objExporterWURCSGraph.start(t_oSugar);
        SugarToWURCSGraph t_oS2G = new SugarToWURCSGraph();
        t_oS2G.start(t_oSugar);
        WURCSGraph t_oGraph = t_oS2G.getGraph();
        WURCSFactory t_oFactory = new WURCSFactory(t_oGraph);
        this.m_strWURCS = t_oFactory.getWURCS();
        if (!this.m_bResidueCodeCollection) {
            return;
        }
        WURCSGraphExporterUniqueMonosaccharides t_oExportMS = new WURCSGraphExporterUniqueMonosaccharides();
        t_oExportMS.start(t_oFactory.getGraph());
        for (String t_strUniqueMS : t_oExportMS.getMSStrings()) {
            if (this.m_setResidueCodes.contains(t_strUniqueMS)) continue;
            this.m_setResidueCodes.add(t_strUniqueMS);
        }
    }

    private void validate(Sugar a_objSugar) throws GlycoVisitorException {
        GlycoVisitorValidation t_validation = new GlycoVisitorValidation();
        t_validation.start(a_objSugar);
        ArrayList t_aErrorStrings = t_validation.getErrors();
        ArrayList t_aWarningStrings = t_validation.getWarnings();
        while (t_aErrorStrings.contains("Sugar has more than one root residue.")) {
            t_aErrorStrings.remove(t_aErrorStrings.indexOf("Sugar has more than one root residue."));
        }
        GlycoVisitorValidationForWURCS t_validationWURCS = new GlycoVisitorValidationForWURCS();
        t_validationWURCS.start(a_objSugar);
        t_aErrorStrings.addAll(t_validationWURCS.getErrors());
        t_aWarningStrings.addAll(t_validationWURCS.getWarnings());
        if (!t_aErrorStrings.isEmpty()) {
            this.m_sbLog.append("Errors:\n");
        }
        for (String err : t_aErrorStrings) {
            this.m_sbLog.append(err + "\n");
        }
        if (!t_aWarningStrings.isEmpty()) {
            this.m_sbLog.append("Warnings:\n");
        }
        for (String warn : t_aWarningStrings) {
            this.m_sbLog.append(warn + "\n");
        }
        if (!t_aErrorStrings.isEmpty()) {
            throw new GlycoVisitorException("Error in GlycoCT validation.");
        }
    }

    private Sugar normalize(Sugar a_objSugar) throws GlycoVisitorException {
        GlycoVisitorToGlycoCT t_objTo = new GlycoVisitorToGlycoCT((MonosaccharideConversion)new MonosaccharideConverter(new Config()));
        t_objTo.start(a_objSugar);
        return t_objTo.getNormalizedSugar();
    }
}

