/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.similarity;

import java.util.ArrayList;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.ThreeLetterCodeConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameDictionary;
import org.glycoinfo.GlycanFormatconverter.util.comparater.EdgeComparator;

public class NodeSimilarity {
    public ArrayList<Node> sortAllNode(Node _root) {
        ArrayList<Node> ret = new ArrayList<Node>();
        return this.sortNotations(ret, _root);
    }

    private ArrayList<Node> sortNotations(ArrayList<Node> _notations, Node _node) {
        _notations.add(_node);
        for (Edge childEdge : this.sortPosition(_node.getChildEdges())) {
            Substituent sub;
            if (childEdge.getChild() == null || (sub = (Substituent)childEdge.getSubstituent()) != null && sub instanceof GlycanRepeatModification) continue;
            _notations = this.sortNotations(_notations, childEdge.getChild());
        }
        return _notations;
    }

    public ArrayList<Edge> sortChildSideEdges(Node _node) {
        ArrayList<Edge> picked = new ArrayList<Edge>();
        for (Edge edge : _node.getChildEdges()) {
            if (edge.isRepeat() || edge.isCyclic()) continue;
            picked.add(edge);
        }
        return this.sortPosition(picked);
    }

    public ArrayList<Edge> sortParentSideEdges(ArrayList<Edge> _edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        Edge cyclic = null;
        ArrayList<Edge> repeating = new ArrayList<Edge>();
        ArrayList<Edge> simple = new ArrayList<Edge>();
        for (Edge edge : _edges) {
            if (edge.isRepeat()) {
                repeating.add(edge);
                continue;
            }
            if (edge.isCyclic()) {
                cyclic = edge;
                continue;
            }
            simple.add(edge);
        }
        if (repeating != null) {
            ret.addAll(repeating);
        }
        if (cyclic != null) {
            ret.add(cyclic);
        }
        if (simple != null) {
            ret.addAll(simple);
        }
        if (ret.isEmpty()) {
            return _edges;
        }
        return ret;
    }

    public boolean isMainChaineBranch(Node _node) {
        if (_node.getParentEdges().isEmpty()) {
            return false;
        }
        if (this.isAlternativeLinkedForAcceptor(_node)) {
            return false;
        }
        Edge parentEdge = null;
        for (Edge edge : _node.getParentEdges()) {
            if (edge.isRepeat()) continue;
            parentEdge = edge;
        }
        if (parentEdge == null || parentEdge.getParent() == null) {
            return false;
        }
        if (!parentEdge.isReverseEdge()) {
            return false;
        }
        if (this.countChildren(parentEdge.getParent()) == 1) {
            return false;
        }
        ArrayList<Edge> childEdges = this.sortChildSideEdges(parentEdge.getParent());
        if (childEdges.size() == 1) {
            return false;
        }
        return childEdges.indexOf(parentEdge) != childEdges.size() - 1;
    }

    public int countChildren(Node _node) {
        int ret = 0;
        int cyclic = 0;
        Edge repeatEdge = null;
        for (Edge childEdge : this.sortEdge(_node)) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub != null && childEdge.getChild() == null) continue;
            if (childEdge.isRepeat()) {
                repeatEdge = childEdge;
                continue;
            }
            if (childEdge.isCyclic()) {
                ++cyclic;
                continue;
            }
            ++ret;
        }
        if (ret > 0) {
            ret += cyclic;
        }
        return ret;
    }

    private ArrayList<Edge> sortEdge(Node _node) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        if (_node.getChildEdges().isEmpty()) {
            return ret;
        }
        for (Edge childEdge : _node.getChildEdges()) {
            if (!childEdge.isRepeat()) continue;
            ret.add(childEdge);
        }
        for (Edge childEdge : _node.getChildEdges()) {
            if (ret.contains(childEdge)) continue;
            ret.add(childEdge);
        }
        return ret;
    }

    private ArrayList<Edge> sortPosition(ArrayList<Edge> _edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        ArrayList<Edge> copy = new ArrayList<Edge>();
        try {
            Object child = null;
            for (Edge childEdge : _edges) {
                if (childEdge.getChild() != null) {
                    if (child != null && child.equals(childEdge.getChild())) continue;
                    copy.add(childEdge);
                }
                if (child != null || childEdge.isRepeat()) continue;
                child = childEdge.getChild();
            }
            for (Edge childEdge : this.extractSticky(_edges)) {
                ret.add(childEdge);
                copy.remove(childEdge);
            }
            copy.sort(new EdgeComparator());
            ret.addAll(copy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private ArrayList<Edge> extractSticky(ArrayList<Edge> _edges) {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Edge unit : _edges) {
            Node child = unit.getChild();
            if (child == null) continue;
            try {
                Monosaccharide tempChild = ((Monosaccharide)child).copy();
                ThreeLetterCodeConverter threeCon = new ThreeLetterCodeConverter();
                threeCon.start(tempChild);
                if (tempChild.getStereos().isEmpty()) continue;
                if (threeCon.getDictionary() == null && tempChild.getStereos().get(0).contains("xyl")) {
                    ret.add(unit);
                }
                if (threeCon.getDictionary() == null || !threeCon.getDictionary().equals((Object)TrivialNameDictionary.FUC)) continue;
                ret.add(unit);
            }
            catch (GlycanException e) {
                e.printStackTrace();
            }
        }
        ret.sort(new EdgeComparator());
        return ret;
    }

    private boolean isAlternativeLinkedForAcceptor(Node _node) {
        if (_node instanceof Substituent) {
            return false;
        }
        Monosaccharide mono = (Monosaccharide)_node;
        boolean ret = false;
        Edge temp = null;
        for (Edge acceptor : mono.getParentEdges()) {
            if (acceptor.getSubstituent() != null && (acceptor.getSubstituent() instanceof GlycanRepeatModification || acceptor.getSubstituent() instanceof Substituent) || acceptor.getParent() == null) continue;
            if (temp == null) {
                temp = acceptor;
                continue;
            }
            ret = !temp.getParent().equals(acceptor.getParent());
        }
        return ret;
    }
}

