/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class ModAltToUndUnit {
    private ArrayList<ModificationAlternative> antennae = new ArrayList();
    private ArrayList<ModificationAlternative> undefinedLinkages = new ArrayList();
    private ArrayList<ModificationAlternative> undefinedSubstituents = new ArrayList();
    private GlyContainer glyCo;
    private HashMap<WURCSComponent, Node> backbone2Node;

    public ModAltToUndUnit(GlyContainer _glyco, HashMap<WURCSComponent, Node> _backbone2Node) {
        this.glyCo = _glyco;
        this.backbone2Node = _backbone2Node;
    }

    public GlyContainer getGlycan() {
        return this.glyCo;
    }

    public ArrayList<ModificationAlternative> getAntennae() {
        return this.antennae;
    }

    public ArrayList<ModificationAlternative> getUndefinedLinkages() {
        return this.undefinedLinkages;
    }

    public ArrayList<ModificationAlternative> getUndefinedSubstituents() {
        return this.undefinedSubstituents;
    }

    public void start(LinkedList<Backbone> _backbones) throws GlycanException, WURCSFormatException {
        for (Backbone bb : _backbones) {
            this.parseFragments(bb);
        }
        this.backboneToUndefinedUnit();
    }

    private void parseFragments(Backbone _backbone) throws GlycanException {
        if (_backbone.getChildEdges().isEmpty()) {
            return;
        }
        for (WURCSEdge cEdge : _backbone.getChildEdges()) {
            if (!(cEdge.getNextComponent() instanceof ModificationAlternative)) continue;
            ModificationAlternative modAlt = (ModificationAlternative)cEdge.getNextComponent();
            this.extractUndefinedLinkages(modAlt);
            this.extractUndefinedSubstituents(modAlt);
            if (this.undefinedLinkages.contains(modAlt) || this.undefinedSubstituents.contains(modAlt) || this.antennae.contains(modAlt)) continue;
            this.antennae.add(modAlt);
        }
    }

    private void extractUndefinedLinkages(ModificationAlternative t_modAlt) throws GlycanException {
        if (this.undefinedLinkages.contains(t_modAlt)) {
            return;
        }
        if (t_modAlt.getLeadInEdges().size() != t_modAlt.getLeadOutEdges().size()) {
            return;
        }
        LinkedList t_lInEdges = t_modAlt.getLeadInEdges();
        LinkedList t_lOutEdges = t_modAlt.getLeadOutEdges();
        WURCSEdgeComparator t_compEdges = new WURCSEdgeComparator();
        Collections.sort(t_lInEdges, t_compEdges);
        Collections.sort(t_lOutEdges, t_compEdges);
        int nEdges = t_lInEdges.size();
        for (int i = 0; i < nEdges; ++i) {
            WURCSEdge t_edgeOut;
            WURCSEdge t_edgeIn = (WURCSEdge)t_lInEdges.get(i);
            int t_iComp = t_compEdges.compare(t_edgeIn, t_edgeOut = (WURCSEdge)t_lOutEdges.get(i));
            if (t_iComp == 0) continue;
            return;
        }
        if (!t_modAlt.canOmitMAP()) {
            throw new GlycanException("Undefined linkage with substituent cannot be handled.");
        }
        this.undefinedLinkages.add(t_modAlt);
    }

    private void extractUndefinedSubstituents(ModificationAlternative t_modAlt) throws GlycanException {
        if (this.undefinedSubstituents.contains(t_modAlt)) {
            return;
        }
        if (t_modAlt.getLeadInEdges().isEmpty() || !t_modAlt.getLeadOutEdges().isEmpty()) {
            return;
        }
        if (t_modAlt.getMAPCode().isEmpty()) {
            return;
        }
        this.undefinedSubstituents.add(t_modAlt);
    }

    private void backboneToUndefinedUnit() throws GlycanException, WURCSFormatException {
        this.convertCompositon();
        this.convertMonosacchrideFragment();
        this.convertSubstituentFragment();
        if (this.glyCo.getUndefinedUnit().size() + this.glyCo.getUndefinedUnitsForSubstituent().size() != this.undefinedSubstituents.size() + this.undefinedLinkages.size() + this.antennae.size()) {
            throw new GlycanException("Parse fragment did not correctly performed.");
        }
    }

    private void convertCompositon() throws GlycanException {
        if (!this.getUndefinedLinkages().isEmpty()) {
            throw new GlycanException("Monosaccharide composition with linkages can not support.");
        }
        for (ModificationAlternative modComp : this.undefinedLinkages) {
            GlycanUndefinedUnit und = new GlycanUndefinedUnit();
            Backbone currentBackbone = null;
            WURCSEdge donorSideEdge = this.extractDonorSideWURCSEdge(modComp);
            for (WURCSEdge inEdge : modComp.getLeadInEdges()) {
                if (currentBackbone == null) {
                    currentBackbone = inEdge.getBackbone();
                    und.addNode(this.backbone2Node.get(inEdge.getBackbone()));
                }
                Node compNode = this.backbone2Node.get(currentBackbone);
                Edge edgeForOtherSide = this.parseLinkagePosition(inEdge, donorSideEdge, compNode);
                und.addConnection(edgeForOtherSide);
                und.setConnection(edgeForOtherSide);
                und.addParentNode(this.backbone2Node.get(inEdge.getBackbone()));
                compNode.addParentEdge(edgeForOtherSide);
            }
            this.glyCo.addGlycanUndefinedUnit(und);
        }
    }

    private void convertMonosacchrideFragment() throws GlycanException {
        for (ModificationAlternative modAltNode : this.antennae) {
            GlycanUndefinedUnit und = new GlycanUndefinedUnit();
            Node fragRoot = this.backbone2Node.get(this.extractWURCSEdge(modAltNode).getBackbone());
            WURCSEdge donorSideEdge = this.extractDonorSideWURCSEdge(modAltNode);
            for (WURCSEdge inEdge : modAltNode.getLeadInEdges()) {
                Edge edgeForAcceptor = this.parseLinkagePosition(inEdge, donorSideEdge, fragRoot);
                fragRoot.addParentEdge(edgeForAcceptor);
                und.addConnection(edgeForAcceptor);
                und.setConnection(edgeForAcceptor);
                und.addParentNode(this.backbone2Node.get(inEdge.getBackbone()));
            }
            und.addNode(fragRoot);
            this.glyCo.addGlycanUndefinedUnit(und);
        }
    }

    private void convertSubstituentFragment() throws GlycanException, WURCSFormatException {
        for (ModificationAlternative modAltSub : this.undefinedSubstituents) {
            GlycanUndefinedUnit und = new GlycanUndefinedUnit();
            Substituent fragRoot = SubstituentUtility.MAPToSubstituent((Modification)modAltSub);
            WURCSEdge donorSideEdge = this.extractDonorSideWURCSEdge(modAltSub);
            for (WURCSEdge inEdge : modAltSub.getLeadInEdges()) {
                Edge edgeForAcceptor = this.parseLinkagePosition(inEdge, donorSideEdge, fragRoot);
                fragRoot.addParentEdge(edgeForAcceptor);
                und.addConnection(edgeForAcceptor);
                und.setConnection(edgeForAcceptor);
                und.addParentNode(this.backbone2Node.get(inEdge.getBackbone()));
            }
            fragRoot.setFirstPosition(und.getConnection().getGlycosidicLinkages().get(0));
            und.addNode(fragRoot);
            this.glyCo.addGlycanUndefinedUnit(und);
        }
    }

    private Edge parseLinkagePosition(WURCSEdge _inEdge, WURCSEdge _donorEdge, Node _fragRoot) throws GlycanException {
        Edge ret = new Edge();
        Linkage linkage = new Linkage();
        ArrayList<Integer> acceptorPos = new ArrayList<Integer>();
        ArrayList<Integer> donorPos = new ArrayList<Integer>();
        for (LinkagePosition lp : _inEdge.getLinkages()) {
            acceptorPos.add(lp.getBackbonePosition());
            if (_fragRoot instanceof Substituent) {
                donorPos.add(lp.getModificationPosition());
            } else {
                donorPos.add(((LinkagePosition)_donorEdge.getLinkages().getFirst()).getBackbonePosition());
            }
            linkage.setParentLinkages(acceptorPos);
            linkage.setChildLinkages(donorPos);
            linkage.setProbabilityLower(1.0);
            linkage.setProbabilityUpper(1.0);
        }
        ret.addGlycosidicLinkage(linkage);
        if (_fragRoot instanceof Substituent) {
            ret.setSubstituent(_fragRoot);
        } else {
            ret.setChild(_fragRoot);
        }
        ret.setParent(this.backbone2Node.get(_inEdge.getBackbone()));
        return ret;
    }

    private WURCSEdge extractWURCSEdge(ModificationAlternative _modAlt) {
        WURCSEdge ret = null;
        for (WURCSEdge edge : _modAlt.getEdges()) {
            if (_modAlt.getLeadInEdges().contains(edge)) continue;
            ret = edge;
        }
        return ret;
    }

    private ArrayList<WURCSEdge> extractWURCSEdges(ModificationAlternative _modAlt) {
        ArrayList<WURCSEdge> ret = new ArrayList<WURCSEdge>();
        for (WURCSEdge edge : _modAlt.getEdges()) {
            if (_modAlt.getLeadInEdges().contains(edge)) continue;
            ret.add(edge);
        }
        return ret;
    }

    private WURCSEdge extractDonorSideWURCSEdge(ModificationAlternative _modAlt) {
        WURCSEdge ret = null;
        for (WURCSEdge wurcsEdge : _modAlt.getEdges()) {
            if (_modAlt.getLeadInEdges().contains(wurcsEdge)) continue;
            ret = wurcsEdge;
        }
        return ret;
    }
}

