/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.mycustom.handler;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.importer.ms.mycustom.wizard.MyNewMSWizard;
import org.grits.toolbox.importer.ms.wizard.NewMSWizard;

public class MyNewMSHandler {
    private static final Logger logger = Logger.getLogger(MyNewMSHandler.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") @Named(value="activeShell") Shell shell, EPartService partService) {
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.sample".equals(selectedEntry.getProperty().getType()))) {
            selectedEntry = null;
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.sample".equals(selectedEntry.getProperty().getType()))) {
            selectedEntry = null;
        }
        this.createNewMSDialog(shell, eventBroker, selectedEntry, partService);
        return null;
    }

    private void createNewMSDialog(Shell shell, IEventBroker eventBroker, Entry sample, EPartService partService) {
        block7: {
            MyNewMSWizard wizard = new MyNewMSWizard();
            wizard.setSample(sample);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            try {
                int iRes = dialog.open();
                if (iRes != 0) break block7;
                try {
                    Entry newMSEntry = wizard.getEntry();
                    if (newMSEntry == null) {
                        ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Unable to create the new MS entry.");
                        return;
                    }
                    gritsDataModelService.addEntry(wizard.getOne().getSampleEntry(), newMSEntry);
                    try {
                        ProjectFileHandler.saveProject((Entry)wizard.getOne().getSampleEntry().getParent());
                    }
                    catch (IOException e) {
                        logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                        logger.fatal((Object)("Closing project entry \"" + wizard.getOne().getSampleEntry().getParent().getDisplayName() + "\""));
                        gritsDataModelService.closeProject(wizard.getOne().getSampleEntry());
                        throw e;
                    }
                    eventBroker.send("grits_entry_selected", (Object)newMSEntry);
                    gritsUIService.setPartService(partService);
                    gritsUIService.openEntryInPart(newMSEntry);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Unable to create the new MS entry.", (Exception)ex);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Exception", (Exception)e);
            }
        }
    }

    public static String createMassSpecPath(Shell _shell, NewMSWizard _wizard) throws IOException {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        Entry projectEntry = DataModelSearch.findParentByType((Entry)_wizard.getOne().getSampleEntry(), (String)"org.grits.toolbox.property.project");
        String projectName = projectEntry.getDisplayName();
        File msFolder = new File(String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername());
        if (!msFolder.exists() && !msFolder.mkdir()) {
            IOException e = new IOException("Unable to create MS folder: (" + msFolder + ")");
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)_shell, (String)"Unable to create MS folder", (Exception)e);
            throw e;
        }
        return msFolder.getAbsolutePath();
    }
}

