/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassUtils;
import org.eurocarbdb.application.glycanbuilder.Molecule;
import org.eurocarbdb.util.Combinator;
import org.eurocarbdb.util.MutableInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IonCloud {
    protected TreeMap<String, Integer> ions = new TreeMap();
    protected TreeMap<String, Double> ionNameToChargeMass = new TreeMap();
    protected int ionsNum = 0;
    protected int ionsRelCount = 0;
    protected double ionsTotalMass = 0.0;

    public IonCloud() {
    }

    public IonCloud(String init) {
        this();
        try {
            this.initFromString(init);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof IonCloud)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public double computeMZ(double mass) {
        if (mass <= 0.0) {
            return mass;
        }
        if (this.ionsNum == 0) {
            return mass + this.ionsTotalMass;
        }
        return (mass + this.ionsTotalMass) / (double)this.ionsNum;
    }

    public double computeMass(double mz) {
        if (mz <= 0.0) {
            return mz;
        }
        if (this.ionsNum == 0) {
            return mz - this.ionsTotalMass;
        }
        return mz * (double)this.ionsNum - this.ionsTotalMass;
    }

    public boolean isRealistic() {
        for (Map.Entry<String, Integer> c : this.ions.entrySet()) {
            if (c.getKey().equals("H") || c.getValue() >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNegative() {
        return this.ionsRelCount < 0;
    }

    public int getNoCharges() {
        return Math.abs(this.ionsRelCount);
    }

    public boolean isUndetermined() {
        for (Map.Entry<String, Integer> c : this.ions.entrySet()) {
            if (c.getValue() != 999) continue;
            return true;
        }
        return false;
    }

    public IonCloud clone() {
        IonCloud ret = new IonCloud();
        for (Map.Entry<String, Integer> entry : this.ions.entrySet()) {
            ret.ions.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Number> entry : this.ionNameToChargeMass.entrySet()) {
            ret.ionNameToChargeMass.put(entry.getKey(), (Double)entry.getValue());
        }
        ret.ionsNum = this.ionsNum;
        ret.ionsRelCount = this.ionsRelCount;
        ret.ionsTotalMass = this.ionsTotalMass;
        return ret;
    }

    public void clear() {
        this.ions.clear();
        this.ionsNum = 0;
        this.ionsRelCount = 0;
        this.ionsTotalMass = 0.0;
    }

    public IonCloud and(IonCloud other) {
        IonCloud ret = this.clone();
        ret.add(other);
        return ret;
    }

    public void add(IonCloud other) {
        if (other == null) {
            return;
        }
        for (Map.Entry<String, Integer> c : other.ions.entrySet()) {
            this.add(c.getKey(), c.getValue());
        }
    }

    public IonCloud and(String charge) {
        return this.and(charge, 1);
    }

    public IonCloud and(String charge, int quantity) {
        if (charge.equals("H")) {
            return this.and(charge, MassUtils.h_ion.getMass(), quantity);
        }
        if (charge.equals("Li")) {
            return this.and(charge, MassUtils.li_ion.getMass(), quantity);
        }
        if (charge.equals("Na")) {
            return this.and(charge, MassUtils.na_ion.getMass(), quantity);
        }
        if (charge.equals("K")) {
            return this.and(charge, MassUtils.k_ion.getMass(), quantity);
        }
        if (charge.equals("Cl")) {
            return this.and(charge, MassUtils.cl_ion.getMass(), quantity);
        }
        if (charge.equals("H2PO4")) {
            return this.and(charge, MassUtils.h2po4_ion.getMass(), quantity);
        }
        return this.clone();
    }

    public void add(String charge, int quantity) {
        if (charge.equals("H")) {
            this.add(charge, MassUtils.h_ion.getMass(), quantity);
        } else if (charge.equals("Li")) {
            this.add(charge, MassUtils.li_ion.getMass(), quantity);
        } else if (charge.equals("Na")) {
            this.add(charge, MassUtils.na_ion.getMass(), quantity);
        } else if (charge.equals("K")) {
            this.add(charge, MassUtils.k_ion.getMass(), quantity);
        } else if (charge.equals("Cl")) {
            this.add(charge, MassUtils.cl_ion.getMass(), quantity);
        } else if (charge.equals("H2PO4")) {
            this.add(charge, MassUtils.h2po4_ion.getMass(), quantity);
        }
    }

    public void set(String charge, int quantity) {
        if (charge.equals("H")) {
            this.set(charge, MassUtils.h_ion.getMass(), quantity);
        } else if (charge.equals("Li")) {
            this.set(charge, MassUtils.li_ion.getMass(), quantity);
        } else if (charge.equals("Na")) {
            this.set(charge, MassUtils.na_ion.getMass(), quantity);
        } else if (charge.equals("K")) {
            this.set(charge, MassUtils.k_ion.getMass(), quantity);
        } else if (charge.equals("Cl")) {
            this.set(charge, MassUtils.cl_ion.getMass(), quantity);
        } else if (charge.equals("H2PO4")) {
            this.set(charge, MassUtils.h2po4_ion.getMass(), quantity);
        }
    }

    public IonCloud and(String charge_name, double charge_mass, int quantity) {
        IonCloud ret = this.clone();
        ret.add(charge_name, charge_mass, quantity);
        return ret;
    }

    public void add(String charge_name, double charge_mass, int quantity) {
        if (quantity == 0) {
            return;
        }
        if (this.ions.containsKey(charge_name)) {
            this.ions.put(charge_name, this.ions.get(charge_name) + quantity);
        } else {
            this.ions.put(charge_name, quantity);
        }
        if (this.ions.get(charge_name) == 0) {
            this.ions.remove(charge_name);
        }
        this.ionsRelCount += quantity;
        this.ionsNum = Math.abs(this.ionsRelCount);
        this.ionNameToChargeMass.put(charge_name, charge_mass);
        this.ionsTotalMass += (double)quantity * charge_mass;
    }

    public List<IonCloud> generateCombinations() {
        ArrayList<String> ionList = new ArrayList<String>();
        for (String chargeName : this.ions.keySet()) {
            int num = this.ions.get(chargeName);
            for (int i = 0; i < num; ++i) {
                ionList.add(chargeName);
            }
        }
        ArrayList<IonCloud> ionClouds = new ArrayList<IonCloud>();
        HashSet ionCombinationsList = Combinator.generate(ionList);
        for (List ionCloudContents : ionCombinationsList) {
            IonCloud ionCloud = new IonCloud();
            HashMap<String, MutableInteger> ionNameToQuantity = new HashMap<String, MutableInteger>();
            for (String ionName : ionCloudContents) {
                if (!ionNameToQuantity.containsKey(ionName)) {
                    ionNameToQuantity.put(ionName, new MutableInteger());
                }
                ++((MutableInteger)ionNameToQuantity.get((Object)ionName)).mutI;
            }
            for (String ionName : ionNameToQuantity.keySet()) {
                int quantity = ((MutableInteger)ionNameToQuantity.get((Object)ionName)).mutI;
                ionCloud.add(ionName, this.ionNameToChargeMass.get(ionName), quantity);
            }
            ionClouds.add(ionCloud);
        }
        return ionClouds;
    }

    public void set(String charge_name, double charge_mass, int quantity) {
        this.add(charge_name, charge_mass, -this.get(charge_name));
        this.add(charge_name, charge_mass, quantity);
    }

    public boolean set(IonCloud other, boolean skip_undetermined) {
        boolean changed = false;
        if (!skip_undetermined || other.get("H") != 999) {
            this.set("H", other.get("H"));
            changed = true;
        }
        if (!skip_undetermined || other.get("Na") != 999) {
            this.set("Na", other.get("Na"));
            changed = true;
        }
        if (!skip_undetermined || other.get("Li") != 999) {
            this.set("Li", other.get("Li"));
            changed = true;
        }
        if (!skip_undetermined || other.get("K") != 999) {
            this.set("K", other.get("K"));
            changed = true;
        }
        if (!skip_undetermined || other.get("Cl") != 999) {
            this.set("Cl", other.get("Cl"));
            changed = true;
        }
        if (!skip_undetermined || other.get("H2PO4") != 999) {
            this.set("H2PO4", other.get("H2PO4"));
            changed = true;
        }
        return changed;
    }

    public Vector<String> getIons() {
        Vector<String> ret = new Vector<String>();
        for (Map.Entry<String, Integer> e : this.ions.entrySet()) {
            ret.add(e.getKey());
        }
        return ret;
    }

    public int get(String charge_name) {
        Integer ret = this.ions.get(charge_name);
        return ret == null ? 0 : ret;
    }

    public void merge(IonCloud other) {
        this.merge("H", other);
        this.merge("Na", other);
        this.merge("Li", other);
        this.merge("K", other);
        this.merge("Cl", other);
        this.merge("H2PO4", other);
    }

    public void merge(String charge_name, IonCloud other) {
        if (other.get(charge_name) == 999) {
            this.set(charge_name, 999);
        } else if (this.get(charge_name) != other.get(charge_name)) {
            this.set(charge_name, 999);
        }
    }

    public int size() {
        return this.ionsNum;
    }

    public int getIonsNum() {
        return this.ionsNum;
    }

    public double getIonsMass() {
        return this.ionsTotalMass;
    }

    public Map<String, Integer> getIonsMap() {
        return this.ions;
    }

    public Molecule getMolecule() throws Exception {
        Molecule ret = new Molecule();
        for (Map.Entry<String, Integer> e : this.ions.entrySet()) {
            String charge = e.getKey();
            int num = e.getValue();
            if (charge.equals("H")) {
                ret.add(MassUtils.h_ion, num);
                continue;
            }
            if (charge.equals("Li")) {
                ret.add(MassUtils.li_ion, num);
                continue;
            }
            if (charge.equals("Na")) {
                ret.add(MassUtils.na_ion, num);
                continue;
            }
            if (charge.equals("K")) {
                ret.add(MassUtils.k_ion, num);
                continue;
            }
            if (charge.equals("Cl")) {
                ret.add(MassUtils.cl_ion, num);
                continue;
            }
            if (!charge.equals("H2PO4")) continue;
            ret.add(MassUtils.h2po4_ion, num);
        }
        return ret;
    }

    public static IonCloud fromString(String str) throws Exception {
        IonCloud ret = new IonCloud();
        ret.initFromString(str);
        return ret;
    }

    public void initFromString(String str) throws Exception {
        this.clear();
        if (str == null || str.length() == 0 || str.equals("0")) {
            return;
        }
        char[] str_buffer = str.toCharArray();
        int i = 0;
        while (i < str_buffer.length) {
            StringBuilder count = new StringBuilder();
            StringBuilder ion = new StringBuilder();
            if (str_buffer[i] == '+' || str_buffer[i] == '-') {
                if (str_buffer[i] == '-') {
                    count.append(str_buffer[i]);
                }
                ++i;
            }
            if (i == str_buffer.length) {
                throw new Exception("Invalid string format: <" + str + ">");
            }
            if (Character.isDigit(str_buffer[i])) {
                while (i < str_buffer.length && Character.isDigit(str_buffer[i])) {
                    count.append(str_buffer[i]);
                    ++i;
                }
            } else {
                count.append('1');
            }
            if (i == str_buffer.length) {
                throw new Exception("Invalid string format: <" + str + ">");
            }
            if (Character.isLetterOrDigit(str_buffer[i])) {
                while (i < str_buffer.length && Character.isLetterOrDigit(str_buffer[i])) {
                    ion.append(str_buffer[i]);
                    ++i;
                }
            } else {
                throw new Exception("Invalid string format: <" + str + ">");
            }
            this.add(ion.toString(), Integer.valueOf(count.toString()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.ions.entrySet()) {
            if (entry.getValue() <= 0) continue;
            if (sb.length() > 0) {
                sb.append('+');
            }
            if (entry.getValue() > 1) {
                sb.append(entry.getValue());
            }
            sb.append(entry.getKey());
        }
        for (Map.Entry<String, Integer> entry : this.ions.entrySet()) {
            if (entry.getValue() >= 0) continue;
            if (entry.getValue() == -1) {
                sb.append('-');
            } else {
                sb.append(entry.getValue());
            }
            sb.append(entry.getKey());
        }
        if (sb.length() == 0) {
            sb.append('0');
        }
        return sb.toString();
    }
}

