/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.file.reader.impl;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.file.FileReaderUtils;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.extquant.data.QuantPeak;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakData;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.file.reader.impl.ExternalQuantFileReader;
import org.grits.toolbox.ms.file.reader.impl.InvalidFileFormatException;
import org.grits.toolbox.ms.file.reader.impl.MzXmlReader;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;

public class MSXMLReader
extends ExternalQuantFileReader {
    private static final Logger logger = Logger.getLogger(MSXMLReader.class);
    private List<Peak> precursorPeaks = null;
    private Integer msLevel = null;
    private Integer parentScanNum = null;
    private Integer scanNum = null;

    public void setPrecursorPeaks(List<Peak> precursorPeaks) {
        this.precursorPeaks = precursorPeaks;
    }

    public List<Peak> getPrecursorPeaks() {
        return this.precursorPeaks;
    }

    public void setMsLevel(int msLevel) {
        this.msLevel = msLevel;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public void setParentScanNum(int parentScanNum) {
        this.parentScanNum = parentScanNum;
    }

    public int getParentScanNum() {
        return this.parentScanNum;
    }

    public void setScanNum(int scanNum) {
        this.scanNum = scanNum;
    }

    public int getScanNum() {
        return this.scanNum;
    }

    public QuantPeakData read(String a_file, boolean a_ppm, double a_intervalValue, int msLevel, int parentScanNum, int scanNum) {
        this.setMsLevel(msLevel);
        this.setParentScanNum(parentScanNum);
        this.setScanNum(scanNum);
        return this.read(a_file, a_ppm, a_intervalValue);
    }

    @Override
    public QuantPeakData read(String a_file, boolean a_ppm, double a_intervalValue) {
        this.m_ppm = a_ppm;
        this.m_intervalValue = a_intervalValue;
        try {
            MzXmlReader t_reader = new MzXmlReader();
            List<Scan> scans = t_reader.readMzXmlFile(a_file, this.getMsLevel(), this.getParentScanNum(), this.getScanNum());
            LinkedHashMap<Integer, Scan> t_data = FileReaderUtils.listToHashMap(scans);
            Scan t_scan = (Scan)t_data.get(1);
            this.m_data = new QuantPeakData();
            this.m_data.setMaxIntensity(t_scan.getMostAbundantPeak());
            this.setHeaderData(t_scan);
            for (Peak peak : this.precursorPeaks) {
                if (!peak.getIsPrecursor()) continue;
                QuantPeak qp = QuantPeak.getQuantPeakData(peak.getMz());
                double dTol = QuantPeakMatch.getDaTolerance(peak.getMz(), this.m_intervalValue, this.m_ppm);
                QuantPeakMatch qpm = QuantPeakMatch.findQuantPeakMatch(qp, peak.getMz(), t_scan.getPeaklist(), dTol);
                if (qpm == null) continue;
                qp.add(qpm);
                this.m_data.add(qp);
            }
        }
        catch (InvalidFileFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return this.m_data;
    }

    private void setHeaderData(Scan a_scan) throws InvalidFileFormatException {
        try {
            this.m_data.setScanNo(a_scan.getScanNo());
        }
        catch (Exception e) {
            throw new InvalidFileFormatException("Invalid scan number: " + a_scan.getScanNo());
        }
        try {
            this.m_data.setRetentionTime(a_scan.getRetentionTime());
        }
        catch (Exception e) {
            throw new InvalidFileFormatException("Invalid retention time: " + a_scan.getRetentionTime());
        }
    }

    @Override
    public boolean isValid(MSFile file) {
        MzXmlReader t_reader = new MzXmlReader();
        return t_reader.hasMS1Scan(file);
    }
}

